/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatArrayNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatObjectNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatPodNode;
import com.oracle.svm.core.genscavenge.graal.nodes.FormatStoredContinuationNode;
import com.oracle.svm.core.graal.snippets.DeoptTester;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.heap.OutOfMemoryUtil;
import com.oracle.svm.core.heap.Pod;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.events.ObjectAllocationInNewTLABEvent;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.replacements.AllocationSnippets;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawFieldOffset;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.struct.UniqueLocationIdentity;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class ThreadLocalAllocation {
    public static final FastThreadLocalWord<UnsignedWord> allocatedBytes = FastThreadLocalFactory.createWord("ThreadLocalAllocation.allocatedBytes");
    private static final FastThreadLocalBytes<Descriptor> regularTLAB = (FastThreadLocalBytes)FastThreadLocalFactory.createBytes(ThreadLocalAllocation::getTlabDescriptorSize, "ThreadLocalAllocation.regularTLAB").setMaxOffset(127);

    private ThreadLocalAllocation() {
    }

    @Fold
    static Log log() {
        return Log.noopLog();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static int getTlabDescriptorSize() {
        return SizeOf.get(Descriptor.class);
    }

    public static Word getTlabAddress() {
        return (Word)regularTLAB.getAddress();
    }

    @Uninterruptible(reason="Accesses TLAB", callerMustBe=true)
    public static Descriptor getTlab(IsolateThread vmThread) {
        return regularTLAB.getAddress(vmThread);
    }

    @Uninterruptible(reason="Accesses TLAB", callerMustBe=true)
    private static Descriptor getTlab() {
        return regularTLAB.getAddress();
    }

    private static void runSlowPathHooks() {
        GCImpl.getPolicy().updateSizeParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object slowPathNewInstance(Word objectHeader) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            DynamicHub hub = ObjectHeaderImpl.getObjectHeaderImpl().dynamicHubFromObjectHeader(objectHeader);
            Object result = ThreadLocalAllocation.slowPathNewInstanceWithoutAllocating(hub);
            ThreadLocalAllocation.runSlowPathHooks();
            Object object = result;
            return object;
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    private static Object slowPathNewInstanceWithoutAllocating(DynamicHub hub) {
        DeoptTester.disableDeoptTesting();
        long startTicks = JfrTicks.elapsedTicks();
        UnsignedWord size = LayoutEncoding.getPureInstanceAllocationSize(hub.getLayoutEncoding());
        try {
            HeapImpl.exitIfAllocationDisallowed("ThreadLocalAllocation.slowPathNewInstanceWithoutAllocating", DynamicHub.toClass(hub).getName());
            GCImpl.getGCImpl().maybeCollectOnAllocation(size);
            AlignedHeapChunk.AlignedHeader newTlab = HeapImpl.getChunkProvider().produceAlignedChunk();
            Object object = ThreadLocalAllocation.allocateInstanceInNewTlab(hub, size, newTlab);
            return object;
        }
        finally {
            ObjectAllocationInNewTLABEvent.emit(startTicks, hub, size, HeapParameters.getAlignedHeapChunkSize());
            DeoptTester.enableDeoptTesting();
        }
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object slowPathNewArray(Word objectHeader, int length) {
        return ThreadLocalAllocation.slowPathNewArrayLikeObject(objectHeader, length, null);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object slowPathNewStoredContinuation(Word objectHeader, int length) {
        return ThreadLocalAllocation.slowPathNewArrayLikeObject(objectHeader, length, null);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object slowPathNewPodInstance(Word objectHeader, int arrayLength, byte[] referenceMap) {
        return ThreadLocalAllocation.slowPathNewArrayLikeObject(objectHeader, arrayLength, referenceMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object slowPathNewArrayLikeObject(Word objectHeader, int length, byte[] podReferenceMap) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            if (length < 0) {
                throw new NegativeArraySizeException();
            }
            DynamicHub hub = ObjectHeaderImpl.getObjectHeaderImpl().dynamicHubFromObjectHeader(objectHeader);
            UnsignedWord size = LayoutEncoding.getArrayAllocationSize(hub.getLayoutEncoding(), length);
            GCImpl.getPolicy().ensureSizeParametersInitialized();
            if (size.aboveOrEqual(GCImpl.getPolicy().getMaximumHeapSize())) {
                OutOfMemoryError outOfMemoryError = new OutOfMemoryError("Array allocation too large.");
                throw OutOfMemoryUtil.reportOutOfMemoryError(outOfMemoryError);
            }
            Object result = ThreadLocalAllocation.slowPathNewArrayLikeObject0(hub, length, size, podReferenceMap);
            ThreadLocalAllocation.runSlowPathHooks();
            Object object = result;
            return object;
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of allocation.")
    private static Object slowPathNewArrayLikeObject0(DynamicHub hub, int length, UnsignedWord size, byte[] podReferenceMap) {
        DeoptTester.disableDeoptTesting();
        long startTicks = JfrTicks.elapsedTicks();
        UnsignedWord tlabSize = HeapParameters.getAlignedHeapChunkSize();
        try {
            HeapImpl.exitIfAllocationDisallowed("ThreadLocalAllocation.slowPathNewArrayOrPodWithoutAllocating", DynamicHub.toClass(hub).getName());
            GCImpl.getGCImpl().maybeCollectOnAllocation(size);
            if (size.aboveOrEqual(HeapParameters.getLargeArrayThreshold())) {
                boolean needsZeroing = !HeapChunkProvider.areUnalignedChunksZeroed();
                UnalignedHeapChunk.UnalignedHeader newTlabChunk = HeapImpl.getChunkProvider().produceUnalignedChunk(size);
                tlabSize = UnalignedHeapChunk.getChunkSizeForObject(size);
                Object object = ThreadLocalAllocation.allocateLargeArrayLikeObjectInNewTlab(hub, length, size, newTlabChunk, needsZeroing, podReferenceMap);
                return object;
            }
            Object array = ThreadLocalAllocation.allocateSmallArrayLikeObjectInCurrentTlab(hub, length, size, podReferenceMap);
            if (array == null) {
                AlignedHeapChunk.AlignedHeader newTlabChunk = HeapImpl.getChunkProvider().produceAlignedChunk();
                array = ThreadLocalAllocation.allocateSmallArrayLikeObjectInNewTlab(hub, length, size, newTlabChunk, podReferenceMap);
            }
            Object object = array;
            return object;
        }
        finally {
            ObjectAllocationInNewTLABEvent.emit(startTicks, hub, size, tlabSize);
            DeoptTester.enableDeoptTesting();
        }
    }

    @Uninterruptible(reason="Holds uninitialized memory.")
    private static Object allocateInstanceInNewTlab(DynamicHub hub, UnsignedWord size, AlignedHeapChunk.AlignedHeader newTlabChunk) {
        assert (size.equal(LayoutEncoding.getPureInstanceAllocationSize(hub.getLayoutEncoding())));
        Pointer memory = ThreadLocalAllocation.allocateRawMemoryInNewTlab(size, newTlabChunk);
        return FormatObjectNode.formatObject(memory, DynamicHub.toClass(hub), false, AllocationSnippets.FillContent.WITH_ZEROES, true);
    }

    @Uninterruptible(reason="Holds uninitialized memory.")
    private static Object allocateSmallArrayLikeObjectInCurrentTlab(DynamicHub hub, int length, UnsignedWord size, byte[] podReferenceMap) {
        if (size.aboveThan(ThreadLocalAllocation.availableTlabMemory(ThreadLocalAllocation.getTlab()))) {
            return null;
        }
        Pointer memory = ThreadLocalAllocation.allocateRawMemoryInTlab(size, ThreadLocalAllocation.getTlab());
        return ThreadLocalAllocation.formatArrayLikeObject(memory, hub, length, false, AllocationSnippets.FillContent.WITH_ZEROES, podReferenceMap);
    }

    @Uninterruptible(reason="Holds uninitialized memory.")
    private static Object allocateSmallArrayLikeObjectInNewTlab(DynamicHub hub, int length, UnsignedWord size, AlignedHeapChunk.AlignedHeader newTlabChunk, byte[] podReferenceMap) {
        Pointer memory = ThreadLocalAllocation.allocateRawMemoryInNewTlab(size, newTlabChunk);
        return ThreadLocalAllocation.formatArrayLikeObject(memory, hub, length, false, AllocationSnippets.FillContent.WITH_ZEROES, podReferenceMap);
    }

    @Uninterruptible(reason="Holds uninitialized memory, modifies TLAB")
    private static Object allocateLargeArrayLikeObjectInNewTlab(DynamicHub hub, int length, UnsignedWord size, UnalignedHeapChunk.UnalignedHeader newTlabChunk, boolean needsZeroing, byte[] podReferenceMap) {
        Descriptor tlab = ThreadLocalAllocation.getTlab();
        HeapChunk.setNext(newTlabChunk, tlab.getUnalignedChunk());
        tlab.setUnalignedChunk(newTlabChunk);
        allocatedBytes.set(allocatedBytes.get().add(size));
        HeapImpl.getAccounting().increaseEdenUsedBytes(size);
        Pointer memory = UnalignedHeapChunk.allocateMemory(newTlabChunk, size);
        assert (memory.isNonNull());
        if (!needsZeroing && SubstrateGCOptions.VerifyHeap.getValue().booleanValue()) {
            ThreadLocalAllocation.guaranteeZeroed(memory, size);
        }
        AllocationSnippets.FillContent fillKind = needsZeroing ? AllocationSnippets.FillContent.WITH_ZEROES : AllocationSnippets.FillContent.DO_NOT_FILL;
        return ThreadLocalAllocation.formatArrayLikeObject(memory, hub, length, true, fillKind, podReferenceMap);
    }

    @Uninterruptible(reason="Holds uninitialized memory")
    private static Object formatArrayLikeObject(Pointer memory, DynamicHub hub, int length, boolean unaligned, AllocationSnippets.FillContent fillContent, byte[] podReferenceMap) {
        Class<?> clazz = DynamicHub.toClass(hub);
        if (ContinuationSupport.isSupported() && clazz == StoredContinuation.class) {
            return FormatStoredContinuationNode.formatStoredContinuation(memory, clazz, length, false, unaligned, true);
        }
        if (Pod.RuntimeSupport.isPresent() && podReferenceMap != null) {
            return FormatPodNode.formatPod(memory, clazz, length, podReferenceMap, false, unaligned, fillContent, true);
        }
        return FormatArrayNode.formatArray(memory, clazz, length, false, unaligned, fillContent, true);
    }

    @Uninterruptible(reason="Returns uninitialized memory, modifies TLAB", callerMustBe=true)
    private static Pointer allocateRawMemoryInNewTlab(UnsignedWord size, AlignedHeapChunk.AlignedHeader newTlabChunk) {
        assert (DeoptTester.enabled() || ThreadLocalAllocation.availableTlabMemory(ThreadLocalAllocation.getTlab()).belowThan(size)) : "Slowpath allocation was used even though TLAB had sufficient space";
        Descriptor tlab = ThreadLocalAllocation.retireCurrentAllocationChunk(CurrentIsolate.getCurrentThread());
        ThreadLocalAllocation.registerNewAllocationChunk(tlab, newTlabChunk);
        return ThreadLocalAllocation.allocateRawMemoryInTlab(size, tlab);
    }

    @Uninterruptible(reason="Returns uninitialized memory, modifies TLAB", callerMustBe=true)
    private static Pointer allocateRawMemoryInTlab(UnsignedWord size, Descriptor tlab) {
        assert (size.belowOrEqual(ThreadLocalAllocation.availableTlabMemory(tlab))) : "Not enough TLAB space for allocation";
        Pointer top = KnownIntrinsics.nonNullPointer((Pointer)tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY));
        tlab.setAllocationTop(top.add(size), SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
        return top;
    }

    @Uninterruptible(reason="Accesses TLAB")
    private static UnsignedWord availableTlabMemory(Descriptor allocator) {
        Word top = allocator.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
        Word end = allocator.getAllocationEnd(SubstrateAllocationSnippets.TLAB_END_IDENTITY);
        assert (top.belowOrEqual((UnsignedWord)end));
        if (top.isNull() || end.isNull()) {
            return WordFactory.unsigned((int)0);
        }
        return end.subtract((UnsignedWord)top);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void guaranteeZeroed(Pointer memory, UnsignedWord size) {
        Pointer pos = memory;
        Pointer end = memory.add(size);
        while (pos.belowThan((UnsignedWord)end)) {
            VMError.guarantee(pos.readByte(0) == 0);
            pos = pos.add(1);
        }
    }

    static void disableAndFlushForAllThreads() {
        VMOperation.guaranteeInProgress("ThreadLocalAllocation.disableAndFlushForAllThreads");
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            IsolateThread vmThread = VMThreads.firstThread();
            while (vmThread.isNonNull()) {
                ThreadLocalAllocation.disableAndFlushForThread(vmThread);
                vmThread = VMThreads.nextThread(vmThread);
            }
        } else {
            ThreadLocalAllocation.disableAndFlushForThread((IsolateThread)WordFactory.nullPointer());
        }
    }

    @Uninterruptible(reason="Accesses TLAB")
    static void disableAndFlushForThread(IsolateThread vmThread) {
        ThreadLocalAllocation.retireTlabToEden(vmThread);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void tearDown() {
        IsolateThread thread = (IsolateThread)WordFactory.nullPointer();
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            thread = VMThreads.firstThreadUnsafe();
            VMError.guarantee(VMThreads.nextThread(thread).isNull(), "Other isolate threads are still active");
        }
        ThreadLocalAllocation.freeHeapChunks(ThreadLocalAllocation.getTlab(thread));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void freeHeapChunks(Descriptor tlab) {
        HeapChunkProvider.freeAlignedChunkList(tlab.getAlignedChunk());
        HeapChunkProvider.freeUnalignedChunkList(tlab.getUnalignedChunk());
    }

    @Uninterruptible(reason="Accesses TLAB")
    static void suspendInCurrentThread() {
        ThreadLocalAllocation.retireCurrentAllocationChunk(CurrentIsolate.getCurrentThread());
    }

    @Uninterruptible(reason="Accesses TLAB")
    private static void retireTlabToEden(IsolateThread thread) {
        HeapChunk.Header<AlignedHeapChunk.AlignedHeader> next;
        VMThreads.guaranteeOwnsThreadMutex("Otherwise, we wouldn't be allowed to access the space.", true);
        Descriptor tlab = ThreadLocalAllocation.retireCurrentAllocationChunk(thread);
        AlignedHeapChunk.AlignedHeader alignedChunk = tlab.getAlignedChunk();
        HeapChunk.Header<UnalignedHeapChunk.UnalignedHeader> unalignedChunk = tlab.getUnalignedChunk();
        tlab.setAlignedChunk((AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer());
        tlab.setUnalignedChunk((UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer());
        Space eden = HeapImpl.getHeapImpl().getYoungGeneration().getEden();
        while (alignedChunk.isNonNull()) {
            next = HeapChunk.getNext(alignedChunk);
            HeapChunk.setNext(alignedChunk, (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer());
            eden.appendAlignedHeapChunk(alignedChunk);
            alignedChunk = next;
        }
        while (unalignedChunk.isNonNull()) {
            next = HeapChunk.getNext(unalignedChunk);
            HeapChunk.setNext(unalignedChunk, (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer());
            eden.appendUnalignedHeapChunk((UnalignedHeapChunk.UnalignedHeader)unalignedChunk);
            unalignedChunk = next;
        }
    }

    @Uninterruptible(reason="Modifies TLAB")
    private static void registerNewAllocationChunk(Descriptor tlab, AlignedHeapChunk.AlignedHeader newChunk) {
        assert (tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY).isNull());
        assert (tlab.getAllocationEnd(SubstrateAllocationSnippets.TLAB_END_IDENTITY).isNull());
        HeapChunk.setNext(newChunk, tlab.getAlignedChunk());
        tlab.setAlignedChunk(newChunk);
        HeapImpl.getAccounting().increaseEdenUsedBytes(HeapParameters.getAlignedHeapChunkSize());
        tlab.setAllocationTop(HeapChunk.getTopPointer(newChunk), SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
        tlab.setAllocationEnd(HeapChunk.getEndPointer(newChunk), SubstrateAllocationSnippets.TLAB_END_IDENTITY);
        HeapChunk.setTopPointer(newChunk, (Pointer)WordFactory.nullPointer());
    }

    @Uninterruptible(reason="Modifies and returns TLAB", callerMustBe=true)
    private static Descriptor retireCurrentAllocationChunk(IsolateThread thread) {
        Descriptor tlab = ThreadLocalAllocation.getTlab(thread);
        Word allocationTop = tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
        if (allocationTop.isNonNull()) {
            AlignedHeapChunk.AlignedHeader alignedChunk = tlab.getAlignedChunk();
            assert (HeapChunk.getTopPointer(alignedChunk).isNull());
            assert (HeapChunk.getEndPointer(alignedChunk).equal((UnsignedWord)tlab.getAllocationEnd(SubstrateAllocationSnippets.TLAB_END_IDENTITY)));
            HeapChunk.setTopPointer(alignedChunk, (Pointer)allocationTop);
            tlab.setAllocationTop((Pointer)WordFactory.nullPointer(), SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
            tlab.setAllocationEnd((Pointer)WordFactory.nullPointer(), SubstrateAllocationSnippets.TLAB_END_IDENTITY);
            Pointer usedTlabSize = HeapChunk.getTopPointer(alignedChunk).subtract((UnsignedWord)AlignedHeapChunk.getObjectsStart(alignedChunk));
            allocatedBytes.set(thread, allocatedBytes.get(thread).add((UnsignedWord)usedTlabSize));
        }
        return tlab;
    }

    @RawStructure
    public static interface Descriptor
    extends PointerBase {
        @RawField
        @UniqueLocationIdentity
        public AlignedHeapChunk.AlignedHeader getAlignedChunk();

        @RawField
        @UniqueLocationIdentity
        public void setAlignedChunk(AlignedHeapChunk.AlignedHeader var1);

        @RawField
        @UniqueLocationIdentity
        public UnalignedHeapChunk.UnalignedHeader getUnalignedChunk();

        @RawField
        @UniqueLocationIdentity
        public void setUnalignedChunk(UnalignedHeapChunk.UnalignedHeader var1);

        @RawField
        public Word getAllocationTop(LocationIdentity var1);

        @RawField
        public void setAllocationTop(Pointer var1, LocationIdentity var2);

        @RawFieldOffset
        public static int offsetOfAllocationTop() {
            throw VMError.shouldNotReachHereAtRuntime();
        }

        @RawField
        public Word getAllocationEnd(LocationIdentity var1);

        @RawField
        public void setAllocationEnd(Pointer var1, LocationIdentity var2);

        @RawFieldOffset
        public static int offsetOfAllocationEnd() {
            throw VMError.shouldNotReachHereAtRuntime();
        }
    }
}

