/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.thread;

import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import com.oracle.svm.core.threadlocal.VMThreadLocalSTSupport;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.nativeimage.ImageSingletons;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_1)
public class VMThreadLocalSTHolderNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<VMThreadLocalSTHolderNode> TYPE = NodeClass.create(VMThreadLocalSTHolderNode.class);
    protected final VMThreadLocalInfo threadLocalInfo;

    public VMThreadLocalSTHolderNode(VMThreadLocalInfo threadLocalInfo) {
        super(TYPE, StampFactory.objectNonNull());
        this.threadLocalInfo = threadLocalInfo;
    }

    public VMThreadLocalInfo getThreadLocalInfo() {
        return this.threadLocalInfo;
    }

    public void generate(NodeLIRBuilderTool gen) {
        Object[] holder = this.threadLocalInfo.isObject ? ((VMThreadLocalSTSupport)ImageSingletons.lookup(VMThreadLocalSTSupport.class)).objectThreadLocals : (Object[])((VMThreadLocalSTSupport)ImageSingletons.lookup(VMThreadLocalSTSupport.class)).primitiveThreadLocals;
        SnippetReflectionProvider snippetReflection = gen.getLIRGeneratorTool().getSnippetReflection();
        LIRKind kind = gen.getLIRGeneratorTool().getLIRKind(this.stamp(NodeView.DEFAULT));
        gen.setResult((ValueNode)this, (Value)gen.getLIRGeneratorTool().emitLoadConstant((ValueKind)kind, (Constant)snippetReflection.forObject((Object)holder)));
    }
}

