/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.word;

import com.oracle.svm.core.graal.word.DynamicHubAccess;
import com.oracle.svm.core.graal.word.SubstrateOperation;
import java.lang.reflect.AnnotatedElement;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.gc.BarrierSet;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.memory.FixedAccessNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.word.WordOperationPlugin;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.word.LocationIdentity;

public class SubstrateWordOperationPlugins
extends WordOperationPlugin {
    public SubstrateWordOperationPlugins(SnippetReflectionProvider snippetReflection, ConstantReflectionProvider constantReflection, WordTypes wordTypes, BarrierSet barrierSet) {
        super(snippetReflection, constantReflection, wordTypes, barrierSet);
    }

    public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        if (!this.wordTypes.isWordOperation(method) && !method.getDeclaringClass().equals((Object)b.getMetaAccess().lookupJavaType(DynamicHubAccess.class))) {
            return false;
        }
        SubstrateOperation operation = (SubstrateOperation)AnnotationAccess.getAnnotation((AnnotatedElement)method, SubstrateOperation.class);
        if (operation == null) {
            this.processWordOperation(b, args, this.wordTypes.getWordOperation(method, b.getMethod().getDeclaringClass()));
            return true;
        }
        this.processSubstrateOperation(b, method, args, operation);
        return true;
    }

    protected void processSubstrateOperation(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args, SubstrateOperation operation) {
        switch (operation.opcode()) {
            case READ_FROM_HUB: {
                JavaKind returnKind = method.getSignature().getReturnKind();
                GraalError.guarantee((args.length == 4 ? 1 : 0) != 0, (String)"arg length=%d operation=%s", (Object)args.length, (Object)operation);
                JavaKind readKind = this.wordTypes.asKind(method.getSignature().getReturnType(method.getDeclaringClass()));
                AddressNode address = this.makeAddress(b, args[0], args[1]);
                assert (args[2].isConstant()) : args[2];
                LocationIdentity location = (LocationIdentity)this.snippetReflection.asObject(LocationIdentity.class, args[2].asJavaConstant());
                assert (location != null) : this.snippetReflection.asObject(Object.class, args[2].asJavaConstant());
                FixedAccessNode read = (FixedAccessNode)b.add((Node)new ReadNode(address, location, StampFactory.forKind((JavaKind)readKind), BarrierType.NONE, MemoryOrderMode.PLAIN));
                if (!(args[3] instanceof ConstantNode)) {
                    read.setGuard((GuardingNode)args[3]);
                }
                b.push(returnKind, (ValueNode)read);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere((String)("Unknown operation " + String.valueOf(operation)));
            }
        }
    }
}

