/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.locks;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.locks.VMLockingPrimitive;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class VMCondition
extends VMLockingPrimitive {
    protected final VMMutex mutex;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final String name;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public VMCondition(VMMutex mutex) {
        this(mutex, null);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public VMCondition(VMMutex mutex, String name) {
        this.mutex = mutex;
        this.name = name;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public String getName() {
        return this.name == null ? this.mutex.getName() : this.mutex.getName() + "_" + this.name;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public String getConditionName() {
        return this.name;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public VMMutex getMutex() {
        return this.mutex;
    }

    public void block() {
        throw VMError.shouldNotReachHere("VMCondition cannot be used during native image generation");
    }

    @Uninterruptible(reason="Should only be called if the thread did an explicit transition to native earlier.", callerMustBe=true)
    public void blockNoTransition() {
        throw VMError.shouldNotReachHere("VMCondition cannot be used during native image generation");
    }

    public long block(long nanoseconds) {
        throw VMError.shouldNotReachHere("VMCondition cannot be used during native image generation");
    }

    @Uninterruptible(reason="Should only be called if the thread did an explicit transition to native earlier.", callerMustBe=true)
    public long blockNoTransition(long nanoseconds) {
        throw VMError.shouldNotReachHere("VMCondition cannot be used during native image generation");
    }

    @Uninterruptible(reason="Should only be called if the thread did an explicit transition to native earlier.", callerMustBe=true)
    public void blockNoTransitionUnspecifiedOwner() {
        throw VMError.shouldNotReachHere("VMCondition cannot be used during native image generation");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void signal() {
        throw VMError.shouldNotReachHere("VMCondition cannot be used during native image generation");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void broadcast() {
        throw VMError.shouldNotReachHere("VMCondition cannot be used during native image generation");
    }
}

