/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrFrameType;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrStackTraceRepository;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.events.ExecutionSampleEvent;
import com.oracle.svm.core.sampler.SamplerStackTraceSerializer;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class SamplerJfrStackTraceSerializer
implements SamplerStackTraceSerializer {
    private static final CodeInfoDecoder.FrameInfoCursor FRAME_INFO_CURSOR = new CodeInfoDecoder.FrameInfoCursor();

    @Override
    @Uninterruptible(reason="Prevent JFR recording and epoch change.")
    public Pointer serializeStackTrace(Pointer rawStackTrace, Pointer bufferEnd, int sampleSize, int sampleHash, boolean isTruncated, long sampleTick, long threadId, long threadState) {
        Pointer current = rawStackTrace;
        CIntPointer statusPtr = (CIntPointer)StackValue.get(CIntPointer.class);
        JfrStackTraceRepository.JfrStackTraceTableEntry entry = SubstrateJVM.getStackTraceRepo().getOrPutStackTrace(current, WordFactory.unsigned((int)sampleSize), sampleHash, statusPtr);
        long stackTraceId = entry.isNull() ? 0L : entry.getId();
        int status = statusPtr.read();
        if (status == 1 || status == 2) {
            assert (current.add(sampleSize).belowThan((UnsignedWord)bufferEnd));
            boolean serialized = SamplerJfrStackTraceSerializer.serializeStackTrace(current, sampleSize, isTruncated, stackTraceId);
            if (serialized) {
                SubstrateJVM.getStackTraceRepo().commitSerializedStackTrace(entry);
            }
        } else assert (status == 4 || status == 8);
        current = current.add(sampleSize);
        long endMarker = current.readLong(0);
        if (endMarker == -2L) {
            if (stackTraceId != 0L) {
                ExecutionSampleEvent.writeExecutionSample(sampleTick, threadId, stackTraceId, threadState);
            } else {
                JfrThreadLocal.increaseMissedSamples();
            }
        } else assert (endMarker == -1L);
        current = current.add(8);
        return current;
    }

    @Uninterruptible(reason="Prevent JFR recording and epoch change.")
    private static boolean serializeStackTrace(Pointer rawStackTrace, int sampleSize, boolean isTruncated, long stackTraceId) {
        assert (sampleSize % 8 == 0);
        JfrBuffer targetBuffer = SubstrateJVM.getStackTraceRepo().getCurrentBuffer();
        if (targetBuffer.isNull()) {
            return false;
        }
        int numStackTraceElements = SamplerJfrStackTraceSerializer.visitRawStackTrace(rawStackTrace, sampleSize, (JfrNativeEventWriterData)WordFactory.nullPointer());
        if (numStackTraceElements == 0) {
            return false;
        }
        JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
        JfrNativeEventWriterDataAccess.initialize(data, targetBuffer);
        JfrNativeEventWriter.putLong(data, stackTraceId);
        JfrNativeEventWriter.putBoolean(data, isTruncated);
        JfrNativeEventWriter.putInt(data, numStackTraceElements);
        SamplerJfrStackTraceSerializer.visitRawStackTrace(rawStackTrace, sampleSize, data);
        boolean success = JfrNativeEventWriter.commit(data);
        SubstrateJVM.getStackTraceRepo().setCurrentBuffer(data.getJfrBuffer());
        return success;
    }

    @Uninterruptible(reason="Prevent JFR recording and epoch change.")
    private static int visitRawStackTrace(Pointer rawStackTrace, int sampleSize, JfrNativeEventWriterData data) {
        int numStackTraceElements = 0;
        Pointer rawStackTraceEnd = rawStackTrace.add(sampleSize);
        Pointer ipPtr = rawStackTrace;
        while (ipPtr.belowThan((UnsignedWord)rawStackTraceEnd)) {
            long ip = ipPtr.readLong(0);
            numStackTraceElements += SamplerJfrStackTraceSerializer.visitFrame(data, ip);
            ipPtr = ipPtr.add(8);
        }
        return numStackTraceElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Prevent JFR recording, epoch change, and that the GC frees the CodeInfo.")
    private static int visitFrame(JfrNativeEventWriterData data, long address) {
        CodePointer ip = (CodePointer)WordFactory.pointer((long)address);
        UntetheredCodeInfo untetheredInfo = CodeInfoTable.lookupCodeInfo(ip);
        if (untetheredInfo.isNull()) {
            VMError.shouldNotReachHere("Stack walk must walk only frames of known code.");
        }
        Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
        try {
            CodeInfo tetheredCodeInfo = CodeInfoAccess.convert(untetheredInfo, tether);
            int n = SamplerJfrStackTraceSerializer.visitFrame(data, tetheredCodeInfo, ip);
            return n;
        }
        finally {
            CodeInfoAccess.releaseTether(untetheredInfo, tether);
        }
    }

    @Uninterruptible(reason="Prevent JFR recording and epoch change.")
    private static int visitFrame(JfrNativeEventWriterData data, CodeInfo codeInfo, CodePointer ip) {
        int numStackTraceElements = 0;
        FRAME_INFO_CURSOR.initialize(codeInfo, ip, false);
        while (FRAME_INFO_CURSOR.advance()) {
            if (data.isNonNull()) {
                FrameInfoQueryResult frame = FRAME_INFO_CURSOR.get();
                SamplerJfrStackTraceSerializer.serializeStackTraceElement(data, frame);
            }
            ++numStackTraceElements;
        }
        return numStackTraceElements;
    }

    @Uninterruptible(reason="Prevent JFR recording and epoch change.")
    private static void serializeStackTraceElement(JfrNativeEventWriterData data, FrameInfoQueryResult stackTraceElement) {
        long methodId = SubstrateJVM.getMethodRepo().getMethodId(stackTraceElement.getSourceClass(), stackTraceElement.getSourceMethodName(), stackTraceElement.getMethodId());
        JfrNativeEventWriter.putLong(data, methodId);
        JfrNativeEventWriter.putInt(data, stackTraceElement.getSourceLineNumber());
        JfrNativeEventWriter.putInt(data, stackTraceElement.getBci());
        JfrNativeEventWriter.putLong(data, JfrFrameType.FRAME_AOT_COMPILED.getId());
    }
}

