/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.ClassLoaderSupport;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.ResourceConfigurationParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.ConfigurationTypeResolver;
import com.oracle.svm.hosted.DeadlockWatchdog;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.LinkAtBuildTimeSupport;
import com.oracle.svm.hosted.ReachabilityRegistrationNode;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.jdk.localization.LocalizationFeature;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeResourceAccess;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeResourceSupport;

@AutomaticallyRegisteredFeature
public final class ResourcesFeature
implements InternalFeature {
    static final String MODULE_NAME_ALL_UNNAMED = "ALL-UNNAMED";
    private boolean sealed = false;
    private Set<ConditionalPattern> resourcePatternWorkSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> excludedResourcePatterns = Collections.newSetFromMap(new ConcurrentHashMap());
    private int loadedConfigurations;
    private ImageClassLoader imageClassLoader;

    public void afterRegistration(Feature.AfterRegistrationAccess a) {
        FeatureImpl.AfterRegistrationAccessImpl access = (FeatureImpl.AfterRegistrationAccessImpl)a;
        this.imageClassLoader = access.getImageClassLoader();
        ResourcesRegistryImpl resourcesRegistry = new ResourcesRegistryImpl(new ConfigurationTypeResolver("resource configuration", this.imageClassLoader));
        ImageSingletons.add(ResourcesRegistry.class, (Object)resourcesRegistry);
        ImageSingletons.add(RuntimeResourceSupport.class, (Object)resourcesRegistry);
    }

    private static ResourcesRegistryImpl resourceRegistryImpl() {
        return (ResourcesRegistryImpl)ImageSingletons.lookup(ResourcesRegistry.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        ResourceConfigurationParser parser = new ResourceConfigurationParser((ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class), ConfigurationFiles.Options.StrictConfiguration.getValue());
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurations((ConfigurationParser)parser, this.imageClassLoader, "resource", ConfigurationFiles.Options.ResourceConfigurationFiles, ConfigurationFiles.Options.ResourceConfigurationResources, ConfigurationFile.RESOURCES.getFileName());
        this.resourcePatternWorkSet.addAll(Options.IncludeResources.getValue().values().stream().map(e -> new ConditionalPattern(ConfigurationCondition.alwaysTrue(), (String)e)).toList());
        this.excludedResourcePatterns.addAll(Options.ExcludeResources.getValue().values());
        if (!this.resourcePatternWorkSet.isEmpty()) {
            FeatureImpl.BeforeAnalysisAccessImpl beforeAnalysisAccess = (FeatureImpl.BeforeAnalysisAccessImpl)access;
            Set<CompiledConditionalPattern> includePatterns = this.resourcePatternWorkSet.stream().map(e -> new CompiledConditionalPattern(e.condition(), this.makeResourcePattern(e.pattern()))).collect(Collectors.toSet());
            if (MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                includePatterns.stream().map(pattern -> pattern.compiledPattern).forEach(resourcePattern -> Resources.singleton().registerIncludePattern(resourcePattern.moduleName, resourcePattern.pattern.pattern()));
            }
            ResourcePattern[] excludePatterns = this.compilePatterns(this.excludedResourcePatterns);
            ResourceCollectorImpl collector = new ResourceCollectorImpl(includePatterns, excludePatterns, beforeAnalysisAccess);
            try {
                collector.prepareProgressReporter();
                ((ClassLoaderSupport)ImageSingletons.lookup(ClassLoaderSupport.class)).collectResources(collector);
            }
            finally {
                collector.shutDownProgressReporter();
            }
            this.resourcePatternWorkSet = Set.of();
        }
        ResourcesFeature.resourceRegistryImpl().flushConditionalConfiguration(access);
    }

    private ResourcePattern[] compilePatterns(Set<String> patterns) {
        return patterns.stream().filter(s -> s.length() > 0).map(this::makeResourcePattern).toList().toArray(new ResourcePattern[0]);
    }

    private ResourcePattern makeResourcePattern(String rawPattern) {
        String[] moduleNameWithPattern = SubstrateUtil.split(rawPattern, ":", 2);
        if (moduleNameWithPattern.length < 2) {
            return new ResourcePattern(null, Pattern.compile(moduleNameWithPattern[0]));
        }
        String moduleName = moduleNameWithPattern[0];
        return new ResourcePattern(moduleName, Pattern.compile(moduleNameWithPattern[1]));
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.sealed = true;
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (!ImageSingletons.contains(FallbackFeature.class)) {
            return;
        }
        FallbackFeature.FallbackImageRequest resourceFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).resourceFallback;
        if (resourceFallback != null && Options.IncludeResources.getValue().values().isEmpty() && this.loadedConfigurations == 0) {
            throw resourceFallback;
        }
    }

    @Override
    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        if (!reason.duringAnalysis() || reason == ParsingReason.JITCompilation) {
            return;
        }
        Method[] resourceMethods = new Method[]{ReflectionUtil.lookupMethod(Class.class, (String)"getResource", (Class[])new Class[]{String.class}), ReflectionUtil.lookupMethod(Class.class, (String)"getResourceAsStream", (Class[])new Class[]{String.class})};
        Method resolveResourceName = ReflectionUtil.lookupMethod(Class.class, (String)"resolveName", (Class[])new Class[]{String.class});
        for (Method method : resourceMethods) {
            this.registerResourceRegistrationPlugin(plugins.getInvocationPlugins(), method, snippetReflection, resolveResourceName, reason);
        }
    }

    private void registerResourceRegistrationPlugin(InvocationPlugins plugins, Method method, final SnippetReflectionProvider snippetReflectionProvider, final Method resolveResourceName, final ParsingReason reason) {
        ArrayList parameterTypes = new ArrayList();
        assert (!Modifier.isStatic(method.getModifiers()));
        parameterTypes.add(InvocationPlugin.Receiver.class);
        parameterTypes.addAll(Arrays.asList(method.getParameterTypes()));
        plugins.register(method.getDeclaringClass(), (InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, method.getName(), parameterTypes.toArray(new Class[0])){
            final /* synthetic */ ResourcesFeature this$0;
            {
                this.this$0 = this$0;
                super(name, argumentTypes);
            }

            public boolean isDecorator() {
                return true;
            }

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg) {
                try {
                    if (!this.this$0.sealed && receiver.isConstant() && arg.isJavaConstant() && !arg.isNullConstant()) {
                        Class clazz = (Class)snippetReflectionProvider.asObject(Class.class, receiver.get().asJavaConstant());
                        String resource = (String)snippetReflectionProvider.asObject(String.class, arg.asJavaConstant());
                        String resourceName = (String)resolveResourceName.invoke((Object)clazz, resource);
                        b.add((Node)ReachabilityRegistrationNode.create(() -> RuntimeResourceAccess.addResource((Module)clazz.getModule(), (String)resourceName), reason));
                        return true;
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw VMError.shouldNotReachHere(e);
                }
                return false;
            }
        });
    }

    private class ResourcesRegistryImpl
    extends ConditionalConfigurationRegistry
    implements ResourcesRegistry {
        private final ConfigurationTypeResolver configurationTypeResolver;
        private final Set<String> alreadyAddedResources = new HashSet<String>();

        ResourcesRegistryImpl(ConfigurationTypeResolver configurationTypeResolver) {
            this.configurationTypeResolver = configurationTypeResolver;
        }

        @Override
        public void addResources(ConfigurationCondition condition, String pattern) {
            if (this.configurationTypeResolver.resolveConditionType(condition.getTypeName()) == null) {
                return;
            }
            try {
                ResourcesFeature.this.resourcePatternWorkSet.add(new ConditionalPattern(condition, pattern));
            }
            catch (UnsupportedOperationException e) {
                throw UserError.abort("Resource registration should be performed before beforeAnalysis phase.", new Object[0]);
            }
        }

        public void addResource(Module module, String resourcePath) {
            if (!this.shouldRegisterResource(module, resourcePath)) {
                return;
            }
            if (module != null && module.isNamed()) {
                this.processResourceFromModule(module, resourcePath);
            } else {
                this.processResourceFromClasspath(resourcePath);
            }
        }

        public void injectResource(Module module, String resourcePath, byte[] resourceContent) {
            Resources.singleton().registerResource(module, resourcePath, resourceContent);
        }

        @Override
        public void ignoreResources(ConfigurationCondition condition, String pattern) {
            if (this.configurationTypeResolver.resolveConditionType(condition.getTypeName()) == null) {
                return;
            }
            this.registerConditionalConfiguration(condition, () -> {
                UserError.guarantee(!ResourcesFeature.this.sealed, "Resources ignored too late: %s", pattern);
                ResourcesFeature.this.excludedResourcePatterns.add(pattern);
            });
        }

        @Override
        public void addResourceBundles(ConfigurationCondition condition, String name) {
            if (this.configurationTypeResolver.resolveConditionType(condition.getTypeName()) == null) {
                return;
            }
            this.registerConditionalConfiguration(condition, () -> ((LocalizationFeature)ImageSingletons.lookup(LocalizationFeature.class)).prepareBundle(name));
        }

        @Override
        public void addClassBasedResourceBundle(ConfigurationCondition condition, String basename, String className) {
            if (this.configurationTypeResolver.resolveConditionType(condition.getTypeName()) == null) {
                return;
            }
            this.registerConditionalConfiguration(condition, () -> ((LocalizationFeature)ImageSingletons.lookup(LocalizationFeature.class)).prepareClassResourceBundle(basename, className));
        }

        @Override
        public void addResourceBundles(ConfigurationCondition condition, String basename, Collection<Locale> locales) {
            if (this.configurationTypeResolver.resolveConditionType(condition.getTypeName()) == null) {
                return;
            }
            this.registerConditionalConfiguration(condition, () -> ((LocalizationFeature)ImageSingletons.lookup(LocalizationFeature.class)).prepareBundle(basename, locales));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldRegisterResource(Module module, String resourceName) {
            if (module == null || !module.isNamed()) {
                if (this.alreadyAddedResources.contains(resourceName)) {
                    return false;
                }
                Set<String> set = this.alreadyAddedResources;
                synchronized (set) {
                    if (!this.alreadyAddedResources.contains(resourceName)) {
                        this.alreadyAddedResources.add(resourceName);
                        return true;
                    }
                    return false;
                }
            }
            return true;
        }

        private void processResourceFromModule(Module module, String resourcePath) {
            try {
                boolean isDirectory;
                String resourcePackage = jdk.internal.module.Resources.toPackageName(resourcePath);
                if (!resourcePackage.isEmpty() && module.getPackages().contains(resourcePackage)) {
                    ModuleSupport.accessModuleByClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, ResourcesFeature.class, (Module)module, (String)resourcePackage);
                }
                if (isDirectory = Files.isDirectory(Path.of(resourcePath, new String[0]), new LinkOption[0])) {
                    String content = this.getDirectoryContent(resourcePath, false);
                    Resources.singleton().registerDirectoryResource(module, resourcePath, content, false);
                } else {
                    InputStream is = module.getResourceAsStream(resourcePath);
                    this.registerResource(module, resourcePath, false, is);
                }
            }
            catch (IOException e) {
                Resources.singleton().registerIOException(module, resourcePath, e, LinkAtBuildTimeSupport.singleton().packageOrClassAtBuildTime(resourcePath));
            }
        }

        private void processResourceFromClasspath(String resourcePath) {
            Enumeration<URL> urls;
            try {
                urls = ResourcesFeature.this.imageClassLoader.getClassLoader().getResources(resourcePath);
            }
            catch (IOException e) {
                throw VMError.shouldNotReachHere("getResources for resourcePath " + resourcePath + " failed", e);
            }
            HashSet<String> alreadyProcessedResources = new HashSet<String>();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (alreadyProcessedResources.contains(url.toString())) continue;
                alreadyProcessedResources.add(url.toString());
                try {
                    boolean fromJar = url.getProtocol().equalsIgnoreCase("jar");
                    boolean isDirectory = this.resourceIsDirectory(url, fromJar, resourcePath);
                    if (isDirectory) {
                        String content = this.getDirectoryContent(fromJar ? url.toString() : Paths.get(url.toURI()).toString(), fromJar);
                        Resources.singleton().registerDirectoryResource(null, resourcePath, content, fromJar);
                        continue;
                    }
                    InputStream is = url.openStream();
                    this.registerResource(null, resourcePath, fromJar, is);
                }
                catch (IOException e) {
                    Resources.singleton().registerIOException(null, resourcePath, e, LinkAtBuildTimeSupport.singleton().packageOrClassAtBuildTime(resourcePath));
                    return;
                }
                catch (URISyntaxException e) {
                    throw VMError.shouldNotReachHere("resourceIsDirectory for resourcePath " + resourcePath + " failed", e);
                }
            }
        }

        private void registerResource(Module module, String resourcePath, boolean fromJar, InputStream is) {
            if (is == null) {
                return;
            }
            Resources.singleton().registerResource(module, resourcePath, is, fromJar);
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private String urlToJarPath(URL url) {
            try {
                return ((JarURLConnection)url.openConnection()).getJarFileURL().toURI().getPath();
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean resourceIsDirectory(URL url, boolean fromJar, String resourcePath) throws IOException, URISyntaxException {
            if (fromJar) {
                try (JarFile jf = new JarFile(this.urlToJarPath(url));){
                    boolean bl = jf.getEntry(resourcePath).isDirectory();
                    return bl;
                }
            }
            return Files.isDirectory(Path.of(url.toURI()), new LinkOption[0]);
        }

        private String getDirectoryContent(String path, boolean fromJar) throws IOException {
            TreeSet<Object> content = new TreeSet();
            if (fromJar) {
                try (JarFile jf = new JarFile(this.urlToJarPath(URI.create(path).toURL()));){
                    String pathSeparator = FileSystems.getDefault().getSeparator();
                    String directoryPath = path.split("!")[1];
                    if (directoryPath.startsWith(pathSeparator)) {
                        directoryPath = directoryPath.substring(1);
                    }
                    Enumeration<JarEntry> entries = jf.entries();
                    while (entries.hasMoreElements()) {
                        String entry = entries.nextElement().getName();
                        if (!entry.startsWith(directoryPath)) continue;
                        String contentEntry = entry.substring(directoryPath.length());
                        if (contentEntry.startsWith(pathSeparator)) {
                            contentEntry = contentEntry.substring(1);
                        }
                        if (contentEntry.isEmpty()) continue;
                        int firstSlash = contentEntry.indexOf(pathSeparator);
                        if (firstSlash != -1) {
                            content.add(contentEntry.substring(0, firstSlash));
                            continue;
                        }
                        content.add(contentEntry);
                    }
                }
            }
            try (Stream<Path> contentStream = Files.list(Path.of(path, new String[0]));){
                content = new TreeSet<String>(contentStream.map(Path::getFileName).map(Path::toString).toList());
            }
            return String.join((CharSequence)System.lineSeparator(), content);
        }
    }

    public static class Options {
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> IncludeResources = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ExcludeResources = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
    }

    private record ResourcePattern(String moduleName, Pattern pattern) {
        boolean moduleNameMatches(String resourceContainerModuleName) {
            if (this.moduleName == null) {
                return true;
            }
            if (this.moduleName.equals(ResourcesFeature.MODULE_NAME_ALL_UNNAMED)) {
                return resourceContainerModuleName == null;
            }
            return this.moduleName.equals(resourceContainerModuleName);
        }
    }

    private static final class ResourceCollectorImpl
    implements ClassLoaderSupport.ResourceCollector {
        private final Set<CompiledConditionalPattern> includePatterns;
        private final ResourcePattern[] excludePatterns;
        private static final int WATCHDOG_RESET_AFTER_EVERY_N_RESOURCES = 1000;
        private static final int WATCHDOG_INITIAL_WARNING_AFTER_N_SECONDS = 60;
        private static final int WATCHDOG_WARNING_AFTER_EVERY_N_SECONDS = 20;
        private final FeatureImpl.BeforeAnalysisAccessImpl access;
        private final LongAdder reachedResourceEntries;
        private boolean initialReport;
        private volatile String currentlyProcessedEntry;
        ScheduledExecutorService scheduledExecutor;

        private ResourceCollectorImpl(Set<CompiledConditionalPattern> includePatterns, ResourcePattern[] excludePatterns, FeatureImpl.BeforeAnalysisAccessImpl access) {
            this.includePatterns = includePatterns;
            this.excludePatterns = excludePatterns;
            this.access = access;
            this.reachedResourceEntries = new LongAdder();
            this.initialReport = true;
            this.currentlyProcessedEntry = null;
        }

        private void prepareProgressReporter() {
            this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            this.scheduledExecutor.scheduleAtFixedRate(() -> {
                if (this.initialReport) {
                    this.initialReport = false;
                    LogUtils.warning((String)"Resource scanning is taking a long time. This can be caused by class-path or module-path entries that point to large directory structures. Please make sure class-/module-path entries are easily accessible to native-image");
                }
                System.out.println("Total scanned entries: " + String.valueOf(this.reachedResourceEntries) + ", current entry: " + (this.currentlyProcessedEntry != null ? this.currentlyProcessedEntry : "Unknown resource"));
            }, 60L, 20L, TimeUnit.SECONDS);
        }

        private void shutDownProgressReporter() {
            if (!this.scheduledExecutor.isShutdown()) {
                this.scheduledExecutor.shutdown();
            }
        }

        @Override
        public List<ConfigurationCondition> isIncluded(Module module, String resourceName, URI resource) {
            this.currentlyProcessedEntry = resource.getScheme().equals("jrt") ? String.valueOf(resource) + "/" + resourceName : resource.toString();
            this.reachedResourceEntries.increment();
            if (this.reachedResourceEntries.longValue() % 1000L == 0L) {
                DeadlockWatchdog.singleton().recordActivity();
            }
            String relativePathWithTrailingSlash = resourceName + "/";
            String moduleName = module == null ? null : module.getName();
            for (ResourcePattern rp : this.excludePatterns) {
                if (!rp.moduleNameMatches(moduleName) || !rp.pattern.matcher(resourceName).matches() && !rp.pattern.matcher(relativePathWithTrailingSlash).matches()) continue;
                return List.of();
            }
            ArrayList<ConfigurationCondition> conditions = new ArrayList<ConfigurationCondition>();
            for (CompiledConditionalPattern rp : this.includePatterns) {
                if (!rp.compiledPattern().moduleNameMatches(moduleName) || !rp.compiledPattern().pattern.matcher(resourceName).matches() && !rp.compiledPattern().pattern.matcher(relativePathWithTrailingSlash).matches()) continue;
                conditions.add(rp.condition());
            }
            return conditions;
        }

        @Override
        public void addResource(Module module, String resourceName) {
            ((RuntimeResourceSupport)ImageSingletons.lookup(RuntimeResourceSupport.class)).addResource(module, resourceName);
        }

        @Override
        public void addResourceConditionally(Module module, String resourceName, ConfigurationCondition condition) {
            this.access.registerReachabilityHandler(e -> this.addResource(module, resourceName), this.access.findClassByName(condition.getTypeName()));
        }

        @Override
        public void registerIOException(Module module, String resourceName, IOException e, boolean linkAtBuildTime) {
            Resources.singleton().registerIOException(module, resourceName, e, linkAtBuildTime);
        }

        @Override
        public void registerNegativeQuery(Module module, String resourceName) {
            Resources.singleton().registerNegativeQuery(module, resourceName);
        }
    }

    private record CompiledConditionalPattern(ConfigurationCondition condition, ResourcePattern compiledPattern) {
    }

    private record ConditionalPattern(ConfigurationCondition condition, String pattern) {
    }
}

