/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.ameta;

import com.oracle.graal.pointsto.ConstantReflectionProviderExtension;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.heap.ImageHeapArray;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.value.ValueSupplier;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.graal.meta.SharedConstantReflectionProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.ObjectConstantEquality;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.AnalysisMethodHandleAccessProvider;
import com.oracle.svm.hosted.ameta.EmptyMemoryAccessProvider;
import com.oracle.svm.hosted.ameta.FieldValueInterceptionSupport;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerSupport;
import com.oracle.svm.hosted.meta.RelocatableConstant;
import java.util.Objects;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import jdk.graal.compiler.core.common.type.TypedConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.RelocatedPointer;
import org.graalvm.word.WordBase;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class AnalysisConstantReflectionProvider
extends SharedConstantReflectionProvider
implements ConstantReflectionProviderExtension<AnalysisField> {
    private final AnalysisUniverse universe;
    protected final UniverseMetaAccess metaAccess;
    private final ClassInitializationSupport classInitializationSupport;
    private final AnalysisMethodHandleAccessProvider methodHandleAccess;
    private SimulateClassInitializerSupport simulateClassInitializerSupport;
    private final FieldValueInterceptionSupport fieldValueInterceptionSupport = FieldValueInterceptionSupport.singleton();
    private static final Set<Class<?>> BOXING_CLASSES = Set.of(Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class);

    public AnalysisConstantReflectionProvider(AnalysisUniverse universe, UniverseMetaAccess metaAccess, ClassInitializationSupport classInitializationSupport) {
        this.universe = universe;
        this.metaAccess = metaAccess;
        this.classInitializationSupport = classInitializationSupport;
        this.methodHandleAccess = new AnalysisMethodHandleAccessProvider(universe);
    }

    @Override
    public Boolean constantEquals(Constant x, Constant y) {
        ImageHeapConstant cy;
        ImageHeapConstant cx;
        if (x == y) {
            return true;
        }
        if (x instanceof SubstrateObjectConstant && y instanceof SubstrateObjectConstant) {
            return ObjectConstantEquality.get().test((SubstrateObjectConstant)x, (SubstrateObjectConstant)y);
        }
        if (x instanceof ImageHeapConstant && (cx = (ImageHeapConstant)x).isBackedByHostedObject() && y instanceof SubstrateObjectConstant) {
            return ObjectConstantEquality.get().test((SubstrateObjectConstant)cx.getHostedObject(), (SubstrateObjectConstant)y);
        }
        if (y instanceof ImageHeapConstant && (cy = (ImageHeapConstant)y).isBackedByHostedObject() && x instanceof SubstrateObjectConstant) {
            return ObjectConstantEquality.get().test((SubstrateObjectConstant)cy.getHostedObject(), (SubstrateObjectConstant)x);
        }
        return x.equals((Object)y);
    }

    public MemoryAccessProvider getMemoryAccessProvider() {
        return EmptyMemoryAccessProvider.SINGLETON;
    }

    @Override
    public JavaConstant unboxPrimitive(JavaConstant source) {
        if (!source.getJavaKind().isObject()) {
            return null;
        }
        if (source instanceof ImageHeapConstant) {
            ImageHeapConstant imageHeapConstant = (ImageHeapConstant)source;
            AnalysisType type = imageHeapConstant.getType((MetaAccessProvider)this.metaAccess);
            if (BOXING_CLASSES.contains(type.getJavaClass())) {
                imageHeapConstant.ensureReaderInstalled();
                ResolvedJavaField[] fields = type.getInstanceFields(true);
                assert (fields.length == 1 && fields[0].getName().equals("value"));
                return ((ImageHeapInstance)imageHeapConstant).readFieldValue((AnalysisField)fields[0]);
            }
            return null;
        }
        return JavaConstant.forBoxedPrimitive((Object)SubstrateObjectConstant.asObject((Constant)source));
    }

    @Override
    public MethodHandleAccessProvider getMethodHandleAccess() {
        return this.methodHandleAccess;
    }

    @Override
    public Integer readArrayLength(JavaConstant array) {
        if (array.getJavaKind() != JavaKind.Object || array.isNull()) {
            return null;
        }
        if (array instanceof ImageHeapConstant) {
            if (array instanceof ImageHeapArray) {
                ImageHeapArray heapArray = (ImageHeapArray)array;
                return heapArray.getLength();
            }
            return null;
        }
        return super.readArrayLength(array);
    }

    @Override
    public JavaConstant readArrayElement(JavaConstant array, int index) {
        if (array.getJavaKind() != JavaKind.Object || array.isNull()) {
            return null;
        }
        if (array instanceof ImageHeapConstant) {
            if (array instanceof ImageHeapArray) {
                ImageHeapArray heapArray = (ImageHeapArray)array;
                if (index < 0 || index >= heapArray.getLength()) {
                    return null;
                }
                heapArray.ensureReaderInstalled();
                return this.replaceObject(heapArray.readElementValue(index));
            }
            return null;
        }
        JavaConstant element = super.readArrayElement(array, index);
        return element == null ? null : this.replaceObject(element);
    }

    @Override
    public void forEachArrayElement(JavaConstant array, ObjIntConsumer<JavaConstant> consumer) {
        if (array instanceof ImageHeapConstant) {
            if (array instanceof ImageHeapArray) {
                ImageHeapArray heapArray = (ImageHeapArray)array;
                heapArray.ensureReaderInstalled();
                for (int index2 = 0; index2 < heapArray.getLength(); ++index2) {
                    JavaConstant element2 = heapArray.readElementValue(index2);
                    consumer.accept(this.replaceObject(element2), index2);
                }
            }
            return;
        }
        super.forEachArrayElement(array, (element, index) -> consumer.accept(this.replaceObject((JavaConstant)element), index));
    }

    public JavaConstant readFieldValue(ResolvedJavaField field, JavaConstant receiver) {
        return this.readValue(this.metaAccess, (AnalysisField)field, receiver, false);
    }

    public JavaConstant readValue(UniverseMetaAccess suppliedMetaAccess, AnalysisField field, JavaConstant receiver, boolean returnSimulatedValues) {
        if (!(field.isStatic() || !receiver.isNull() && field.getDeclaringClass().isAssignableFrom(((TypedConstant)receiver).getType((MetaAccessProvider)this.metaAccess)))) {
            return null;
        }
        VMError.guarantee(receiver == null || receiver instanceof ImageHeapConstant, "Expected ImageHeapConstant, found: %s", receiver);
        JavaConstant value = null;
        if (returnSimulatedValues) {
            value = this.readSimulatedValue(field);
        }
        if (value == null && field.isStatic() && SimulateClassInitializerSupport.singleton().isEnabled()) {
            value = field.getDeclaringClass().getOrComputeData().readFieldValue(field);
        }
        if (value == null && receiver instanceof ImageHeapConstant) {
            ImageHeapConstant heapConstant = (ImageHeapConstant)receiver;
            heapConstant.ensureReaderInstalled();
            AnalysisError.guarantee((boolean)this.fieldValueInterceptionSupport.isValueAvailable(field), (String)"Value not yet available for %s", (Object[])new Object[]{field});
            ImageHeapInstance heapObject = (ImageHeapInstance)receiver;
            value = heapObject.readFieldValue(field);
        }
        if (value == null) {
            VMError.guarantee(!SimulateClassInitializerSupport.singleton().isEnabled());
            value = this.universe.getHeapScanner().createImageHeapConstant(this.readHostedFieldValue(suppliedMetaAccess, field, receiver), ObjectScanner.OtherReason.UNKNOWN);
        }
        return value;
    }

    public ValueSupplier<JavaConstant> readHostedFieldValue(AnalysisField field, JavaConstant receiver) {
        if (this.fieldValueInterceptionSupport.isValueAvailable(field)) {
            return ValueSupplier.eagerValue((Object)this.doReadValue(field, receiver));
        }
        return ValueSupplier.lazyValue(() -> this.doReadValue(field, receiver), () -> this.fieldValueInterceptionSupport.isValueAvailable(field));
    }

    public JavaConstant readHostedFieldValue(UniverseMetaAccess access, AnalysisField field, JavaConstant receiver) {
        return this.interceptValue(access, field, this.doReadValue(field, this.universe.toHosted(receiver)));
    }

    private JavaConstant doReadValue(AnalysisField field, JavaConstant receiver) {
        return this.universe.fromHosted(this.fieldValueInterceptionSupport.readFieldValue(this.classInitializationSupport, field, receiver));
    }

    private JavaConstant readSimulatedValue(AnalysisField field) {
        if (!field.isStatic() || field.getDeclaringClass().isInitialized()) {
            return null;
        }
        field.getDeclaringClass().getInitializeMetaDataTask().ensureDone();
        if (this.simulateClassInitializerSupport == null) {
            this.simulateClassInitializerSupport = SimulateClassInitializerSupport.singleton();
        }
        return this.simulateClassInitializerSupport.getSimulatedFieldValue(field);
    }

    public JavaConstant interceptValue(UniverseMetaAccess suppliedMetaAccess, AnalysisField field, JavaConstant value) {
        JavaConstant result = value;
        if (result != null) {
            result = AnalysisConstantReflectionProvider.filterInjectedAccessor(field, result);
            result = this.replaceObject(result);
            result = AnalysisConstantReflectionProvider.interceptAssertionStatus(field, result);
            result = this.interceptWordField(suppliedMetaAccess, field, result);
        }
        return result;
    }

    private static JavaConstant filterInjectedAccessor(AnalysisField field, JavaConstant value) {
        if (field.getAnnotation(InjectAccessors.class) != null) {
            assert (!field.isAccessed());
            return JavaConstant.defaultForKind((JavaKind)value.getJavaKind());
        }
        return value;
    }

    private JavaConstant replaceObject(JavaConstant value) {
        Object oldObject;
        Object newObject;
        if (value == JavaConstant.NULL_POINTER) {
            return JavaConstant.NULL_POINTER;
        }
        if (value instanceof ImageHeapConstant) {
            return value;
        }
        if (value.getJavaKind() == JavaKind.Object && (newObject = this.universe.replaceObject(oldObject = this.universe.getSnippetReflection().asObject(Object.class, value))) != oldObject) {
            return this.universe.getSnippetReflection().forObject(newObject);
        }
        return value;
    }

    private static JavaConstant interceptAssertionStatus(AnalysisField field, JavaConstant value) {
        if (field.isStatic() && field.isSynthetic() && field.getName().startsWith("$assertionsDisabled")) {
            Class clazz = field.getDeclaringClass().getJavaClass();
            boolean assertionsEnabled = RuntimeAssertionsSupport.singleton().desiredAssertionStatus(clazz);
            return JavaConstant.forBoolean((!assertionsEnabled ? 1 : 0) != 0);
        }
        return value;
    }

    private JavaConstant interceptWordField(UniverseMetaAccess suppliedMetaAccess, AnalysisField field, JavaConstant value) {
        if (value.getJavaKind() == JavaKind.Object) {
            VMError.guarantee(value instanceof RelocatableConstant || !suppliedMetaAccess.isInstanceOf(value, WordBase.class));
            if (value.isNull() && field.getType().isWordType()) {
                return JavaConstant.forIntegerKind((JavaKind)this.universe.getWordKind(), (long)0L);
            }
        }
        return value;
    }

    public AnalysisType asJavaType(Constant constant) {
        if (constant instanceof SubstrateObjectConstant) {
            SubstrateObjectConstant substrateConstant = (SubstrateObjectConstant)constant;
            Object obj = this.universe.getSnippetReflection().asObject(Object.class, (JavaConstant)substrateConstant);
            if (obj instanceof DynamicHub) {
                DynamicHub hub = (DynamicHub)obj;
                return this.getHostVM().lookupType(hub);
            }
            if (obj instanceof Class) {
                throw VMError.shouldNotReachHere("Must not have java.lang.Class object: " + String.valueOf(obj));
            }
        } else if (constant instanceof ImageHeapConstant) {
            ImageHeapConstant imageHeapConstant = (ImageHeapConstant)constant;
            if (this.metaAccess.isInstanceOf((JavaConstant)constant, Class.class)) {
                return this.asJavaType((Constant)Objects.requireNonNull(imageHeapConstant.getHostedObject()));
            }
        }
        return null;
    }

    public JavaConstant asJavaClass(ResolvedJavaType type) {
        return this.universe.getHeapScanner().createImageHeapConstant(super.forObject(this.getHostVM().dynamicHub(type)), ObjectScanner.OtherReason.UNKNOWN);
    }

    @Override
    public JavaConstant forString(String value) {
        if (value == null) {
            return JavaConstant.NULL_POINTER;
        }
        return this.universe.getHeapScanner().createImageHeapConstant(super.forString(value), ObjectScanner.OtherReason.UNKNOWN);
    }

    @Override
    public JavaConstant forObject(Object object) {
        AnalysisConstantReflectionProvider.validateRawObjectConstant(object);
        if (object instanceof RelocatedPointer) {
            RelocatedPointer pointer = (RelocatedPointer)object;
            return new RelocatableConstant(pointer);
        }
        if (object instanceof WordBase) {
            WordBase word = (WordBase)object;
            return JavaConstant.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)word.rawValue());
        }
        return this.universe.getHeapScanner().createImageHeapConstant(super.forObject(object), ObjectScanner.OtherReason.UNKNOWN);
    }

    public static void validateRawObjectConstant(Object object) {
        AnalysisError.guarantee((!(object instanceof ImageHeapConstant) ? 1 : 0) != 0, (String)"Unexpected ImageHeapConstant %s", (Object[])new Object[]{object});
    }

    private SVMHost getHostVM() {
        return (SVMHost)this.universe.hostVM();
    }
}

