/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.cenum;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.phases.CInterfaceEnumTool;
import com.oracle.svm.hosted.phases.CInterfaceInvocationPlugin;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.lang.reflect.AnnotatedElement;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.c.constant.CEnumLookup;
import org.graalvm.nativeimage.c.constant.CEnumValue;

public class CEnumCallWrapperMethod
extends CustomSubstitutionMethod {
    private final NativeLibraries nativeLibraries;

    CEnumCallWrapperMethod(NativeLibraries nativeLibraries, ResolvedJavaMethod method) {
        super(method);
        this.nativeLibraries = nativeLibraries;
    }

    @Override
    public int getModifiers() {
        return this.original.getModifiers() & 0xFFFFFEFF;
    }

    @Override
    public boolean isSynthetic() {
        return true;
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        ValueNode returnValue;
        HostedGraphKit kit = new HostedGraphKit(debug, providers, (ResolvedJavaMethod)method);
        AnalysisType returnType = (AnalysisType)method.getSignature().getReturnType();
        ValueNode arg = kit.getInitialArguments().get(0);
        CInterfaceEnumTool tool = new CInterfaceEnumTool(kit.getMetaAccess(), kit.getSnippetReflection());
        JavaKind pushKind = CInterfaceInvocationPlugin.pushKind(method);
        if (method.getAnnotation(CEnumLookup.class) != null) {
            EnumInfo enumInfo = (EnumInfo)this.nativeLibraries.findElementInfo((AnnotatedElement)returnType);
            JavaKind parameterKind = JavaKind.Int;
            returnValue = tool.createEnumLookupInvoke(kit, returnType, enumInfo, parameterKind, arg);
        } else if (method.getAnnotation(CEnumValue.class) != null) {
            AnalysisType declaringType = method.getDeclaringClass();
            EnumInfo enumInfo = (EnumInfo)this.nativeLibraries.findElementInfo((AnnotatedElement)declaringType);
            ValueNode invoke = tool.createEnumValueInvoke(kit, enumInfo, returnType.getJavaKind(), arg);
            ValueNode adapted = CInterfaceInvocationPlugin.adaptPrimitiveType(kit.getGraph(), invoke, invoke.stamp(NodeView.DEFAULT).getStackKind(), returnType.getJavaKind(), false);
            Stamp originalStamp = StampFactory.forKind((JavaKind)returnType.getJavaKind());
            returnValue = CInterfaceInvocationPlugin.adaptPrimitiveType(kit.getGraph(), adapted, returnType.getJavaKind(), originalStamp.getStackKind(), false);
        } else {
            throw VMError.shouldNotReachHereUnexpectedInput(method);
        }
        kit.getFrameState().push(pushKind, returnValue);
        kit.createReturn(returnValue, pushKind);
        return kit.finalizeGraph();
    }
}

