/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.hosted.FeatureImpl;
import java.io.File;
import java.io.FileDescriptor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeJNIAccess;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
@AutomaticallyRegisteredFeature
class JNIRegistrationJava
extends JNIRegistrationUtil
implements InternalFeature {
    private static final Consumer<Feature.DuringAnalysisAccess> CORESERVICES_LINKER = duringAnalysisAccess -> {
        FeatureImpl.DuringAnalysisAccessImpl accessImpl = (FeatureImpl.DuringAnalysisAccessImpl)duringAnalysisAccess;
        accessImpl.getNativeLibraries().addDynamicNonJniLibrary("-framework CoreServices");
    };

    JNIRegistrationJava() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        JNIRegistrationJava.registerForThrowNew((Feature.FeatureAccess)a, "java.lang.Exception", "java.lang.Error", "java.lang.OutOfMemoryError", "java.lang.RuntimeException", "java.lang.NullPointerException", "java.lang.ArrayIndexOutOfBoundsException", "java.lang.IllegalArgumentException", "java.lang.IllegalAccessException", "java.lang.IllegalAccessError", "java.lang.InternalError", "java.lang.NoSuchFieldException", "java.lang.NoSuchMethodException", "java.lang.ClassNotFoundException", "java.lang.NumberFormatException", "java.lang.NoSuchFieldError", "java.lang.NoSuchMethodError", "java.lang.UnsatisfiedLinkError", "java.lang.StringIndexOutOfBoundsException", "java.lang.InstantiationException", "java.lang.UnsupportedOperationException", "java.io.IOException", "java.io.FileNotFoundException", "java.io.SyncFailedException", "java.io.InterruptedIOException", "java.util.zip.DataFormatException", "java.lang.IndexOutOfBoundsException");
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJava.constructor((Feature.FeatureAccess)a, "java.io.FileNotFoundException", String.class, String.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJava.clazz((Feature.FeatureAccess)a, "java.lang.Integer")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJava.constructor((Feature.FeatureAccess)a, "java.lang.Integer", Integer.TYPE)});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.lang.Integer", "value"));
        RuntimeJNIAccess.register((Class[])new Class[]{JNIRegistrationJava.clazz((Feature.FeatureAccess)a, "java.lang.Boolean")});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJava.constructor((Feature.FeatureAccess)a, "java.lang.Boolean", Boolean.TYPE)});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.lang.Boolean", "value"));
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.lang.Boolean", "getBoolean", String.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{FileDescriptor.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.FileDescriptor", "fd"));
        if (JNIRegistrationJava.isWindows()) {
            RuntimeJNIAccess.register((Field[])JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.FileDescriptor", "handle"));
        }
        RuntimeJNIAccess.register((Field[])JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.FileDescriptor", "append"));
        RuntimeJNIAccess.register((Field[])JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.FileOutputStream", "fd"));
        RuntimeJNIAccess.register((Field[])JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.FileInputStream", "fd"));
        RuntimeJNIAccess.register((Class[])new Class[]{File.class});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.File", "path"));
        RuntimeJNIAccess.register((Class[])new Class[]{byte[].class});
        RuntimeJNIAccess.register((Class[])new Class[]{String.class});
        RuntimeJNIAccess.register((Class[])new Class[]{System.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.lang.System", "getProperty", String.class)});
        RuntimeJNIAccess.register((Class[])new Class[]{Charset.class});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJava.constructor((Feature.FeatureAccess)a, "java.lang.String", byte[].class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.lang.String", "getBytes", new Class[0])});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.nio.charset.Charset", "forName", String.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJava.constructor((Feature.FeatureAccess)a, "java.lang.String", byte[].class, Charset.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.lang.String", "getBytes", Charset.class)});
        RuntimeJNIAccess.register((Executable[])new Executable[]{JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.lang.String", "concat", String.class)});
        RuntimeJNIAccess.register((Field[])JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.lang.String", "coder", "value"));
        a.registerReachabilityHandler(JNIRegistrationJava::registerRandomAccessFileInitIDs, new Object[]{JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.io.RandomAccessFile", "initIDs", new Class[0])});
        if (JNIRegistrationJava.isWindows()) {
            PlatformNativeLibrarySupport.singleton().addBuiltinPkgNativePrefix("sun_security_provider_NativeSeedGenerator");
        }
        if (JNIRegistrationJava.isDarwin()) {
            List<Method> darwinMethods = Arrays.asList(JNIRegistrationJava.method((Feature.FeatureAccess)a, "apple.security.KeychainStore", "_scanKeychain", new Class[0]), JNIRegistrationJava.method((Feature.FeatureAccess)a, "apple.security.KeychainStore", "_releaseKeychainItemRef", Long.TYPE), JNIRegistrationJava.method((Feature.FeatureAccess)a, "apple.security.KeychainStore", "_addItemToKeychain", String.class, Boolean.TYPE, byte[].class, char[].class), JNIRegistrationJava.method((Feature.FeatureAccess)a, "apple.security.KeychainStore", "_removeItemFromKeychain", Long.TYPE), JNIRegistrationJava.method((Feature.FeatureAccess)a, "apple.security.KeychainStore", "_getEncodedKeyData", Long.TYPE, char[].class));
            ArrayList<Method> methods = new ArrayList<Method>(darwinMethods);
            methods.addAll(Arrays.asList(JNIRegistrationJava.method((Feature.FeatureAccess)a, "sun.nio.fs.MacOSXFileSystemProvider", "getFileTypeDetector", new Class[0]), JNIRegistrationJava.method((Feature.FeatureAccess)a, "sun.net.spi.DefaultProxySelector", "getSystemProxies", String.class, String.class), JNIRegistrationJava.method((Feature.FeatureAccess)a, "sun.net.spi.DefaultProxySelector", "init", new Class[0])));
            a.registerReachabilityHandler(CORESERVICES_LINKER, methods.toArray(new Object[0]));
        }
        a.registerReachabilityHandler(JNIRegistrationJava::registerProcessHandleImplInfoInitIDs, new Object[]{JNIRegistrationJava.method((Feature.FeatureAccess)a, "java.lang.ProcessHandleImpl$Info", "initIDs", new Class[0])});
    }

    private static void registerProcessHandleImplInfoInitIDs(Feature.DuringAnalysisAccess a) {
        RuntimeJNIAccess.register((Field[])JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.lang.ProcessHandleImpl$Info", "command", "commandLine", "arguments", "startTime", "totalTime", "user"));
    }

    private static void registerRandomAccessFileInitIDs(Feature.DuringAnalysisAccess a) {
        RuntimeJNIAccess.register((Field[])JNIRegistrationJava.fields((Feature.FeatureAccess)a, "java.io.RandomAccessFile", "fd"));
    }
}

