/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jni;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.graal.nodes.CEntryPointEnterNode;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.jni.headers.JNIEnvironment;
import com.oracle.svm.core.jni.headers.JNIObjectHandle;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.code.EntryPointCallStubMethod;
import com.oracle.svm.hosted.jni.JNIGraphKit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;

public final class JNIPrimitiveArrayOperationMethod
extends EntryPointCallStubMethod {
    private final JavaKind elementKind;
    private final Operation operation;

    public JNIPrimitiveArrayOperationMethod(JavaKind elementKind, Operation operation, ResolvedJavaType declaringClass, ConstantPool constantPool, MetaAccessProvider metaAccess) {
        super(JNIPrimitiveArrayOperationMethod.createName(elementKind, operation), declaringClass, (Signature)JNIPrimitiveArrayOperationMethod.createSignature(operation, metaAccess), constantPool);
        if (!EnumSet.of(JavaKind.Boolean, new JavaKind[]{JavaKind.Byte, JavaKind.Char, JavaKind.Short, JavaKind.Int, JavaKind.Long, JavaKind.Float, JavaKind.Double}).contains(elementKind)) {
            throw VMError.shouldNotReachHereUnexpectedInput(elementKind);
        }
        this.elementKind = elementKind;
        this.operation = operation;
    }

    private static String createName(JavaKind elementKind, Operation operation) {
        StringBuilder sb = new StringBuilder(32);
        String kindName = elementKind.name();
        switch (operation.ordinal()) {
            case 0: {
                sb.append("Get").append(kindName).append("ArrayElements");
                break;
            }
            case 1: {
                sb.append("Release").append(kindName).append("ArrayElements");
                break;
            }
            case 2: {
                sb.append("Get").append(kindName).append("ArrayRegion");
                break;
            }
            case 3: {
                sb.append("Set").append(kindName).append("ArrayRegion");
            }
        }
        return sb.toString();
    }

    private static ResolvedSignature<ResolvedJavaType> createSignature(Operation operation, MetaAccessProvider metaAccess) {
        ResolvedJavaType returnType;
        ResolvedJavaType objectHandleType = metaAccess.lookupJavaType(JNIObjectHandle.class);
        ResolvedJavaType intType = metaAccess.lookupJavaType(Integer.TYPE);
        ArrayList<ResolvedJavaType> args = new ArrayList<ResolvedJavaType>();
        args.add(metaAccess.lookupJavaType(JNIEnvironment.class));
        args.add(objectHandleType);
        if (operation == Operation.GET_ELEMENTS) {
            args.add(metaAccess.lookupJavaType(CCharPointer.class));
            returnType = metaAccess.lookupJavaType(WordPointer.class);
        } else if (operation == Operation.RELEASE_ELEMENTS) {
            args.add(metaAccess.lookupJavaType(WordPointer.class));
            args.add(intType);
            returnType = metaAccess.lookupJavaType(Void.TYPE);
        } else if (operation == Operation.GET_REGION || operation == Operation.SET_REGION) {
            args.add(intType);
            args.add(intType);
            args.add(metaAccess.lookupJavaType(WordPointer.class));
            returnType = metaAccess.lookupJavaType(Void.TYPE);
        } else {
            throw VMError.shouldNotReachHereUnexpectedInput((Object)operation);
        }
        return ResolvedSignature.fromList(args, (ResolvedJavaType)returnType);
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        JNIGraphKit kit = new JNIGraphKit(debug, providers, (ResolvedJavaMethod)method);
        List<ValueNode> arguments = kit.getInitialArguments();
        ValueNode vmThread = arguments.get(0);
        kit.append((Node)CEntryPointEnterNode.enter(vmThread));
        InvokeWithExceptionNode result = null;
        switch (this.operation.ordinal()) {
            case 0: {
                ValueNode arrayHandle = arguments.get(1);
                InvokeWithExceptionNode array = kit.unboxHandle(arrayHandle);
                ValueNode isCopy = arguments.get(2);
                result = kit.createArrayViewAndGetAddress((ValueNode)array, isCopy);
                break;
            }
            case 1: {
                ValueNode address = arguments.get(2);
                ValueNode mode = arguments.get(3);
                kit.destroyNewestArrayViewByAddress(address, mode);
                break;
            }
            case 2: 
            case 3: {
                ValueNode arrayHandle = arguments.get(1);
                InvokeWithExceptionNode array = kit.unboxHandle(arrayHandle);
                ValueNode start = arguments.get(2);
                ValueNode count = arguments.get(3);
                ValueNode buffer = arguments.get(4);
                FixedWithNextNode fwn = this.operation == Operation.GET_REGION ? kit.getPrimitiveArrayRegionRetainException(this.elementKind, (ValueNode)array, start, count, buffer) : kit.setPrimitiveArrayRegionRetainException(this.elementKind, (ValueNode)array, start, count, buffer);
                if (!(fwn instanceof MergeNode)) break;
                MergeNode merge = (MergeNode)fwn;
                ((MergeNode)fwn).setStateAfter(kit.getFrameState().create(kit.bci(), (StateSplit)merge));
                break;
            }
            default: {
                throw VMError.shouldNotReachHereUnexpectedInput((Object)this.operation);
            }
        }
        kit.appendStateSplitProxy();
        CEntryPointLeaveNode leave = new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.Leave);
        kit.append((Node)leave);
        kit.createReturn((ValueNode)result, result != null ? result.getStackKind() : JavaKind.Void);
        return kit.finalizeGraph();
    }

    public CEntryPointData createEntryPointData() {
        return CEntryPointData.create(this, "", CEntryPointData.DEFAULT_NAME_TRANSFORMATION, "", CEntryPointOptions.NoPrologue.class, CEntryPointOptions.AutomaticPrologueBailout.class, CEntryPointOptions.NoEpilogue.class, CEntryPoint.FatalExceptionHandler.class, CEntryPoint.Publish.NotPublished);
    }

    public static enum Operation {
        GET_ELEMENTS,
        RELEASE_ELEMENTS,
        GET_REGION,
        SET_REGION;

    }
}

