/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.graal.meta.SubstrateSnippetReflectionProvider;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.meta.RelocatableConstant;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.c.function.RelocatedPointer;
import org.graalvm.word.WordBase;

public class HostedLookupSnippetReflectionProvider
extends SubstrateSnippetReflectionProvider {
    public HostedLookupSnippetReflectionProvider(WordTypes wordTypes) {
        super(wordTypes);
    }

    @Override
    public JavaConstant forObject(Object object) {
        if (object instanceof RelocatedPointer) {
            RelocatedPointer pointer = (RelocatedPointer)object;
            return new RelocatableConstant(pointer);
        }
        if (object instanceof WordBase) {
            WordBase word = (WordBase)object;
            return JavaConstant.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)word.rawValue());
        }
        AnalysisConstantReflectionProvider.validateRawObjectConstant(object);
        return super.forObject(object);
    }

    @Override
    public <T> T asObject(Class<T> type, JavaConstant constant) {
        if (constant instanceof RelocatableConstant) {
            RelocatableConstant relocatable = (RelocatableConstant)constant;
            return type.cast(relocatable.getPointer());
        }
        return super.asObject(type, constant);
    }
}

