/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.c.enums.EnumRuntimeData;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.phases.CInterfaceInvocationPlugin;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.java.BytecodeParser;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class CInterfaceEnumTool {
    private final SnippetReflectionProvider snippetReflection;
    private final AnalysisMethod convertJavaToCLongMethod;
    private final AnalysisMethod convertJavaToCIntMethod;
    private final AnalysisMethod convertCToJavaMethod;

    public CInterfaceEnumTool(AnalysisMetaAccess metaAccess, SnippetReflectionProvider snippetReflection) {
        this.snippetReflection = snippetReflection;
        try {
            this.convertJavaToCLongMethod = metaAccess.lookupJavaMethod((Executable)EnumRuntimeData.class.getDeclaredMethod("convertJavaToCLong", Enum.class));
            this.convertJavaToCIntMethod = metaAccess.lookupJavaMethod((Executable)EnumRuntimeData.class.getDeclaredMethod("convertJavaToCInt", Enum.class));
            this.convertCToJavaMethod = metaAccess.lookupJavaMethod((Executable)EnumRuntimeData.class.getDeclaredMethod("convertCToJava", Long.TYPE));
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private AnalysisMethod getValueMethodForKind(JavaKind kind) {
        return kind == JavaKind.Long ? this.convertJavaToCLongMethod : this.convertJavaToCIntMethod;
    }

    public ValueNode createEnumValueInvoke(HostedGraphKit kit, EnumInfo enumInfo, JavaKind resultKind, ValueNode arg) {
        int invokeBci = kit.bci();
        MethodCallTargetNode callTarget = this.invokeEnumValue((GraphBuilderTool)kit, CallTargetFactory.from(kit), invokeBci, enumInfo, resultKind, arg);
        return kit.createInvokeWithExceptionAndUnwind(callTarget, kit.getFrameState(), invokeBci);
    }

    public ValueNode startEnumValueInvokeWithException(HostedGraphKit kit, EnumInfo enumInfo, JavaKind resultKind, ValueNode arg) {
        int invokeBci = kit.bci();
        MethodCallTargetNode callTarget = this.invokeEnumValue((GraphBuilderTool)kit, CallTargetFactory.from(kit), invokeBci, enumInfo, resultKind, arg);
        return kit.startInvokeWithException((CallTargetNode)callTarget, kit.getFrameState(), invokeBci);
    }

    private MethodCallTargetNode invokeEnumValue(GraphBuilderTool b, CallTargetFactory callTargetFactory, int bci, EnumInfo enumInfo, JavaKind resultKind, ValueNode arg) {
        AnalysisMethod valueMethod = this.getValueMethodForKind(resultKind);
        AnalysisType returnType = (AnalysisType)valueMethod.getSignature().getReturnType();
        ValueNode[] args = new ValueNode[]{ConstantNode.forConstant((JavaConstant)this.snippetReflection.forObject((Object)enumInfo.getRuntimeData()), (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph()), arg};
        StampPair returnStamp = StampFactory.forDeclaredType(null, (JavaType)returnType, (boolean)false);
        return (MethodCallTargetNode)b.append((Node)callTargetFactory.createMethodCallTarget(CallTargetNode.InvokeKind.Virtual, valueMethod, args, returnStamp, bci));
    }

    public ValueNode createEnumLookupInvoke(HostedGraphKit kit, AnalysisType enumType, EnumInfo enumInfo, JavaKind parameterKind, ValueNode arg) {
        int invokeBci = kit.bci();
        MethodCallTargetNode callTarget = this.invokeEnumLookup((GraphBuilderTool)kit, CallTargetFactory.from(kit), invokeBci, enumInfo, parameterKind, arg);
        InvokeWithExceptionNode invoke = kit.createInvokeWithExceptionAndUnwind(callTarget, kit.getFrameState(), invokeBci);
        LogicNode instanceOfNode = (LogicNode)kit.append((Node)InstanceOfNode.createAllowNull((TypeReference)TypeReference.createExactTrusted((ResolvedJavaType)enumType), (ValueNode)invoke, null, null));
        ConstantNode enumClass = kit.createConstant((Constant)kit.getConstantReflection().asJavaClass((ResolvedJavaType)enumType), JavaKind.Object);
        GuardingNode guard = kit.createCheckThrowingBytecodeException(instanceOfNode, false, BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, new ValueNode[]{invoke, enumClass});
        ObjectStamp resultStamp = StampFactory.object((TypeReference)TypeReference.create(null, (ResolvedJavaType)enumType), (boolean)false);
        return kit.unique((FloatingNode)new PiNode((ValueNode)invoke, (Stamp)resultStamp, guard.asNode()));
    }

    private MethodCallTargetNode invokeEnumLookup(GraphBuilderTool b, CallTargetFactory callTargetFactory, int bci, EnumInfo enumInfo, JavaKind parameterKind, ValueNode arg) {
        ValueNode[] args = new ValueNode[2];
        args[0] = ConstantNode.forConstant((JavaConstant)this.snippetReflection.forObject((Object)enumInfo.getRuntimeData()), (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph());
        assert (!Modifier.isStatic(this.convertCToJavaMethod.getModifiers()) && this.convertCToJavaMethod.getSignature().getParameterCount(false) == 1);
        JavaKind expectedKind = ((AnalysisType)this.convertCToJavaMethod.getSignature().getParameterType(0)).getJavaKind();
        args[1] = CInterfaceInvocationPlugin.adaptPrimitiveType(b.getGraph(), arg, parameterKind, expectedKind, false);
        AnalysisType convertReturnType = (AnalysisType)this.convertCToJavaMethod.getSignature().getReturnType();
        StampPair returnStamp = StampFactory.forDeclaredType(null, (JavaType)convertReturnType, (boolean)false);
        return (MethodCallTargetNode)b.append((Node)callTargetFactory.createMethodCallTarget(CallTargetNode.InvokeKind.Virtual, this.convertCToJavaMethod, args, returnStamp, bci));
    }

    static interface CallTargetFactory {
        public MethodCallTargetNode createMethodCallTarget(CallTargetNode.InvokeKind var1, AnalysisMethod var2, ValueNode[] var3, StampPair var4, int var5);

        public static CallTargetFactory from(BytecodeParser p) {
            return (invokeKind, targetMethod, args, returnStamp, bci) -> p.createMethodCallTarget(invokeKind, (ResolvedJavaMethod)targetMethod, args, returnStamp, null);
        }

        public static CallTargetFactory from(HostedGraphKit kit) {
            return kit::createMethodCallTarget;
        }
    }
}

