/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.snippets;

import com.oracle.graal.pointsto.AbstractAnalysisEngine;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.nodes.UnsafePartitionLoadNode;
import com.oracle.graal.pointsto.nodes.UnsafePartitionStoreNode;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.MissingRegistrationSupport;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.GraalEdgeUnsafePartition;
import com.oracle.svm.core.graal.jdk.SubstrateObjectCloneWithExceptionNode;
import com.oracle.svm.core.graal.nodes.DeoptEntryNode;
import com.oracle.svm.core.graal.nodes.FarReturnNode;
import com.oracle.svm.core.graal.nodes.LazyConstantNode;
import com.oracle.svm.core.graal.nodes.ReadCallerStackPointerNode;
import com.oracle.svm.core.graal.nodes.ReadReservedRegister;
import com.oracle.svm.core.graal.nodes.ReadReturnAddressNode;
import com.oracle.svm.core.graal.nodes.SubstrateCompressionNode;
import com.oracle.svm.core.graal.nodes.SubstrateNarrowOopStamp;
import com.oracle.svm.core.graal.nodes.SubstrateReflectionGetCallerClassNode;
import com.oracle.svm.core.graal.nodes.TestDeoptimizeNode;
import com.oracle.svm.core.graal.stackvalue.LateStackValueNode;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.graal.stackvalue.UnsafeLateStackValue;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.ReferenceAccessImpl;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.identityhashcode.SubstrateIdentityHashCodeNode;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ReachabilityRegistrationNode;
import com.oracle.svm.hosted.nodes.DeoptProxyNode;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.util.ClassUtil;
import java.io.ObjectInputFilter;
import java.lang.ref.Reference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.stream.Stream;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Edges;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeList;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.java.BytecodeParser;
import jdk.graal.compiler.java.LambdaUtils;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ComputeObjectAddressNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.DynamicPiNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FullInfopointNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.extended.LoadHubNode;
import jdk.graal.compiler.nodes.extended.StateSplitProxyNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.java.DynamicNewInstanceNode;
import jdk.graal.compiler.nodes.java.InstanceOfDynamicNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.nodes.spi.ArrayLengthProvider;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.Replacements;
import jdk.graal.compiler.nodes.type.NarrowOopStamp;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.nodes.virtual.AllocatedObjectNode;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.nodes.virtual.VirtualArrayNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.replacements.StandardGraphBuilderPlugins;
import jdk.graal.compiler.replacements.nodes.AESNode;
import jdk.graal.compiler.replacements.nodes.CipherBlockChainingAESNode;
import jdk.graal.compiler.replacements.nodes.CounterModeAESNode;
import jdk.graal.compiler.replacements.nodes.MacroNode;
import jdk.graal.compiler.replacements.nodes.VectorizedHashCodeNode;
import jdk.graal.compiler.replacements.nodes.VectorizedMismatchNode;
import jdk.graal.compiler.word.WordCastNode;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.hosted.RuntimeProxyCreation;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.hosted.RuntimeSerialization;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class SubstrateGraphBuilderPlugins {
    public static void registerInvocationPlugins(AnnotationSubstitutionProcessor annotationSubstitutions, ImageClassLoader loader, SnippetReflectionProvider snippetReflection, InvocationPlugins plugins, Replacements replacements, ParsingReason parsingReason, Architecture architecture, boolean supportsStubBasedPlugins) {
        SubstrateGraphBuilderPlugins.registerSystemPlugins(snippetReflection, plugins);
        SubstrateGraphBuilderPlugins.registerReflectionPlugins(plugins, replacements);
        SubstrateGraphBuilderPlugins.registerImageInfoPlugins(plugins);
        SubstrateGraphBuilderPlugins.registerProxyPlugins(snippetReflection, annotationSubstitutions, plugins, parsingReason);
        SubstrateGraphBuilderPlugins.registerSerializationPlugins(loader, snippetReflection, plugins, parsingReason);
        SubstrateGraphBuilderPlugins.registerAtomicUpdaterPlugins(snippetReflection, plugins);
        SubstrateGraphBuilderPlugins.registerObjectPlugins(plugins);
        SubstrateGraphBuilderPlugins.registerUnsafePlugins(plugins, snippetReflection, parsingReason);
        SubstrateGraphBuilderPlugins.registerKnownIntrinsicsPlugins(plugins);
        SubstrateGraphBuilderPlugins.registerStackValuePlugins(snippetReflection, plugins);
        SubstrateGraphBuilderPlugins.registerArrayPlugins(plugins, snippetReflection, parsingReason);
        SubstrateGraphBuilderPlugins.registerClassPlugins(plugins, snippetReflection);
        SubstrateGraphBuilderPlugins.registerEdgesPlugins(plugins);
        SubstrateGraphBuilderPlugins.registerVMConfigurationPlugins(snippetReflection, plugins);
        SubstrateGraphBuilderPlugins.registerPlatformPlugins(snippetReflection, plugins);
        SubstrateGraphBuilderPlugins.registerSizeOfPlugins(snippetReflection, plugins);
        SubstrateGraphBuilderPlugins.registerReferencePlugins(plugins, parsingReason);
        SubstrateGraphBuilderPlugins.registerReferenceAccessPlugins(plugins);
        if (supportsStubBasedPlugins) {
            SubstrateGraphBuilderPlugins.registerAESPlugins(plugins, replacements, architecture);
            SubstrateGraphBuilderPlugins.registerArraysSupportPlugins(plugins, replacements, architecture);
        }
    }

    private static void registerSerializationPlugins(ImageClassLoader loader, final SnippetReflectionProvider snippetReflection, InvocationPlugins plugins, final ParsingReason reason) {
        if (reason.duringAnalysis() && reason != ParsingReason.JITCompilation) {
            InvocationPlugins.Registration serializationFilter = new InvocationPlugins.Registration(plugins, ObjectInputFilter.Config.class);
            serializationFilter.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("createFilter", new Type[]{String.class}){

                public boolean isDecorator() {
                    return true;
                }

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode patternNode) {
                    if (SubstrateGraphBuilderPlugins.nonNullJavaConstants(patternNode)) {
                        String pattern = (String)snippetReflection.asObject(String.class, patternNode.asJavaConstant());
                        b.add((Node)ReachabilityRegistrationNode.create(() -> SubstrateGraphBuilderPlugins.parsePatternAndRegister(pattern), reason));
                        return true;
                    }
                    return false;
                }
            });
            if (ModuleLayer.boot().findModule("jdk.unsupported").isPresent()) {
                InvocationPlugins.Registration customConstructor = new InvocationPlugins.Registration(plugins, loader.findClassOrFail("sun.reflect.ReflectionFactory"));
                customConstructor.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("newConstructorForSerialization", new Type[]{InvocationPlugin.Receiver.class, Class.class}){

                    public boolean isDecorator() {
                        return true;
                    }

                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode clazz) {
                        if (SubstrateGraphBuilderPlugins.nonNullJavaConstants(receiver.get(), clazz)) {
                            b.add((Node)ReachabilityRegistrationNode.create(() -> RuntimeSerialization.register((Class[])new Class[]{(Class)snippetReflection.asObject(Class.class, clazz.asJavaConstant())}), reason));
                            return true;
                        }
                        return false;
                    }
                });
                customConstructor.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("newConstructorForSerialization", new Type[]{InvocationPlugin.Receiver.class, Class.class, Constructor.class}){

                    public boolean isDecorator() {
                        return true;
                    }

                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode clazz, ValueNode constructor) {
                        if (SubstrateGraphBuilderPlugins.nonNullJavaConstants(receiver.get(), clazz, constructor)) {
                            Class constructorDeclaringClass = ((Constructor)snippetReflection.asObject(Constructor.class, constructor.asJavaConstant())).getDeclaringClass();
                            b.add((Node)ReachabilityRegistrationNode.create(() -> RuntimeSerialization.registerWithTargetConstructorClass((Class)((Class)snippetReflection.asObject(Class.class, clazz.asJavaConstant())), (Class)constructorDeclaringClass), reason));
                            return true;
                        }
                        return false;
                    }
                });
            }
        }
    }

    private static boolean nonNullJavaConstants(ValueNode ... valueNodes) {
        for (ValueNode valueNode : valueNodes) {
            if (valueNode.isJavaConstant() && !valueNode.isNullConstant()) continue;
            return false;
        }
        return true;
    }

    private static boolean isLimitPattern(String pattern) {
        int eqNdx = pattern.indexOf(61);
        return eqNdx >= 0;
    }

    private static void parsePatternAndRegister(String pattern) {
        String[] patterns;
        for (String p : patterns = pattern.split(";")) {
            boolean negate;
            int poffset;
            int slash;
            int nameLen = p.length();
            if (nameLen == 0 || SubstrateGraphBuilderPlugins.isLimitPattern(p) || (slash = p.indexOf(47, poffset = (negate = p.charAt(0) == '!') ? 1 : 0)) == poffset) continue;
            int n = poffset = slash >= 0 ? slash + 1 : poffset;
            if (p.endsWith("*")) {
                if (p.endsWith(".*") || p.endsWith(".**")) continue;
                String className = p.substring(poffset, nameLen - 1);
                if (negate || !className.endsWith("$$Lambda")) continue;
                try {
                    String lambdaHolderName = LambdaUtils.capturingClass((String)className);
                    RuntimeSerialization.registerLambdaCapturingClass(Class.forName(lambdaHolderName, false, Thread.currentThread().getContextClassLoader()));
                }
                catch (ClassNotFoundException classNotFoundException) {}
                continue;
            }
            Object name = p.substring(poffset);
            if (((String)name).isEmpty()) {
                return;
            }
            if (negate) continue;
            try {
                if (((String)name).startsWith("[") && ((String)name).contains("[L") && !((String)name).endsWith(";")) {
                    name = (String)name + ";";
                }
                RuntimeSerialization.register((Class[])new Class[]{Class.forName((String)name, false, Thread.currentThread().getContextClassLoader())});
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private static void registerSystemPlugins(final SnippetReflectionProvider snippetReflection, InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, System.class);
        if (SubstrateOptions.FoldSecurityManagerGetter.getValue().booleanValue()) {
            r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("getSecurityManager", new Type[0]){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)snippetReflection.forObject(null), (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph()));
                    return true;
                }
            });
        }
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("identityHashCode", new Type[]{Object.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.addPush(JavaKind.Int, SubstrateIdentityHashCodeNode.create(object, b.bci()));
                return true;
            }
        });
    }

    private static void registerReflectionPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.reflect.Reflection", replacements);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("getCallerClass", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, (ValueNode)new SubstrateReflectionGetCallerClassNode(MacroNode.MacroParams.of((GraphBuilderContext)b, (ResolvedJavaMethod)targetMethod, (ValueNode[])new ValueNode[0])));
                return true;
            }
        });
    }

    private static void registerImageInfoPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration proxyRegistration = new InvocationPlugins.Registration(plugins, ImageInfo.class);
        proxyRegistration.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("inImageCode", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.push(JavaKind.Boolean, (ValueNode)ConstantNode.forConstant((JavaConstant)JavaConstant.TRUE, (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph()));
                return true;
            }
        });
        proxyRegistration.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("inImageBuildtimeCode", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.push(JavaKind.Boolean, (ValueNode)ConstantNode.forConstant((JavaConstant)JavaConstant.FALSE, (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph()));
                return true;
            }
        });
        proxyRegistration.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("inImageRuntimeCode", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.push(JavaKind.Boolean, (ValueNode)ConstantNode.forConstant((JavaConstant)JavaConstant.TRUE, (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph()));
                return true;
            }
        });
    }

    private static void registerProxyPlugins(SnippetReflectionProvider snippetReflection, AnnotationSubstitutionProcessor annotationSubstitutions, InvocationPlugins plugins, ParsingReason reason) {
        InvocationPlugins.Registration proxyRegistration = new InvocationPlugins.Registration(plugins, Proxy.class);
        SubstrateGraphBuilderPlugins.registerProxyPlugin(proxyRegistration, snippetReflection, annotationSubstitutions, reason, "getProxyClass", ClassLoader.class, Class[].class);
        SubstrateGraphBuilderPlugins.registerProxyPlugin(proxyRegistration, snippetReflection, annotationSubstitutions, reason, "newProxyInstance", ClassLoader.class, Class[].class, InvocationHandler.class);
    }

    private static void registerProxyPlugin(InvocationPlugins.Registration proxyRegistration, final SnippetReflectionProvider snippetReflection, final AnnotationSubstitutionProcessor annotationSubstitutions, final ParsingReason reason, String name, Class<?> ... parameterTypes) {
        proxyRegistration.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(name, parameterTypes){

            public boolean isDecorator() {
                return true;
            }

            public boolean defaultHandler(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode ... args) {
                Runnable proxyRegistrationRunnable = SubstrateGraphBuilderPlugins.interceptProxyInterfaces(b, targetMethod, snippetReflection, annotationSubstitutions, args[1]);
                if (proxyRegistrationRunnable != null) {
                    Class callerClass = OriginalClassProvider.getJavaClass((JavaType)b.getMethod().getDeclaringClass());
                    boolean callerInScope = MissingRegistrationSupport.singleton().reportMissingRegistrationErrors(callerClass.getModule().getName(), callerClass.getPackageName(), callerClass.getName());
                    if (callerInScope && reason.duringAnalysis() && reason != ParsingReason.JITCompilation) {
                        b.add((Node)ReachabilityRegistrationNode.create(proxyRegistrationRunnable, reason));
                        return true;
                    }
                    proxyRegistrationRunnable.run();
                    return false;
                }
                return false;
            }
        });
    }

    private static Runnable interceptProxyInterfaces(GraphBuilderContext b, ResolvedJavaMethod targetMethod, SnippetReflectionProvider snippetReflection, AnnotationSubstitutionProcessor annotationSubstitutions, ValueNode interfacesNode) {
        Class[] interfaces = SubstrateGraphBuilderPlugins.extractClassArray(b, snippetReflection, annotationSubstitutions, interfacesNode);
        if (interfaces != null) {
            ResolvedJavaMethod caller = b.getGraph().method();
            ResolvedJavaMethod method = b.getMethod();
            int bci = b.bci();
            return () -> {
                RuntimeProxyCreation.register((Class[])interfaces);
                if (ImageSingletons.contains(FallbackFeature.class)) {
                    ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).addAutoProxyInvoke(method, bci);
                }
                if (Options.DynamicProxyTracing.getValue().booleanValue()) {
                    System.out.println("Successfully determined constant value for interfaces argument of call to " + targetMethod.format("%H.%n(%p)") + " reached from " + caller.format("%H.%n(%p)") + ". Registered proxy class for " + Arrays.toString(interfaces) + ".");
                }
            };
        }
        if (Options.DynamicProxyTracing.getValue().booleanValue() && !b.parsingIntrinsic()) {
            System.out.println("Could not determine constant value for interfaces argument of call to " + targetMethod.format("%H.%n(%p)") + " reached from " + b.getGraph().method().format("%H.%n(%p)") + ".");
        }
        return null;
    }

    static Class<?>[] extractClassArray(GraphBuilderContext b, SnippetReflectionProvider snippetReflection, AnnotationSubstitutionProcessor annotationSubstitutions, ValueNode arrayNode) {
        Class<?>[] classes = SubstrateGraphBuilderPlugins.extractClassArray(b, annotationSubstitutions, snippetReflection, arrayNode, false);
        return classes == null ? null : (Stream.of(classes).allMatch(Objects::nonNull) ? classes : null);
    }

    static Class<?>[] extractClassArray(GraphBuilderContext b, AnnotationSubstitutionProcessor annotationSubstitutions, SnippetReflectionProvider snippetReflection, ValueNode arrayNode, boolean exact) {
        ValueNode originalArrayNode = SubstrateGraphBuilderPlugins.getDeoptProxyOriginalValue(arrayNode);
        if (originalArrayNode.isJavaConstant() && !exact) {
            return (Class[])snippetReflection.asObject(Class[].class, originalArrayNode.asJavaConstant());
        }
        if (originalArrayNode instanceof AllocatedObjectNode && StampTool.isAlwaysArray((ValueNode)originalArrayNode)) {
            AllocatedObjectNode allocatedObjectNode = (AllocatedObjectNode)originalArrayNode;
            if (!allocatedObjectNode.getVirtualObject().type().equals((Object)b.getMetaAccess().lookupJavaType(Class[].class))) {
                return null;
            }
            CommitAllocationNode commitAllocationNode = allocatedObjectNode.getCommit();
            if (SubstrateGraphBuilderPlugins.skipNonInterferingNodes(commitAllocationNode.next()) != null) {
                return null;
            }
            int objectStartIndex = 0;
            for (VirtualObjectNode virtualObject : commitAllocationNode.getVirtualObjects()) {
                if (virtualObject == allocatedObjectNode.getVirtualObject()) {
                    assert (virtualObject instanceof VirtualArrayNode) : virtualObject;
                    Class[] result = new Class[virtualObject.entryCount()];
                    for (int i = 0; i < result.length; ++i) {
                        JavaConstant valueConstant = ((ValueNode)commitAllocationNode.getValues().get(objectStartIndex + i)).asJavaConstant();
                        if (SubstrateGraphBuilderPlugins.storeClassArrayConstant(result, i, valueConstant, annotationSubstitutions, snippetReflection)) continue;
                        return null;
                    }
                    return result;
                }
                objectStartIndex += virtualObject.entryCount();
            }
            throw VMError.shouldNotReachHere("Must have found the virtual object");
        }
        if (originalArrayNode instanceof NewArrayNode) {
            NewArrayNode newArray = (NewArrayNode)originalArrayNode;
            if (!newArray.elementType().equals((Object)b.getMetaAccess().lookupJavaType(Class.class))) {
                return null;
            }
            ValueNode newArrayLengthNode = newArray.length();
            if (!newArrayLengthNode.isJavaConstant()) {
                return null;
            }
            assert (newArrayLengthNode.asJavaConstant().getJavaKind() == JavaKind.Int);
            int newArrayLength = newArrayLengthNode.asJavaConstant().asInt();
            Class[] result = new Class[newArrayLength];
            FixedNode successor = SubstrateGraphBuilderPlugins.unwrapNode(newArray.next());
            while (successor instanceof StoreIndexedNode) {
                StoreIndexedNode store = (StoreIndexedNode)successor;
                if (SubstrateGraphBuilderPlugins.getDeoptProxyOriginalValue(store.array()).equals(newArray)) {
                    JavaConstant valueConstant;
                    if (!store.index().isJavaConstant()) {
                        return null;
                    }
                    int index = store.index().asJavaConstant().asInt();
                    if (!SubstrateGraphBuilderPlugins.storeClassArrayConstant(result, index, valueConstant = store.value().asJavaConstant(), annotationSubstitutions, snippetReflection)) {
                        return null;
                    }
                }
                successor = SubstrateGraphBuilderPlugins.unwrapNode(store.next());
            }
            if (successor != null && exact) {
                return null;
            }
            return result;
        }
        return null;
    }

    private static boolean storeClassArrayConstant(Class<?>[] result, int index, JavaConstant valueConstant, AnnotationSubstitutionProcessor annotationSubstitutions, SnippetReflectionProvider snippetReflection) {
        if (valueConstant == null || valueConstant.getJavaKind() != JavaKind.Object) {
            return false;
        }
        if (valueConstant.isNull()) {
            result[index] = null;
        } else {
            Class<?> clazz = (Class<?>)snippetReflection.asObject(Class.class, valueConstant);
            if (clazz == null) {
                return false;
            }
            result[index] = annotationSubstitutions == null ? clazz : annotationSubstitutions.getTargetClass(clazz);
        }
        return true;
    }

    private static FixedNode skipNonInterferingNodes(FixedNode node) {
        FixedNode cur = node;
        while (cur instanceof AbstractBeginNode || cur instanceof FullInfopointNode) {
            cur = ((FixedWithNextNode)cur).next();
        }
        return cur;
    }

    private static ValueNode getDeoptProxyOriginalValue(ValueNode node) {
        ValueNode original = node;
        while (original instanceof DeoptProxyNode) {
            original = ((DeoptProxyNode)original).getOriginalNode();
        }
        return original;
    }

    private static FixedNode unwrapNode(FixedNode node) {
        FixedNode successor = node;
        while (true) {
            if (successor instanceof EnsureClassInitializedNode) {
                successor = ((EnsureClassInitializedNode)successor).next();
                continue;
            }
            if (successor instanceof FullInfopointNode) {
                successor = ((FullInfopointNode)successor).next();
                continue;
            }
            if (successor instanceof DeoptEntryNode) {
                assert (MultiMethod.isDeoptTarget((ResolvedJavaMethod)successor.graph().method()));
                successor = ((DeoptEntryNode)successor).next();
                continue;
            }
            if (!(successor instanceof AbstractBeginNode)) break;
            successor = ((AbstractBeginNode)successor).next();
        }
        return successor;
    }

    private static void registerAtomicUpdaterPlugins(final SnippetReflectionProvider snippetReflection, InvocationPlugins plugins) {
        InvocationPlugins.Registration referenceUpdaterRegistration = new InvocationPlugins.Registration(plugins, AtomicReferenceFieldUpdater.class);
        referenceUpdaterRegistration.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("newUpdater", new Type[]{Class.class, Class.class, String.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode tclassNode, ValueNode vclassNode, ValueNode fieldNameNode) {
                SubstrateGraphBuilderPlugins.interceptUpdaterInvoke(b, snippetReflection, tclassNode, fieldNameNode);
                return false;
            }
        });
        InvocationPlugins.Registration integerUpdaterRegistration = new InvocationPlugins.Registration(plugins, AtomicIntegerFieldUpdater.class);
        integerUpdaterRegistration.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("newUpdater", new Type[]{Class.class, String.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode tclassNode, ValueNode fieldNameNode) {
                SubstrateGraphBuilderPlugins.interceptUpdaterInvoke(b, snippetReflection, tclassNode, fieldNameNode);
                return false;
            }
        });
        InvocationPlugins.Registration longUpdaterRegistration = new InvocationPlugins.Registration(plugins, AtomicLongFieldUpdater.class);
        longUpdaterRegistration.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("newUpdater", new Type[]{Class.class, String.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode tclassNode, ValueNode fieldNameNode) {
                SubstrateGraphBuilderPlugins.interceptUpdaterInvoke(b, snippetReflection, tclassNode, fieldNameNode);
                return false;
            }
        });
    }

    private static void interceptUpdaterInvoke(GraphBuilderContext b, SnippetReflectionProvider snippetReflection, ValueNode tclassNode, ValueNode fieldNameNode) {
        if (tclassNode.isConstant() && fieldNameNode.isConstant()) {
            Class tclass = (Class)snippetReflection.asObject(Class.class, tclassNode.asJavaConstant());
            String fieldName = (String)snippetReflection.asObject(String.class, fieldNameNode.asJavaConstant());
            try {
                Field field = tclass.getDeclaredField(fieldName);
                RuntimeReflection.register((Class[])new Class[]{tclass});
                RuntimeReflection.register((Field[])new Field[]{field});
                SubstrateGraphBuilderPlugins.registerAsUnsafeAccessed(b, field);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }

    private static void registerAsUnsafeAccessed(GraphBuilderContext b, Field field) {
        AnalysisField targetField = (AnalysisField)b.getMetaAccess().lookupJavaField(field);
        Object reason = SubstrateGraphBuilderPlugins.nonNullReason(b.getGraph().currentNodeSourcePosition());
        targetField.registerAsAccessed(reason);
        targetField.registerAsUnsafeAccessed(reason);
    }

    private static void registerObjectPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Object.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("clone", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get();
                b.addPush(JavaKind.Object, (ValueNode)new SubstrateObjectCloneWithExceptionNode(MacroNode.MacroParams.of((GraphBuilderContext)b, (ResolvedJavaMethod)targetMethod, (ValueNode[])new ValueNode[]{object})));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("hashCode", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get();
                b.addPush(JavaKind.Int, SubstrateIdentityHashCodeNode.create(object, b.bci()));
                return true;
            }
        });
    }

    private static void registerUnsafePlugins(InvocationPlugins plugins, final SnippetReflectionProvider snippetReflection, final ParsingReason reason) {
        SubstrateGraphBuilderPlugins.registerUnsafePlugins(new InvocationPlugins.Registration(plugins, "sun.misc.Unsafe"), snippetReflection, reason, true);
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.misc.Unsafe");
        SubstrateGraphBuilderPlugins.registerUnsafePlugins(r, snippetReflection, reason, false);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("objectFieldOffset", new Type[]{InvocationPlugin.Receiver.class, Class.class, String.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode classNode, ValueNode nameNode) {
                if (classNode.isConstant() && nameNode.isConstant()) {
                    receiver.get();
                    Class clazz = (Class)snippetReflection.asObject(Class.class, classNode.asJavaConstant());
                    String fieldName = (String)snippetReflection.asObject(String.class, nameNode.asJavaConstant());
                    try {
                        Field targetField = clazz.getDeclaredField(fieldName);
                        return SubstrateGraphBuilderPlugins.processFieldOffset(b, targetField, reason, false);
                    }
                    catch (LinkageError | NoSuchFieldException e) {
                        return false;
                    }
                }
                return false;
            }
        });
        r.register((InvocationPlugin)new StandardGraphBuilderPlugins.AllocateUninitializedArrayPlugin("allocateUninitializedArray", true));
    }

    private static void registerUnsafePlugins(InvocationPlugins.Registration r, final SnippetReflectionProvider snippetReflection, final ParsingReason reason, final boolean isSunMiscUnsafe) {
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("staticFieldOffset", new Type[]{InvocationPlugin.Receiver.class, Field.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode fieldNode) {
                if (fieldNode.isConstant()) {
                    receiver.get();
                    Field targetField = (Field)snippetReflection.asObject(Field.class, fieldNode.asJavaConstant());
                    return SubstrateGraphBuilderPlugins.processFieldOffset(b, targetField, reason, isSunMiscUnsafe);
                }
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("staticFieldBase", new Type[]{InvocationPlugin.Receiver.class, Field.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode fieldNode) {
                if (fieldNode.isConstant()) {
                    receiver.get();
                    Field targetField = (Field)snippetReflection.asObject(Field.class, fieldNode.asJavaConstant());
                    return SubstrateGraphBuilderPlugins.processStaticFieldBase(b, targetField, isSunMiscUnsafe);
                }
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("objectFieldOffset", new Type[]{InvocationPlugin.Receiver.class, Field.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode fieldNode) {
                if (fieldNode.isConstant()) {
                    receiver.get();
                    Field targetField = (Field)snippetReflection.asObject(Field.class, fieldNode.asJavaConstant());
                    return SubstrateGraphBuilderPlugins.processFieldOffset(b, targetField, reason, isSunMiscUnsafe);
                }
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("allocateInstance", new Type[]{InvocationPlugin.Receiver.class, Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode clazz) {
                unsafe.get();
                ValueNode clazzNonNull = b.nullCheckedValue(clazz, DeoptimizationAction.None);
                EnsureClassInitializedNode ensureInitialized = (EnsureClassInitializedNode)b.append((Node)new EnsureClassInitializedNode(clazzNonNull));
                ensureInitialized.setStateAfter(b.getInvocationPluginBeforeState());
                DynamicNewInstanceNode.createAndPush((GraphBuilderContext)b, (ValueNode)clazzNonNull);
                b.add((Node)new StateSplitProxyNode());
                return true;
            }
        });
    }

    private static boolean processFieldOffset(GraphBuilderContext b, Field targetField, ParsingReason reason, boolean isSunMiscUnsafe) {
        if (!SubstrateGraphBuilderPlugins.isValidField(targetField, isSunMiscUnsafe) || reason == ParsingReason.JITCompilation) {
            return false;
        }
        SubstrateGraphBuilderPlugins.registerAsUnsafeAccessed(b, targetField);
        b.addPush(JavaKind.Long, LazyConstantNode.create(StampFactory.forKind((JavaKind)JavaKind.Long), new FieldOffsetConstantProvider(targetField), (CoreProviders)b));
        return true;
    }

    private static boolean isValidField(Field targetField, boolean isSunMiscUnsafe) {
        if (targetField == null) {
            return false;
        }
        return !isSunMiscUnsafe || !targetField.getDeclaringClass().isRecord() && !targetField.getDeclaringClass().isHidden();
    }

    private static boolean processStaticFieldBase(GraphBuilderContext b, Field targetField, boolean isSunMiscUnsafe) {
        if (!SubstrateGraphBuilderPlugins.isValidField(targetField, isSunMiscUnsafe)) {
            return false;
        }
        b.addPush(JavaKind.Object, (ValueNode)StaticFieldsSupport.createStaticFieldBaseNode(targetField.getType().isPrimitive()));
        return true;
    }

    private static void registerArrayPlugins(InvocationPlugins plugins, final SnippetReflectionProvider snippetReflection, ParsingReason reason) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Array.class).setAllowOverwrite(true);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("newInstance", new Type[]{Class.class, int[].class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode clazzNode, ValueNode dimensionsNode) {
                ValueNode dimensionCountNode = GraphUtil.arrayLength((ValueNode)dimensionsNode, (ArrayLengthProvider.FindLengthMode)ArrayLengthProvider.FindLengthMode.SEARCH_ONLY, (ConstantReflectionProvider)b.getConstantReflection());
                if (clazzNode.isConstant() && !clazzNode.isNullConstant() && dimensionCountNode != null && dimensionCountNode.isConstant()) {
                    Class clazz = (Class)snippetReflection.asObject(Class.class, clazzNode.asJavaConstant());
                    int dimensionCount = dimensionCountNode.asJavaConstant().asInt();
                    AnalysisType type = (AnalysisType)b.getMetaAccess().lookupJavaType(clazz);
                    for (int i = 0; i < dimensionCount; ++i) {
                        type = type.getArrayClass();
                        type.registerAsAllocated((Object)AbstractAnalysisEngine.sourcePosition((ValueNode)clazzNode));
                    }
                }
                return false;
            }
        });
    }

    private static void registerKnownIntrinsicsPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, KnownIntrinsics.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("heapBase", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, ReadReservedRegister.createReadHeapBaseNode(b.getGraph()));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("readHub", new Type[]{Object.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                ValueNode nonNullObject = b.nullCheckedValue(object);
                b.addPush(JavaKind.Object, (ValueNode)new LoadHubNode(b.getStampProvider(), nonNullObject));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("nonNullPointer", new Type[]{Pointer.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.addPush(JavaKind.Object, (ValueNode)new PiNode(object, (Stamp)SubstrateGraphBuilderPlugins.nonZeroWord()));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("readStackPointer", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, ReadReservedRegister.createReadStackPointerNode(b.getGraph()));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("readCallerStackPointer", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                SubstrateGraphBuilderPlugins.checkNeverInline(b);
                b.addPush(JavaKind.Object, (ValueNode)new ReadCallerStackPointerNode());
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("readReturnAddress", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                SubstrateGraphBuilderPlugins.checkNeverInline(b);
                b.addPush(JavaKind.Object, (ValueNode)new ReadReturnAddressNode());
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("farReturn", new Type[]{Object.class, Pointer.class, CodePointer.class, Boolean.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode result, ValueNode sp, ValueNode ip, ValueNode fromMethodWithCalleeSavedRegisters) {
                if (!fromMethodWithCalleeSavedRegisters.isConstant()) {
                    throw b.bailout("parameter fromMethodWithCalleeSavedRegisters is not a compile time constant for call to " + targetMethod.format("%H.%n(%p)") + " in " + String.valueOf(b.getMethod().asStackTraceElement(b.bci())));
                }
                b.add((Node)new FarReturnNode(result, sp, ip, fromMethodWithCalleeSavedRegisters.asJavaConstant().asInt() != 0));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("testDeoptimize", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add((Node)new TestDeoptimizeNode());
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("isDeoptimizationTarget", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)MultiMethod.isDeoptTarget((ResolvedJavaMethod)b.getGraph().method())));
                return true;
            }
        });
        SubstrateGraphBuilderPlugins.registerCastExact(r);
    }

    public static void registerCastExact(InvocationPlugins.Registration r) {
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("castExact", new Type[]{Object.class, Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object, ValueNode javaClass) {
                ValueNode nullCheckedClass = b.nullCheckedValue(javaClass);
                LogicNode condition = (LogicNode)b.append((Node)InstanceOfDynamicNode.create((Assumptions)b.getAssumptions(), (ConstantReflectionProvider)b.getConstantReflection(), (ValueNode)nullCheckedClass, (ValueNode)object, (boolean)true, (boolean)true));
                AbstractBeginNode guard = b.emitBytecodeExceptionCheck(condition, true, BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, new ValueNode[]{object, nullCheckedClass});
                if (guard != null) {
                    b.addPush(JavaKind.Object, DynamicPiNode.create((Assumptions)b.getAssumptions(), (ConstantReflectionProvider)b.getConstantReflection(), (ValueNode)object, (GuardingNode)guard, (ValueNode)nullCheckedClass, (boolean)true, (boolean)true));
                } else {
                    b.addPush(JavaKind.Object, object);
                }
                return true;
            }
        });
    }

    private static void checkNeverInline(GraphBuilderContext b) {
        if (!AnnotationAccess.isAnnotationPresent((AnnotatedElement)b.getMethod(), NeverInline.class)) {
            throw VMError.shouldNotReachHere("Accessing the stack pointer or instruction pointer of the caller frame is only safe and deterministic if the method is not inlined. Therefore, the method " + b.getMethod().format("%H.%n(%p)") + " must be annoated with @" + NeverInline.class.getSimpleName());
        }
    }

    private static IntegerStamp nonZeroWord() {
        return StampFactory.forUnsignedInteger((int)64, (long)1L, (long)-1L);
    }

    private static void registerStackValuePlugins(SnippetReflectionProvider snippetReflection, InvocationPlugins plugins) {
        SubstrateGraphBuilderPlugins.registerStackValuePlugins(snippetReflection, new InvocationPlugins.Registration(plugins, StackValue.class), true);
        SubstrateGraphBuilderPlugins.registerStackValuePlugins(snippetReflection, new InvocationPlugins.Registration(plugins, UnsafeStackValue.class), false);
        InvocationPlugins.Registration unsafeLateStackValue = new InvocationPlugins.Registration(plugins, UnsafeLateStackValue.class);
        unsafeLateStackValue.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("get", new Type[]{Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode sizeNode) {
                b.addPush(JavaKind.Object, (ValueNode)LateStackValueNode.create(sizeNode, b.getGraph().method(), b.bci(), false));
                return true;
            }
        });
    }

    private static void registerStackValuePlugins(final SnippetReflectionProvider snippetReflection, InvocationPlugins.Registration r, final boolean disallowVirtualThread) {
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("get", new Type[]{Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode sizeNode) {
                long size = SubstrateGraphBuilderPlugins.longValue(b, targetMethod, sizeNode, "size");
                b.addPush(JavaKind.Object, StackValueNode.create(1L, size, b, disallowVirtualThread));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("get", new Type[]{Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class clazz = SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                int size = SizeOf.get((Class)clazz);
                b.addPush(JavaKind.Object, StackValueNode.create(1L, size, b, disallowVirtualThread));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("get", new Type[]{Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode numElementsNode, ValueNode elementSizeNode) {
                long numElements = SubstrateGraphBuilderPlugins.longValue(b, targetMethod, numElementsNode, "numElements");
                long elementSize = SubstrateGraphBuilderPlugins.longValue(b, targetMethod, elementSizeNode, "elementSize");
                b.addPush(JavaKind.Object, StackValueNode.create(numElements, elementSize, b, disallowVirtualThread));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("get", new Type[]{Integer.TYPE, Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode numElementsNode, ValueNode classNode) {
                long numElements = SubstrateGraphBuilderPlugins.longValue(b, targetMethod, numElementsNode, "numElements");
                Class clazz = SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                int size = SizeOf.get((Class)clazz);
                b.addPush(JavaKind.Object, StackValueNode.create(numElements, size, b, disallowVirtualThread));
                return true;
            }
        });
    }

    private static void registerClassPlugins(InvocationPlugins plugins, SnippetReflectionProvider snippetReflection) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Class.class);
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("getName", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                JavaConstant constantReceiver = receiver.get(false).asJavaConstant();
                if (constantReceiver != null) {
                    receiver.requireNonNull();
                    ResolvedJavaType type = b.getConstantReflection().asJavaType((Constant)constantReceiver);
                    if (type != null) {
                        String className = type.toClassName().intern();
                        b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)b.getConstantReflection().forString(className), (MetaAccessProvider)b.getMetaAccess()));
                        return true;
                    }
                }
                return false;
            }
        });
        SubstrateGraphBuilderPlugins.registerClassDesiredAssertionStatusPlugin(plugins, snippetReflection);
    }

    public static void registerClassDesiredAssertionStatusPlugin(InvocationPlugins plugins, final SnippetReflectionProvider snippetReflection) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Class.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("desiredAssertionStatus", new Type[]{InvocationPlugin.Receiver.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                JavaConstant constantReceiver = receiver.get().asJavaConstant();
                if (constantReceiver != null && constantReceiver.isNonNull()) {
                    boolean desiredAssertionStatus;
                    Object clazzOrHub = snippetReflection.asObject(Object.class, constantReceiver);
                    if (clazzOrHub instanceof Class) {
                        desiredAssertionStatus = RuntimeAssertionsSupport.singleton().desiredAssertionStatus((Class)clazzOrHub);
                    } else if (clazzOrHub instanceof DynamicHub) {
                        desiredAssertionStatus = ((DynamicHub)clazzOrHub).desiredAssertionStatus();
                    } else {
                        throw VMError.shouldNotReachHere("Unexpected class object: " + String.valueOf(clazzOrHub));
                    }
                    b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)desiredAssertionStatus));
                    return true;
                }
                return false;
            }
        });
    }

    private static void registerEdgesPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Edges.class).setAllowOverwrite(true);
        for (final Class c : new Class[]{Node.class, NodeList.class}) {
            r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("get" + ClassUtil.getUnqualifiedName((Class)c) + "Unsafe", new Type[]{Node.class, Long.TYPE}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode node, ValueNode offset) {
                    b.addPush(JavaKind.Object, (ValueNode)new UnsafePartitionLoadNode(node, offset, JavaKind.Object, LocationIdentity.any(), GraalEdgeUnsafePartition.get(), b.getMetaAccess().lookupJavaType(c)));
                    return true;
                }
            });
            r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("put" + ClassUtil.getUnqualifiedName((Class)c) + "Unsafe", new Type[]{Node.class, Long.TYPE, c}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode node, ValueNode offset, ValueNode value) {
                    b.add((Node)new UnsafePartitionStoreNode(node, offset, value, JavaKind.Object, LocationIdentity.any(), GraalEdgeUnsafePartition.get(), b.getMetaAccess().lookupJavaType(c)));
                    return true;
                }
            });
        }
    }

    protected static long longValue(GraphBuilderContext b, ResolvedJavaMethod targetMethod, ValueNode node, String name) {
        if (!node.isConstant()) {
            throw b.bailout("parameter " + name + " is not a compile time constant for call to " + targetMethod.format("%H.%n(%p)") + " in " + String.valueOf(b.getMethod().asStackTraceElement(b.bci())));
        }
        return node.asJavaConstant().asLong();
    }

    private static void registerVMConfigurationPlugins(final SnippetReflectionProvider snippetReflection, InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, ImageSingletons.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("contains", new Type[]{Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class key = SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                boolean result = ImageSingletons.contains((Class)key);
                b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)result));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("lookup", new Type[]{Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class key = SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                Object result = ImageSingletons.lookup((Class)key);
                b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)snippetReflection.forObject(result), (MetaAccessProvider)b.getMetaAccess()));
                return true;
            }
        });
    }

    private static void registerPlatformPlugins(final SnippetReflectionProvider snippetReflection, InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Platform.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("includedIn", new Type[]{Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode classNode) {
                Class platform = SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                boolean result = Platform.includedIn((Class)platform);
                b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)result));
                return true;
            }
        });
    }

    private static void registerSizeOfPlugins(final SnippetReflectionProvider snippetReflection, InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, SizeOf.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("get", new Type[]{Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class clazz = SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                int result = SizeOf.get((Class)clazz);
                b.addPush(JavaKind.Int, (ValueNode)ConstantNode.forInt((int)result));
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("unsigned", new Type[]{Class.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unused, ValueNode classNode) {
                Class clazz = SubstrateGraphBuilderPlugins.constantObjectParameter(b, snippetReflection, targetMethod, 0, Class.class, classNode);
                UnsignedWord result = SizeOf.unsigned((Class)clazz);
                b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)snippetReflection.forObject((Object)result), (MetaAccessProvider)b.getMetaAccess()));
                return true;
            }
        });
    }

    private static void registerReferencePlugins(InvocationPlugins plugins, final ParsingReason parsingReason) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Reference.class);
        r.register((InvocationPlugin)new StandardGraphBuilderPlugins.ReachabilityFencePlugin(){

            protected boolean useExplicitReachabilityFence(GraphBuilderContext b) {
                return parsingReason != ParsingReason.JITCompilation;
            }
        });
    }

    private static void registerReferenceAccessPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, ReferenceAccessImpl.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("getCompressedRepresentation", new Type[]{InvocationPlugin.Receiver.class, Object.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode objectNode) {
                receiver.requireNonNull();
                if (ReferenceAccess.singleton().haveCompressedReferences()) {
                    SubstrateCompressionNode compressedObj = SubstrateCompressionNode.compress(b.getGraph(), objectNode, (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class));
                    JavaKind compressedIntKind = JavaKind.fromWordSize((int)ConfigurationValues.getObjectLayout().getReferenceSize());
                    ValueNode compressedValue = (ValueNode)b.add((Node)WordCastNode.narrowOopToUntrackedWord((ValueNode)compressedObj, (JavaKind)compressedIntKind));
                    b.addPush(JavaKind.Object, ZeroExtendNode.convertUnsigned((ValueNode)compressedValue, (Stamp)FrameAccess.getWordStamp(), (NodeView)NodeView.DEFAULT));
                } else {
                    b.addPush(JavaKind.Object, (ValueNode)WordCastNode.objectToUntrackedPointer((ValueNode)objectNode, (JavaKind)FrameAccess.getWordKind()));
                }
                return true;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("uncompressReference", new Type[]{InvocationPlugin.Receiver.class, UnsignedWord.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode wordNode) {
                receiver.requireNonNull();
                if (ReferenceAccess.singleton().haveCompressedReferences()) {
                    CompressEncoding encoding = (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
                    JavaKind compressedIntKind = JavaKind.fromWordSize((int)ConfigurationValues.getObjectLayout().getReferenceSize());
                    NarrowOopStamp compressedStamp = (NarrowOopStamp)SubstrateNarrowOopStamp.compressed((AbstractObjectStamp)StampFactory.object(), encoding);
                    ValueNode narrowNode = (ValueNode)b.add((Node)NarrowNode.convertUnsigned((ValueNode)wordNode, (Stamp)StampFactory.forKind((JavaKind)compressedIntKind), (NodeView)NodeView.DEFAULT));
                    WordCastNode compressedObj = (WordCastNode)b.add((Node)WordCastNode.wordToNarrowObject((ValueNode)narrowNode, (NarrowOopStamp)compressedStamp));
                    b.addPush(JavaKind.Object, (ValueNode)SubstrateCompressionNode.uncompress(b.getGraph(), (ValueNode)compressedObj, encoding));
                } else {
                    b.addPush(JavaKind.Object, (ValueNode)WordCastNode.wordToObject((ValueNode)wordNode, (JavaKind)FrameAccess.getWordKind()));
                }
                return true;
            }
        });
    }

    private static void registerArraysSupportPlugins(InvocationPlugins plugins, Replacements replacements, Architecture arch) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.util.ArraysSupport", replacements);
        r.registerConditional(VectorizedMismatchNode.isSupported((Architecture)arch), new InvocationPlugin("vectorizedMismatch", new Type[]{Object.class, Long.TYPE, Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode aObject, ValueNode aOffset, ValueNode bObject, ValueNode bOffset, ValueNode length, ValueNode log2ArrayIndexScale) {
                ValueNode aAddr = (ValueNode)b.add((Node)new ComputeObjectAddressNode(aObject, aOffset));
                ValueNode bAddr = (ValueNode)b.add((Node)new ComputeObjectAddressNode(bObject, bOffset));
                b.addPush(JavaKind.Int, (ValueNode)new VectorizedMismatchNode(aAddr, bAddr, length, log2ArrayIndexScale));
                return true;
            }
        });
        r.registerConditional(VectorizedHashCodeNode.isSupported((Architecture)arch), (InvocationPlugin)new StandardGraphBuilderPlugins.VectorizedHashCodeInvocationPlugin("vectorizedHashCode"));
    }

    private static Object nonNullReason(NodeSourcePosition position) {
        return position == null ? "Unknown graph builder location." : position;
    }

    private static void registerAESPlugins(InvocationPlugins plugins, Replacements replacements, Architecture arch) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.CounterMode", replacements);
        r.registerConditional(CounterModeAESNode.isSupported((Architecture)arch), (InvocationPlugin)new StandardGraphBuilderPlugins.CounterModeCryptPlugin(){

            protected boolean canApply(GraphBuilderContext b) {
                return b instanceof BytecodeParser;
            }

            protected ValueNode getFieldOffset(GraphBuilderContext b, ResolvedJavaField field) {
                if (field instanceof AnalysisField) {
                    ((AnalysisField)field).registerAsUnsafeAccessed(SubstrateGraphBuilderPlugins.nonNullReason(b.getGraph().currentNodeSourcePosition()));
                }
                return LazyConstantNode.create(StampFactory.forKind((JavaKind)JavaKind.Long), new FieldOffsetConstantProvider(OriginalFieldProvider.getJavaField((ResolvedJavaField)field)), (CoreProviders)b);
            }

            protected ResolvedJavaType getTypeAESCrypt(MetaAccessProvider metaAccess, ResolvedJavaType context) throws ClassNotFoundException {
                Class<?> classAESCrypt = Class.forName("com.sun.crypto.provider.AESCrypt", true, ClassLoader.getSystemClassLoader());
                return metaAccess.lookupJavaType(classAESCrypt);
            }
        });
        r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.CipherBlockChaining", replacements);
        r.registerConditional(CipherBlockChainingAESNode.isSupported((Architecture)arch), (InvocationPlugin)new SubstrateCipherBlockChainingCryptPlugin(AESNode.CryptMode.ENCRYPT));
        r.registerConditional(CipherBlockChainingAESNode.isSupported((Architecture)arch), (InvocationPlugin)new SubstrateCipherBlockChainingCryptPlugin(AESNode.CryptMode.DECRYPT));
    }

    private static <T> T constantObjectParameter(GraphBuilderContext b, SnippetReflectionProvider snippetReflection, ResolvedJavaMethod targetMethod, int parameterIndex, Class<T> declaredType, ValueNode classNode) {
        SubstrateGraphBuilderPlugins.checkParameterUsage(classNode.isConstant(), b, targetMethod, parameterIndex, "parameter is not a compile time constant");
        Object result = snippetReflection.asObject(declaredType, classNode.asJavaConstant());
        SubstrateGraphBuilderPlugins.checkParameterUsage(result != null, b, targetMethod, parameterIndex, "parameter is null");
        return (T)result;
    }

    public static void checkParameterUsage(boolean condition, GraphBuilderContext b, ResolvedJavaMethod targetMethod, int parameterIndex, String message) {
        Local variable;
        if (condition) {
            return;
        }
        String parameterName = null;
        LocalVariableTable variableTable = targetMethod.getLocalVariableTable();
        if (variableTable != null && (variable = variableTable.getLocal(parameterIndex, 0)) != null) {
            parameterName = variable.getName();
        }
        if (parameterName == null) {
            parameterName = String.valueOf(parameterIndex);
        }
        throw UserError.abort("%s: parameter %s of call to %s in %s", message, parameterName, targetMethod, b.getMethod().asStackTraceElement(b.bci()));
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> DynamicProxyTracing = new HostedOptionKey<Boolean>(false);
    }

    public static class FieldOffsetConstantProvider
    implements Function<CoreProviders, JavaConstant> {
        private final Field javaField;

        public FieldOffsetConstantProvider(Field javaField) {
            this.javaField = javaField;
        }

        @Override
        public JavaConstant apply(CoreProviders providers) {
            ResolvedJavaField rField = providers.getMetaAccess().lookupJavaField(this.javaField);
            if (rField instanceof SharedField) {
                long fieldOffset = ((SharedField)rField).getLocation();
                assert (fieldOffset > 0L);
                return JavaConstant.forLong((long)fieldOffset);
            }
            return null;
        }
    }

    private static class SubstrateCipherBlockChainingCryptPlugin
    extends StandardGraphBuilderPlugins.CipherBlockChainingCryptPlugin {
        SubstrateCipherBlockChainingCryptPlugin(AESNode.CryptMode mode) {
            super(mode);
        }

        protected boolean canApply(GraphBuilderContext b) {
            return b instanceof BytecodeParser;
        }

        protected ResolvedJavaType getTypeAESCrypt(MetaAccessProvider metaAccess, ResolvedJavaType context) throws ClassNotFoundException {
            Class<?> classAESCrypt = Class.forName("com.sun.crypto.provider.AESCrypt", true, ClassLoader.getSystemClassLoader());
            return metaAccess.lookupJavaType(classAESCrypt);
        }
    }
}

