/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.ResourceConfigurationParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import java.net.URI;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.impl.UnresolvedConfigurationCondition;

final class ResourceMetadataParser<C>
extends ResourceConfigurationParser<C> {
    ResourceMetadataParser(ConfigurationConditionResolver<C> conditionResolver, ResourcesRegistry<C> registry, boolean strictConfiguration) {
        super(conditionResolver, registry, strictConfiguration);
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        Object bundlesJson;
        Object resourcesJson = this.getFromGlobalFile(json, "resources");
        if (resourcesJson != null) {
            this.parseGlobsObject(resourcesJson);
        }
        if ((bundlesJson = this.getFromGlobalFile(json, "bundles")) != null) {
            this.parseBundlesObject(bundlesJson);
        }
    }

    @Override
    protected UnresolvedConfigurationCondition parseCondition(EconomicMap<String, Object> condition) {
        return this.parseCondition(condition, true);
    }
}

