/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class ImageHeapInfo {
    public static final long NO_CHUNK = -1L;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHeapLayout.class, canBeNull=true)
    public Object firstReadOnlyRegularObject;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHeapLayout.class, canBeNull=true)
    public Object lastReadOnlyRegularObject;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHeapLayout.class, canBeNull=true)
    public Object firstReadOnlyRelocatableObject;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHeapLayout.class, canBeNull=true)
    public Object lastReadOnlyRelocatableObject;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHeapLayout.class, canBeNull=true)
    public Object firstWritableRegularObject;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHeapLayout.class, canBeNull=true)
    public Object lastWritableRegularObject;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHeapLayout.class, canBeNull=true)
    public Object firstWritableHugeObject;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHeapLayout.class, canBeNull=true)
    public Object lastWritableHugeObject;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHeapLayout.class, canBeNull=true)
    public Object firstReadOnlyHugeObject;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHeapLayout.class, canBeNull=true)
    public Object lastReadOnlyHugeObject;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHeapLayout.class, canBeNull=true)
    public Object firstObject;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterHeapLayout.class, canBeNull=true)
    public Object lastObject;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHeapLayout.class)
    public long offsetOfFirstWritableAlignedChunk;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHeapLayout.class)
    public long offsetOfFirstWritableUnalignedChunk;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHeapLayout.class)
    public long offsetOfLastWritableUnalignedChunk;
    @UnknownPrimitiveField(availability=BuildPhaseProvider.AfterHeapLayout.class)
    public int dynamicHubCount;
    public final ImageHeapInfo next;

    public ImageHeapInfo() {
        this(null);
    }

    public ImageHeapInfo(ImageHeapInfo next) {
        this.next = next;
    }

    public void initialize(Object firstReadOnlyRegularObject, Object lastReadOnlyRegularObject, Object firstReadOnlyRelocatableObject, Object lastReadOnlyRelocatableObject, Object firstWritableRegularObject, Object lastWritableRegularObject, Object firstWritableHugeObject, Object lastWritableHugeObject, Object firstReadOnlyHugeObject, Object lastReadOnlyHugeObject, long offsetOfFirstWritableAlignedChunk, long offsetOfFirstWritableUnalignedChunk, long offsetOfLastWritableUnalignedChunk, int dynamicHubCount) {
        assert (offsetOfFirstWritableAlignedChunk == -1L || offsetOfFirstWritableAlignedChunk >= 0L);
        assert (offsetOfFirstWritableUnalignedChunk == -1L || offsetOfFirstWritableUnalignedChunk >= 0L);
        this.firstReadOnlyRegularObject = firstReadOnlyRegularObject;
        this.lastReadOnlyRegularObject = lastReadOnlyRegularObject;
        this.firstReadOnlyRelocatableObject = firstReadOnlyRelocatableObject;
        this.lastReadOnlyRelocatableObject = lastReadOnlyRelocatableObject;
        this.firstWritableRegularObject = firstWritableRegularObject;
        this.lastWritableRegularObject = lastWritableRegularObject;
        this.firstWritableHugeObject = firstWritableHugeObject;
        this.lastWritableHugeObject = lastWritableHugeObject;
        this.firstReadOnlyHugeObject = firstReadOnlyHugeObject;
        this.lastReadOnlyHugeObject = lastReadOnlyHugeObject;
        this.offsetOfFirstWritableAlignedChunk = offsetOfFirstWritableAlignedChunk;
        this.offsetOfFirstWritableUnalignedChunk = offsetOfFirstWritableUnalignedChunk;
        this.offsetOfLastWritableUnalignedChunk = offsetOfLastWritableUnalignedChunk;
        this.dynamicHubCount = dynamicHubCount;
        Object firstReadOnlyNonHugeObject = firstReadOnlyRegularObject != null ? firstReadOnlyRegularObject : firstReadOnlyRelocatableObject;
        Object lastReadOnlyNonHugeObject = lastReadOnlyRelocatableObject != null ? lastReadOnlyRelocatableObject : lastReadOnlyRegularObject;
        Object firstNonHugeObject = firstReadOnlyNonHugeObject != null ? firstReadOnlyNonHugeObject : firstWritableRegularObject;
        Object lastNonHugeObject = lastWritableRegularObject != null ? lastWritableRegularObject : lastReadOnlyNonHugeObject;
        Object firstHugeObject = firstWritableHugeObject != null ? firstWritableHugeObject : firstReadOnlyHugeObject;
        Object lastHugeObject = lastReadOnlyHugeObject != null ? lastReadOnlyHugeObject : lastWritableHugeObject;
        this.firstObject = firstNonHugeObject != null ? firstNonHugeObject : firstHugeObject;
        this.lastObject = lastHugeObject != null ? lastHugeObject : lastNonHugeObject;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInReadOnlyRegularPartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstReadOnlyRegularObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowThan((UnsignedWord)ImageHeapInfo.getObjectEnd(this.lastReadOnlyRegularObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInReadOnlyRelocatablePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstReadOnlyRelocatableObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowThan((UnsignedWord)ImageHeapInfo.getObjectEnd(this.lastReadOnlyRelocatableObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInWritableRegularPartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstWritableRegularObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowThan((UnsignedWord)ImageHeapInfo.getObjectEnd(this.lastWritableRegularObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInWritableHugePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstWritableHugeObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowThan((UnsignedWord)ImageHeapInfo.getObjectEnd(this.lastWritableHugeObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInReadOnlyHugePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstReadOnlyHugeObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowThan((UnsignedWord)ImageHeapInfo.getObjectEnd(this.lastReadOnlyHugeObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Pointer objectPointer) {
        boolean result = objectPointer.isNull() ? false : objectPointer.aboveOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.firstObject)) && objectPointer.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastObject));
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public AlignedHeapChunk.AlignedHeader getFirstWritableAlignedChunk() {
        return (AlignedHeapChunk.AlignedHeader)ImageHeapInfo.asImageHeapChunk(this.offsetOfFirstWritableAlignedChunk);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnalignedHeapChunk.UnalignedHeader getFirstWritableUnalignedChunk() {
        return (UnalignedHeapChunk.UnalignedHeader)ImageHeapInfo.asImageHeapChunk(this.offsetOfFirstWritableUnalignedChunk);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnalignedHeapChunk.UnalignedHeader getLastWritableUnalignedChunk() {
        return (UnalignedHeapChunk.UnalignedHeader)ImageHeapInfo.asImageHeapChunk(this.offsetOfLastWritableUnalignedChunk);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer getObjectEnd(Object obj) {
        if (obj == null) {
            return (Pointer)WordFactory.nullPointer();
        }
        return LayoutEncoding.getImageHeapObjectEnd(obj);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static <T extends HeapChunk.Header<T>> T asImageHeapChunk(long offsetInImageHeap) {
        if (offsetInImageHeap < 0L) {
            return (T)((HeapChunk.Header)WordFactory.nullPointer());
        }
        UnsignedWord offset = WordFactory.unsigned((long)offsetInImageHeap);
        Pointer heapBase = (Pointer)Isolates.getHeapBase(CurrentIsolate.getIsolate());
        return (T)((HeapChunk.Header)heapBase.add(offset));
    }

    public void print(Log log) {
        log.string("ReadOnly: ").zhex((WordBase)Word.objectToUntrackedPointer((Object)this.firstReadOnlyRegularObject)).string(" - ").zhex((WordBase)ImageHeapInfo.getObjectEnd(this.lastReadOnlyRegularObject)).newline();
        log.string("ReadOnly Relocatables: ").zhex((WordBase)Word.objectToUntrackedPointer((Object)this.firstReadOnlyRelocatableObject)).string(" - ").zhex((WordBase)ImageHeapInfo.getObjectEnd(this.lastReadOnlyRelocatableObject)).newline();
        log.string("Writable: ").zhex((WordBase)Word.objectToUntrackedPointer((Object)this.firstWritableRegularObject)).string(" - ").zhex((WordBase)ImageHeapInfo.getObjectEnd(this.lastWritableRegularObject)).newline();
        log.string("Writable Huge: ").zhex((WordBase)Word.objectToUntrackedPointer((Object)this.firstWritableHugeObject)).string(" - ").zhex((WordBase)ImageHeapInfo.getObjectEnd(this.lastWritableHugeObject)).newline();
        log.string("ReadOnly Huge: ").zhex((WordBase)Word.objectToUntrackedPointer((Object)this.firstReadOnlyHugeObject)).string(" - ").zhex((WordBase)ImageHeapInfo.getObjectEnd(this.lastReadOnlyHugeObject)).newline();
    }
}

