/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.compacting;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.compacting.ObjectMoveInfo;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import java.lang.ref.Reference;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;

public final class ObjectRefFixupVisitor
implements ObjectReferenceVisitor {
    @Override
    public boolean visitObjectReference(Pointer objRef, boolean compressed, Object holderObject) {
        return this.visitObjectReferenceInline(objRef, 0, compressed, holderObject);
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean visitObjectReferenceInline(Pointer objRef, int innerOffset, boolean compressed, Object holderObject) {
        Object obj;
        assert (innerOffset == 0);
        Word p = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
        if (p.isNull() || HeapImpl.getHeapImpl().isInImageHeap((Pointer)p)) {
            return true;
        }
        Object original = p.toObject();
        if (ObjectHeaderImpl.isAlignedObject(original)) {
            Pointer newLocation = ObjectMoveInfo.getNewObjectAddress((Pointer)p);
            assert (newLocation.isNonNull() || holderObject == null || holderObject instanceof Reference);
            obj = newLocation.toObject();
            ReferenceAccess.singleton().writeObjectAt(objRef, obj, compressed);
        } else {
            obj = original;
        }
        if (HeapImpl.usesImageHeapCardMarking() && HeapImpl.getHeapImpl().isInImageHeap(holderObject)) {
            RememberedSet.get().dirtyCardIfNecessary(holderObject, obj);
        }
        return true;
    }
}

