/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.GCCauseSupport;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class GCCause {
    public static final GCCause JavaLangSystemGC = new GCCause("java.lang.System.gc()", 0);
    public static final GCCause UnitTest = new GCCause("Forced GC in unit test", 1);
    public static final GCCause TestGCInDeoptimizer = new GCCause("Test GC in deoptimizer", 2);
    public static final GCCause HintedGC = new GCCause("Hinted GC", 3);
    public static final GCCause JvmtiForceGC = new GCCause("JvmtiEnv ForceGarbageCollection", 4);
    public static final GCCause HeapDump = new GCCause("Heap Dump Initiated GC ", 5);
    private final int id;
    private final String name;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected GCCause(String name, int id) {
        this.id = id;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getId() {
        return this.id;
    }

    public static GCCause fromId(int causeId) {
        return GCCause.getGCCauses().get(causeId);
    }

    public static List<GCCause> getGCCauses() {
        return ((GCCauseSupport)ImageSingletons.lookup(GCCauseSupport.class)).gcCauses;
    }
}

