/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.nmt;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.nmt.NmtMallocHeader;
import com.oracle.svm.core.nmt.NmtMallocMemoryInfo;
import com.oracle.svm.core.util.UnsignedUtils;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class NativeMemoryTracking {
    private static final UnsignedWord ALIGNMENT = WordFactory.unsigned((int)16);
    private static final int MAGIC = -252579085;
    private final NmtMallocMemoryInfo[] categories;
    private final NmtMallocMemoryInfo total = new NmtMallocMemoryInfo();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public NativeMemoryTracking() {
        this.categories = new NmtMallocMemoryInfo[NmtCategory.values().length];
        for (int i = 0; i < this.categories.length; ++i) {
            this.categories[i] = new NmtMallocMemoryInfo();
        }
    }

    @Fold
    public static NativeMemoryTracking singleton() {
        return (NativeMemoryTracking)ImageSingletons.lookup(NativeMemoryTracking.class);
    }

    @Fold
    public static UnsignedWord sizeOfNmtHeader() {
        return UnsignedUtils.roundUp(SizeOf.unsigned(NmtMallocHeader.class), ALIGNMENT);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer initializeHeader(PointerBase outerPtr, UnsignedWord size, NmtCategory category) {
        NmtMallocHeader mallocHeader = (NmtMallocHeader)outerPtr;
        mallocHeader.setAllocationSize(size);
        mallocHeader.setCategory(category.ordinal());
        assert (NativeMemoryTracking.setMagic(mallocHeader));
        return NativeMemoryTracking.getInnerPointer(mallocHeader);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean setMagic(NmtMallocHeader mallocHeader) {
        mallocHeader.setMagic(-252579085);
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void track(PointerBase innerPtr) {
        if (innerPtr.isNull()) {
            return;
        }
        NmtMallocHeader header = NativeMemoryTracking.getHeader(innerPtr);
        UnsignedWord nmtHeaderSize = NativeMemoryTracking.sizeOfNmtHeader();
        UnsignedWord allocationSize = header.getAllocationSize();
        UnsignedWord totalSize = allocationSize.add(nmtHeaderSize);
        this.getInfo(header.getCategory()).track(allocationSize);
        this.getInfo(NmtCategory.NMT).track(nmtHeaderSize);
        this.total.track(totalSize);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public PointerBase untrack(PointerBase innerPtr) {
        if (innerPtr.isNull()) {
            return WordFactory.nullPointer();
        }
        NmtMallocHeader header = NativeMemoryTracking.getHeader(innerPtr);
        this.untrack(header.getAllocationSize(), header.getCategory());
        return header;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void untrack(UnsignedWord size, int category) {
        this.getInfo(category).untrack(size);
        this.getInfo(NmtCategory.NMT).untrack(NativeMemoryTracking.sizeOfNmtHeader());
        this.total.untrack(size.add(NativeMemoryTracking.sizeOfNmtHeader()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static NmtMallocHeader getHeader(PointerBase innerPtr) {
        NmtMallocHeader result = (NmtMallocHeader)((Pointer)innerPtr).subtract(NativeMemoryTracking.sizeOfNmtHeader());
        assert (result.getMagic() == -252579085) : "bad NMT malloc header";
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer getInnerPointer(NmtMallocHeader mallocHeader) {
        return ((Pointer)mallocHeader).add(NativeMemoryTracking.sizeOfNmtHeader());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getUsedMemory(NmtCategory category) {
        return this.getInfo(category).getUsed();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getPeakUsedMemory(NmtCategory category) {
        return this.getInfo(category).getPeakUsed();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getCountAtPeakUsage(NmtCategory category) {
        return this.getInfo(category).getCountAtPeakUsage();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getTotalCount() {
        return this.total.getCount();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getTotalUsedMemory() {
        return this.total.getUsed();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getPeakTotalUsedMemory() {
        return this.total.getPeakUsed();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getCountAtTotalPeakUsage() {
        return this.total.getCountAtPeakUsage();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private NmtMallocMemoryInfo getInfo(NmtCategory category) {
        return this.getInfo(category.ordinal());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private NmtMallocMemoryInfo getInfo(int category) {
        assert (category < this.categories.length);
        return this.categories[category];
    }

    public static RuntimeSupport.Hook shutdownHook() {
        return isFirstIsolate -> NativeMemoryTracking.singleton().printStatistics();
    }

    private void printStatistics() {
        if (VMInspectionOptions.PrintNMTStatistics.getValue().booleanValue()) {
            System.out.println();
            System.out.println("Native memory tracking");
            System.out.println("  Peak total used memory: " + this.getPeakTotalUsedMemory() + " bytes");
            System.out.println("  Total alive allocations at peak usage: " + this.getCountAtTotalPeakUsage());
            System.out.println("  Total used memory: " + this.getTotalUsedMemory() + " bytes");
            System.out.println("  Total alive allocations: " + this.getTotalCount());
            for (int i = 0; i < NmtCategory.values().length; ++i) {
                String name = NmtCategory.values()[i].getName();
                NmtMallocMemoryInfo info = this.getInfo(i);
                System.out.println("  " + name + " peak used memory: " + info.getPeakUsed() + " bytes");
                System.out.println("  " + name + " alive allocations at peak: " + info.getCountAtPeakUsage());
                System.out.println("  " + name + " currently used memory: " + info.getUsed() + " bytes");
                System.out.println("  " + name + " currently alive allocations: " + info.getCount());
            }
        }
    }
}

