/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect.serialize;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.configure.RuntimeConditionSet;
import com.oracle.svm.core.reflect.serialize.MissingSerializationRegistrationUtils;
import com.oracle.svm.core.reflect.serialize.SerializationRegistry;
import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Objects;
import jdk.graal.compiler.java.LambdaUtils;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public class SerializationSupport
implements SerializationRegistry {
    private final Constructor<?> stubConstructor;
    private final EconomicMap<SerializationLookupKey, Object> constructorAccessors;
    private final EconomicMap<Class<?>, RuntimeConditionSet> classes = EconomicMap.create();
    private final EconomicMap<String, RuntimeConditionSet> lambdaCapturingClasses = EconomicMap.create();

    public static SerializationSupport singleton() {
        return (SerializationSupport)ImageSingletons.lookup(SerializationRegistry.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SerializationSupport(Constructor<?> stubConstructor) {
        this.constructorAccessors = ImageHeapMap.create();
        this.stubConstructor = stubConstructor;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Object addConstructorAccessor(Class<?> declaringClass, Class<?> targetConstructorClass, Object constructorAccessor) {
        SerializationLookupKey key = new SerializationLookupKey(declaringClass, targetConstructorClass);
        return this.constructorAccessors.putIfAbsent((Object)key, constructorAccessor);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SerializationLookupKey getKeyFromConstructorAccessorClass(Class<?> constructorAccessorClass) {
        MapCursor cursor = this.constructorAccessors.getEntries();
        while (cursor.advance()) {
            if (!cursor.getValue().getClass().equals(constructorAccessorClass)) continue;
            return (SerializationLookupKey)cursor.getKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerSerializationTargetClass(ConfigurationCondition cnd, Class<?> serializationTargetClass) {
        EconomicMap<Class<?>, RuntimeConditionSet> economicMap = this.classes;
        synchronized (economicMap) {
            RuntimeConditionSet previous = (RuntimeConditionSet)this.classes.putIfAbsent(serializationTargetClass, (Object)RuntimeConditionSet.createHosted(cnd));
            if (previous != null) {
                previous.addCondition(cnd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerLambdaCapturingClass(ConfigurationCondition cnd, String lambdaCapturingClass) {
        EconomicMap<String, RuntimeConditionSet> economicMap = this.lambdaCapturingClasses;
        synchronized (economicMap) {
            RuntimeConditionSet previousConditions = (RuntimeConditionSet)this.lambdaCapturingClasses.putIfAbsent((Object)lambdaCapturingClass, (Object)RuntimeConditionSet.createHosted(cnd));
            if (previousConditions != null) {
                previousConditions.addCondition(cnd);
            }
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean isLambdaCapturingClassRegistered(String lambdaCapturingClass) {
        return this.lambdaCapturingClasses.containsKey((Object)lambdaCapturingClass);
    }

    @Override
    public Object getSerializationConstructorAccessor(Class<?> rawDeclaringClass, Class<?> rawTargetConstructorClass) {
        Class<?> targetConstructorClass;
        Object constructorAccessor;
        Class<Object> declaringClass = rawDeclaringClass;
        if (LambdaUtils.isLambdaClass(declaringClass)) {
            declaringClass = SerializedLambda.class;
        }
        if ((constructorAccessor = this.constructorAccessors.get((Object)new SerializationLookupKey(declaringClass, targetConstructorClass = Modifier.isAbstract(declaringClass.getModifiers()) ? this.stubConstructor.getDeclaringClass() : rawTargetConstructorClass))) != null) {
            return constructorAccessor;
        }
        String targetConstructorClassName = targetConstructorClass.getName();
        if (!SubstrateOptions.ThrowMissingRegistrationErrors.hasBeenSet()) {
            throw VMError.unsupportedFeature("SerializationConstructorAccessor class not found for declaringClass: " + declaringClass.getName() + " (targetConstructorClass: " + targetConstructorClassName + "). Usually adding " + declaringClass.getName() + " to serialization-config.json fixes the problem.");
        }
        MissingSerializationRegistrationUtils.missingSerializationRegistration(declaringClass, "type " + declaringClass.getTypeName() + " with target constructor class: " + targetConstructorClassName);
        return null;
    }

    @Override
    public boolean isRegisteredForSerialization(Class<?> clazz) {
        RuntimeConditionSet conditionSet = (RuntimeConditionSet)this.classes.get(clazz);
        return conditionSet != null && conditionSet.satisfied();
    }

    public static final class SerializationLookupKey {
        private final Class<?> declaringClass;
        private final Class<?> targetConstructorClass;

        private SerializationLookupKey(Class<?> declaringClass, Class<?> targetConstructorClass) {
            assert (declaringClass != null && targetConstructorClass != null);
            this.declaringClass = declaringClass;
            this.targetConstructorClass = targetConstructorClass;
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public Class<?> getTargetConstructorClass() {
            return this.targetConstructorClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SerializationLookupKey that = (SerializationLookupKey)o;
            return this.declaringClass.equals(that.declaringClass) && this.targetConstructorClass.equals(that.targetConstructorClass);
        }

        public int hashCode() {
            return Objects.hash(this.declaringClass, this.targetConstructorClass);
        }
    }

    public static final class StubForAbstractClass
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private StubForAbstractClass() {
        }
    }
}

