/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.sampler;

import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.sampler.ProfilingSampler;
import com.oracle.svm.core.sampler.SamplingStackVisitor;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.thread.ThreadListener;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.concurrent.TimeUnit;
import org.graalvm.collections.LockFreePrefixTree;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.Threading;

public class SafepointProfilingSampler
implements ProfilingSampler,
ThreadListener {
    private static final int DEFAULT_STACK_SIZE = 8192;
    private final SamplingStackVisitor samplingStackVisitor = new SamplingStackVisitor();
    private final LockFreePrefixTree prefixTree = new LockFreePrefixTree((LockFreePrefixTree.Allocator)new LockFreePrefixTree.ObjectPoolingAllocator());
    private final List<SamplerStats> statsList = Collections.synchronizedList(new ArrayList());

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SafepointProfilingSampler() {
        if (!Options.SafepointSamplerStats.hasBeenSet()) {
            return;
        }
        RuntimeSupport.getRuntimeSupport().addShutdownHook(isFirstIsolate -> {
            try (OutputStreamWriter stream = new OutputStreamWriter(Files.newOutputStream(Path.of(Options.SafepointSamplerStats.getValue(), new String[0]), new OpenOption[0]));){
                for (SamplerStats stats : this.statsList) {
                    stream.append(String.format("SampleCount    : %d%n", stats.safepointStats.getCount())).append(String.format("AverageRate    : %d us%n", TimeUnit.NANOSECONDS.toMicros((long)stats.safepointStats.getAverage()))).append(String.format("MinimumRate    : %d us%n", TimeUnit.NANOSECONDS.toMicros(stats.safepointStats.getMin()))).append(String.format("MaximumRate    : %d us%n", TimeUnit.NANOSECONDS.toMicros(stats.safepointStats.getMax()))).append(String.format("DurationCount  : %d%n", stats.durationStats.getCount())).append(String.format("AverageDuration: %d us%n", TimeUnit.NANOSECONDS.toMicros((long)stats.durationStats.getAverage()))).append(String.format("MinimumDuration: %d us%n", TimeUnit.NANOSECONDS.toMicros(stats.durationStats.getMin()))).append(String.format("MaximumDuration: %d us%n", TimeUnit.NANOSECONDS.toMicros(stats.durationStats.getMax()))).append(System.lineSeparator());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    @Override
    public void beforeThreadRun() {
        SamplingStackVisitor.StackTrace stackTrace = new SamplingStackVisitor.StackTrace(8192L);
        SamplerStats samplerStats = new SamplerStats();
        if (Options.SafepointSamplerStats.hasBeenSet()) {
            this.statsList.add(samplerStats);
        }
        Threading.registerRecurringCallback((long)10L, (TimeUnit)TimeUnit.MILLISECONDS, access -> this.sampleThreadStack(stackTrace, samplerStats));
    }

    @Override
    public LockFreePrefixTree prefixTree() {
        return this.prefixTree;
    }

    @Override
    public void reset() {
        this.prefixTree.reset();
    }

    @Override
    public boolean isAsyncSampler() {
        return false;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate inside the safepoint sampler.")
    private void sampleThreadStack(SamplingStackVisitor.StackTrace stackTrace, SamplerStats samplerStats) {
        samplerStats.started();
        stackTrace.reset();
        SafepointProfilingSampler.walkCurrentThread(stackTrace, this.samplingStackVisitor);
        if (stackTrace.overflow) {
            return;
        }
        long[] result = stackTrace.buffer;
        LockFreePrefixTree.Node node = this.prefixTree.root();
        for (int i = stackTrace.num - 1; i >= 0; --i) {
            if (i >= result.length) {
                return;
            }
            if ((node = this.descend(node, result[i])) != null) continue;
            return;
        }
        node.incValue();
        samplerStats.end();
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="Allocations are not allowed in the safepoint sampler, but we keep them unrestricted due to analysis imprecision.")
    private LockFreePrefixTree.Node descend(LockFreePrefixTree.Node node, long result) {
        return node.at(this.prefixTree().allocator(), result);
    }

    @NeverInline(value="Starts a stack walk in the caller frame")
    private static void walkCurrentThread(SamplingStackVisitor.StackTrace data, SamplingStackVisitor visitor) {
        JavaStackWalker.walkCurrentThread(KnownIntrinsics.readStackPointer(), visitor, data);
    }

    static class Options {
        static final HostedOptionKey<String> SafepointSamplerStats = new HostedOptionKey<String>("");

        Options() {
        }
    }

    private static final class SamplerStats {
        private final boolean enabled = Options.SafepointSamplerStats.hasBeenSet();
        private final LongSummaryStatistics safepointStats = this.enabled ? new LongSummaryStatistics() : null;
        private final LongSummaryStatistics durationStats = this.enabled ? new LongSummaryStatistics() : null;
        private long lastSampleStart;

        SamplerStats() {
        }

        private void started() {
            if (!this.enabled) {
                return;
            }
            long start = System.nanoTime();
            if (this.lastSampleStart != 0L) {
                this.safepointStats.accept(start - this.lastSampleStart);
            }
            this.lastSampleStart = start;
        }

        private void end() {
            if (!this.enabled) {
                return;
            }
            this.durationStats.accept(System.nanoTime() - this.lastSampleStart);
        }
    }
}

