/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.windows.headers.SysinfoAPI;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={PhysicalMemory.PhysicalMemorySupport.class})
class WindowsPhysicalMemorySupportImpl
implements PhysicalMemory.PhysicalMemorySupport {
    WindowsPhysicalMemorySupportImpl() {
    }

    @Override
    public UnsignedWord size() {
        SysinfoAPI.MEMORYSTATUSEX memStatusEx = UnsafeStackValue.get(SysinfoAPI.MEMORYSTATUSEX.class);
        memStatusEx.set_dwLength(SizeOf.get(SysinfoAPI.MEMORYSTATUSEX.class));
        SysinfoAPI.GlobalMemoryStatusEx(memStatusEx);
        return WordFactory.unsigned((long)memStatusEx.ullTotalPhys());
    }
}

