/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.graal.isolated.DisableSnippetCountersPlugin;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.phases.util.Providers;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class DisableSnippetCountersFeature
implements InternalFeature {
    DisableSnippetCountersFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.supportCompileInIsolates() || (Boolean)GraalOptions.SnippetCounters.getValue(HostedOptionValues.singleton()) == false;
    }

    @Override
    public void registerGraphBuilderPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        if (reason == ParsingReason.JITCompilation) {
            plugins.appendNodePlugin((NodePlugin)new DisableSnippetCountersPlugin());
        }
    }
}

