/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.c.CInterfaceWrapper;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.phases.CInterfaceEnumTool;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.java.FrameStateBuilder;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumLookup;

public abstract class CCallStubMethod
extends CustomSubstitutionMethod {
    protected final int newThreadStatus;

    CCallStubMethod(ResolvedJavaMethod original, int newThreadStatus) {
        super(original);
        this.newThreadStatus = newThreadStatus;
    }

    protected abstract String getCorrespondingAnnotationName();

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        NativeLibraries nativeLibraries = NativeLibraries.singleton();
        boolean deoptimizationTarget = MultiMethod.isDeoptTarget((ResolvedJavaMethod)method);
        HostedGraphKit kit = new HostedGraphKit(debug, providers, (ResolvedJavaMethod)method);
        FrameStateBuilder state = kit.getFrameState();
        ArrayList<ValueNode> arguments = new ArrayList<ValueNode>(kit.getInitialArguments());
        ValueNode callAddress = this.createTargetAddressNode(kit, arguments);
        AnalysisType[] paramTypes = (AnalysisType[])method.toParameterList().toArray(AnalysisType[]::new);
        ResolvedSignature<AnalysisType> signature = this.adaptSignatureAndConvertArguments(nativeLibraries, kit, method, (AnalysisType)method.getSignature().getReturnType(), paramTypes, arguments);
        state.clearLocals();
        if (ImageSingletons.contains(CInterfaceWrapper.class)) {
            ((CInterfaceWrapper)ImageSingletons.lookup(CInterfaceWrapper.class)).tagCFunctionCallPrologue(kit, (ResolvedJavaMethod)method);
        }
        ValueNode returnValue = kit.createCFunctionCall(callAddress, (List<ValueNode>)arguments, (Signature)signature, this.newThreadStatus, deoptimizationTarget);
        if (ImageSingletons.contains(CInterfaceWrapper.class)) {
            ((CInterfaceWrapper)ImageSingletons.lookup(CInterfaceWrapper.class)).tagCFunctionCallEpilogue(kit, (ResolvedJavaMethod)method);
        }
        returnValue = this.adaptReturnValue(method, nativeLibraries, kit, returnValue);
        kit.createReturn(returnValue, signature.getReturnKind());
        return kit.finalizeGraph();
    }

    protected abstract ValueNode createTargetAddressNode(HostedGraphKit var1, List<ValueNode> var2);

    protected ResolvedSignature<AnalysisType> adaptSignatureAndConvertArguments(NativeLibraries nativeLibraries, HostedGraphKit kit, AnalysisMethod method, AnalysisType returnType, AnalysisType[] parameterTypes, List<ValueNode> arguments) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (CInterfaceEnumTool.isPrimitiveOrWord(parameterTypes[i])) continue;
            EnumInfo enumInfo = this.getEnumInfo(nativeLibraries, parameterTypes[i], false);
            ValueNode argumentValue = kit.maybeCreateExplicitNullCheck(arguments.get(i));
            AnalysisType cValueType = CInterfaceEnumTool.getCEnumValueType(enumInfo, kit.getMetaAccess());
            argumentValue = CInterfaceEnumTool.singleton().createInvokeEnumToValue(kit, enumInfo, cValueType, argumentValue);
            arguments.set(i, argumentValue);
            parameterTypes[i] = cValueType;
        }
        AnalysisType patchedReturnType = returnType;
        if (!CInterfaceEnumTool.isPrimitiveOrWord(patchedReturnType)) {
            assert (this.getEnumInfo(nativeLibraries, patchedReturnType, true) != null);
            patchedReturnType = (AnalysisType)kit.getWordTypes().getWordImplType();
        }
        return ResolvedSignature.fromArray((ResolvedJavaType[])parameterTypes, (ResolvedJavaType)patchedReturnType);
    }

    private ValueNode adaptReturnValue(AnalysisMethod method, NativeLibraries nativeLibraries, HostedGraphKit kit, ValueNode value) {
        AnalysisType declaredReturnType = (AnalysisType)method.getSignature().getReturnType();
        if (CInterfaceEnumTool.isPrimitiveOrWord(declaredReturnType)) {
            return value;
        }
        EnumInfo enumInfo = this.getEnumInfo(nativeLibraries, declaredReturnType, true);
        UserError.guarantee(enumInfo.hasCEnumLookupMethods(), "Enum class %s needs a method that is annotated with @%s because it is used as the return type of a method annotated with @%s: %s.", declaredReturnType, CEnumLookup.class.getSimpleName(), this.getCorrespondingAnnotationName(), this.getOriginal());
        return CInterfaceEnumTool.singleton().createInvokeLookupEnum(kit, declaredReturnType, enumInfo, value);
    }

    private EnumInfo getEnumInfo(NativeLibraries nativeLibraries, AnalysisType type, boolean isReturnType) {
        ElementInfo typeInfo = nativeLibraries.findElementInfo((AnnotatedElement)type);
        if (typeInfo instanceof EnumInfo) {
            EnumInfo enumInfo = (EnumInfo)typeInfo;
            return enumInfo;
        }
        if (isReturnType) {
            throw UserError.abort("Return types of methods annotated with @%s are restricted to primitive types, word types and enumerations (@%s): %s", this.getCorrespondingAnnotationName(), CEnum.class.getSimpleName(), this.getOriginal());
        }
        throw UserError.abort("@%s parameter types are restricted to primitive types, word types and enumerations (@%s): %s", this.getCorrespondingAnnotationName(), CEnum.class.getSimpleName(), this.getOriginal());
    }
}

