/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptTest;
import com.oracle.svm.core.deopt.Specialize;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.nodes.DeoptEntryNode;
import com.oracle.svm.core.graal.phases.DeadStoreRemovalPhase;
import com.oracle.svm.core.graal.phases.OptimizeExceptionPathsPhase;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.code.AnalysisToHostedGraphTransplanter;
import com.oracle.svm.hosted.code.CompilationGraph;
import com.oracle.svm.hosted.code.CompilationInfo;
import com.oracle.svm.hosted.code.DeoptimizationUtils;
import com.oracle.svm.hosted.code.InliningUtilities;
import com.oracle.svm.hosted.code.RestrictHeapAccessAnnotationChecker;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.code.SubstrateHostedCompilationIdentifier;
import com.oracle.svm.hosted.code.UninterruptibleAnnotationChecker;
import com.oracle.svm.hosted.diagnostic.HostedHeapDumpFeature;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.phases.ImageBuildStatisticsCounterPhase;
import com.oracle.svm.hosted.phases.ImplicitAssertionsPhase;
import com.oracle.svm.util.ImageBuildStatistics;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.asm.Assembler;
import jdk.graal.compiler.bytecode.BytecodeProvider;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.GraalCompiler;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.target.Backend;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.debug.GlobalMetrics;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.Indent;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.asm.CompilationResultBuilderFactory;
import jdk.graal.compiler.lir.asm.DataBuilder;
import jdk.graal.compiler.lir.asm.FrameContext;
import jdk.graal.compiler.lir.framemap.FrameMap;
import jdk.graal.compiler.lir.phases.LIRSuites;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphDecoder;
import jdk.graal.compiler.nodes.GraphEncoder;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.IndirectCallTargetNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GeneratedFoldInvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.Phase;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.phases.util.GraphOrder;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.PEGraphDecoder;
import jdk.graal.compiler.replacements.nodes.MacroInvokable;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.VMConstant;
import org.graalvm.nativeimage.ImageSingletons;

public class CompileQueue {
    protected final HostedUniverse universe;
    private final Boolean deoptimizeAll;
    protected final List<Policy> policies;
    protected CompletionExecutor executor;
    protected final ConcurrentMap<HostedMethod, CompileTask> compilations;
    protected final Set<HostedMethod> baseLayerMethods;
    protected final RuntimeConfiguration runtimeConfig;
    protected final MetaAccessProvider metaAccess;
    private Suites regularSuites = null;
    private Suites deoptTargetSuites = null;
    private LIRSuites regularLIRSuites = null;
    private LIRSuites deoptTargetLIRSuites = null;
    protected final FeatureHandler featureHandler;
    protected final GlobalMetrics metricValues = new GlobalMetrics();
    private final AnalysisToHostedGraphTransplanter graphTransplanter;
    private final ParseHooks defaultParseHooks;
    private volatile boolean inliningProgress;
    private final boolean printMethodHistogram = NativeImageOptions.PrintMethodHistogram.getValue();
    private final boolean optionAOTTrivialInline = SubstrateOptions.AOTTrivialInline.getValue();
    private final ConcurrentMap<HostedMethod, UnpublishedTrivialMethods> unpublishedTrivialMethods = new ConcurrentHashMap<HostedMethod, UnpublishedTrivialMethods>();

    public CompileQueue(DebugContext debug, FeatureHandler featureHandler, HostedUniverse universe, RuntimeConfiguration runtimeConfiguration, Boolean deoptimizeAll, List<Policy> policies) {
        this.universe = universe;
        this.compilations = new ConcurrentHashMap<HostedMethod, CompileTask>();
        this.runtimeConfig = runtimeConfiguration;
        this.metaAccess = runtimeConfiguration.getProviders().getMetaAccess();
        this.deoptimizeAll = deoptimizeAll;
        this.policies = policies;
        this.executor = new CompletionExecutor(debug, (BigBang)universe.getBigBang());
        this.featureHandler = featureHandler;
        this.graphTransplanter = this.createGraphTransplanter();
        this.defaultParseHooks = new ParseHooks(this);
        this.baseLayerMethods = universe.hostVM().useBaseLayer() ? ConcurrentHashMap.newKeySet() : null;
        this.callForReplacements(debug, this.runtimeConfig);
    }

    protected AnalysisToHostedGraphTransplanter createGraphTransplanter() {
        return new AnalysisToHostedGraphTransplanter(this.universe, this);
    }

    public static OptimisticOptimizations getOptimisticOpts() {
        return OptimisticOptimizations.ALL.remove(new OptimisticOptimizations.Optimization[]{OptimisticOptimizations.Optimization.UseLoopLimitChecks});
    }

    protected void callForReplacements(DebugContext debug, RuntimeConfiguration runtimeConfig) {
        NativeImageGenerator.registerReplacements(debug, this.featureHandler, runtimeConfig, runtimeConfig.getProviders(), true, true, new GraphEncoder(ConfigurationValues.getTarget().arch));
    }

    public void finish(DebugContext debug) {
        ProgressReporter reporter = ProgressReporter.singleton();
        try {
            try (Object ac = reporter.printParsing();){
                this.parseAll();
            }
            if (!((Boolean)PointstoOptions.UseExperimentalReachabilityAnalysis.getValue(this.universe.hostVM().options())).booleanValue()) {
                this.checkUninterruptibleAnnotations();
                this.checkRestrictHeapAnnotations(debug);
            }
            for (HostedMethod method : this.universe.getMethods()) {
                method.wrapped.setAnalyzedGraph(null);
            }
            if (ImageSingletons.contains(HostedHeapDumpFeature.class)) {
                ((HostedHeapDumpFeature)ImageSingletons.lookup(HostedHeapDumpFeature.class)).beforeInlining();
            }
            ac = reporter.printInlining();
            try {
                this.inlineTrivialMethods(debug);
            }
            finally {
                if (ac != null) {
                    ((ProgressReporter.ReporterClosable)ac).close();
                }
            }
            if (ImageSingletons.contains(HostedHeapDumpFeature.class)) {
                ((HostedHeapDumpFeature)ImageSingletons.lookup(HostedHeapDumpFeature.class)).afterInlining();
            }
            assert (this.suitesNotCreated());
            this.createSuites();
            ac = reporter.printCompiling();
            try {
                this.compileAll();
            }
            finally {
                if (ac != null) {
                    ((ProgressReporter.ReporterClosable)ac).close();
                }
            }
            this.metricValues.print(this.universe.getBigBang().getOptions());
        }
        catch (InterruptedException ie) {
            throw new InterruptImageBuilding();
        }
        if (this.printMethodHistogram) {
            this.printMethodHistogram();
        }
        if (ImageSingletons.contains(HostedHeapDumpFeature.class)) {
            ((HostedHeapDumpFeature)ImageSingletons.lookup(HostedHeapDumpFeature.class)).compileQueueAfterCompilation();
        }
    }

    protected void checkUninterruptibleAnnotations() {
        UninterruptibleAnnotationChecker.checkBeforeCompilation(this.universe.getMethods());
    }

    protected void checkRestrictHeapAnnotations(DebugContext debug) {
        RestrictHeapAccessAnnotationChecker.check(debug, this.universe, this.universe.getMethods());
    }

    private boolean suitesNotCreated() {
        return this.regularSuites == null && this.deoptTargetLIRSuites == null && this.regularLIRSuites == null && this.deoptTargetSuites == null;
    }

    protected void createSuites() {
        this.regularSuites = this.createRegularSuites();
        this.modifyRegularSuites(this.regularSuites);
        this.deoptTargetSuites = this.createDeoptTargetSuites();
        this.removeDeoptTargetOptimizations(this.deoptTargetSuites);
        this.regularLIRSuites = this.createLIRSuites();
        this.deoptTargetLIRSuites = this.createDeoptTargetLIRSuites();
        this.removeDeoptTargetOptimizations(this.deoptTargetLIRSuites);
    }

    protected Suites createRegularSuites() {
        return NativeImageGenerator.createSuites(this.featureHandler, this.runtimeConfig, true);
    }

    protected Suites createDeoptTargetSuites() {
        return NativeImageGenerator.createSuites(this.featureHandler, this.runtimeConfig, true);
    }

    protected LIRSuites createLIRSuites() {
        return NativeImageGenerator.createLIRSuites(this.featureHandler, this.runtimeConfig.getProviders(), true);
    }

    protected LIRSuites createDeoptTargetLIRSuites() {
        return NativeImageGenerator.createLIRSuites(this.featureHandler, this.runtimeConfig.getProviders(), true);
    }

    protected void modifyRegularSuites(Suites suites) {
    }

    protected Suites createSuitesForRegularCompile(StructuredGraph graph, Suites originalSuites) {
        return originalSuites;
    }

    protected PhaseSuite<HighTierContext> afterParseCanonicalization() {
        PhaseSuite phaseSuite = new PhaseSuite();
        phaseSuite.appendPhase((BasePhase)new ImplicitAssertionsPhase());
        phaseSuite.appendPhase((BasePhase)new DeadStoreRemovalPhase());
        phaseSuite.appendPhase((BasePhase)CanonicalizerPhase.create());
        phaseSuite.appendPhase((BasePhase)CanonicalizerPhase.create());
        phaseSuite.appendPhase((BasePhase)new OptimizeExceptionPathsPhase());
        if (((Boolean)ImageBuildStatistics.Options.CollectImageBuildStatistics.getValue(this.universe.hostVM().options())).booleanValue()) {
            phaseSuite.appendPhase((BasePhase)CanonicalizerPhase.create());
            phaseSuite.appendPhase((BasePhase)new ImageBuildStatisticsCounterPhase(ImageBuildStatistics.CheckCountLocation.AFTER_PARSE_CANONICALIZATION));
        }
        phaseSuite.appendPhase((BasePhase)CanonicalizerPhase.create());
        return phaseSuite;
    }

    public Map<HostedMethod, CompileTask> getCompilations() {
        return this.compilations;
    }

    public void purge() {
        this.compilations.clear();
    }

    public Collection<CompileTask> getCompilationTasks() {
        return this.compilations.values();
    }

    private void printMethodHistogram() {
        long sizeAllMethods = 0L;
        long sizeDeoptMethods = 0L;
        long sizeDeoptMethodsInNonDeopt = 0L;
        long sizeNonDeoptMethods = 0L;
        int numberOfMethods = 0;
        int numberOfNonDeopt = 0;
        int numberOfDeopt = 0;
        long totalNumDeoptEntryPoints = 0L;
        long totalNumDuringCallEntryPoints = 0L;
        System.out.format("Code Size; Nodes Parsing; Nodes Before; Nodes After; Is Trivial; Deopt Target; Code Size; Nodes Parsing; Nodes Before; Nodes After; Deopt Entries; Deopt During Call; Entry Points; Direct Calls; Virtual Calls; Method\n", new Object[0]);
        ArrayList tasks = new ArrayList(this.compilations.values());
        tasks.sort(Comparator.comparing(t2 -> t2.method.format("%H.%n(%p) %r")));
        for (CompileTask task : tasks) {
            HostedMethod method = task.method;
            CompilationResult result = task.result;
            CompilationInfo ci = method.compilationInfo;
            if (method.isDeoptTarget()) continue;
            ++numberOfMethods;
            sizeAllMethods += (long)result.getTargetCodeSize();
            System.out.format("%8d; %5d; %5d; %5d; %s;", result.getTargetCodeSize(), ci.numNodesAfterParsing, ci.numNodesBeforeCompilation, ci.numNodesAfterCompilation, ci.isTrivialMethod ? "T" : " ");
            int deoptMethodSize = 0;
            HostedMethod deoptTargetMethod = method.getMultiMethod(MultiMethod.DEOPT_TARGET_METHOD);
            if (deoptTargetMethod != null && this.isRegisteredDeoptTarget(deoptTargetMethod)) {
                CompilationInfo dci = deoptTargetMethod.compilationInfo;
                ++numberOfDeopt;
                deoptMethodSize = ((CompileTask)this.compilations.get((Object)deoptTargetMethod)).result.getTargetCodeSize();
                sizeDeoptMethods += (long)deoptMethodSize;
                sizeDeoptMethodsInNonDeopt += (long)result.getTargetCodeSize();
                totalNumDeoptEntryPoints += dci.numDeoptEntryPoints;
                totalNumDuringCallEntryPoints += dci.numDuringCallEntryPoints;
                System.out.format(" D; %6d; %5d; %5d; %5d; %4d; %4d;", deoptMethodSize, dci.numNodesAfterParsing, dci.numNodesBeforeCompilation, dci.numNodesAfterCompilation, dci.numDeoptEntryPoints, dci.numDuringCallEntryPoints);
            } else {
                sizeNonDeoptMethods += (long)result.getTargetCodeSize();
                ++numberOfNonDeopt;
                System.out.format("  ; %6d; %5d; %5d; %5d; %4d; %4d;", 0, 0, 0, 0, 0, 0);
            }
            System.out.format(" %4d; %4d; %4d; %s%n", ci.numEntryPointCalls.get(), ci.numDirectCalls.get(), ci.numVirtualCalls.get(), method.format("%H.%n(%p) %r"));
        }
        System.out.println();
        System.out.println("Size all methods                           ; " + sizeAllMethods);
        System.out.println("Size deopt methods                         ; " + sizeDeoptMethods);
        System.out.println("Size deopt methods in non-deopt mode       ; " + sizeDeoptMethodsInNonDeopt);
        System.out.println("Size non-deopt method                      ; " + sizeNonDeoptMethods);
        System.out.println("Number of methods                          ; " + numberOfMethods);
        System.out.println("Number of non-deopt methods                ; " + numberOfNonDeopt);
        System.out.println("Number of deopt methods                    ; " + numberOfDeopt);
        System.out.println("Number of deopt entry points               ; " + totalNumDeoptEntryPoints);
        System.out.println("Number of deopt during calls entries       ; " + totalNumDuringCallEntryPoints);
    }

    public CompletionExecutor getExecutor() {
        return this.executor;
    }

    public final void runOnExecutor(Runnable runnable) throws InterruptedException {
        this.executor.init();
        runnable.run();
        this.executor.start();
        this.executor.complete();
        this.executor.shutdown();
    }

    protected void parseAll() throws InterruptedException {
        this.runOnExecutor(this::parseAheadOfTimeCompiledMethods);
        this.runOnExecutor(this::parseDeoptimizationTargetMethods);
    }

    private void parseAheadOfTimeCompiledMethods() {
        for (HostedMethod method : this.universe.getMethods()) {
            if (SubstrateCompilationDirectives.singleton().isRegisteredForDeoptTesting(method)) {
                method.compilationInfo.canDeoptForTesting = true;
                assert (SubstrateCompilationDirectives.singleton().isRegisteredDeoptTarget(method.getMultiMethod(MultiMethod.DEOPT_TARGET_METHOD)));
            }
            for (MultiMethod multiMethod : method.getAllMultiMethods()) {
                HostedMethod hMethod = (HostedMethod)multiMethod;
                if (hMethod.isDeoptTarget() || SubstrateCompilationDirectives.isRuntimeCompiledMethod(hMethod)) continue;
                if (hMethod.isEntryPoint() || SubstrateCompilationDirectives.singleton().isForcedCompilation(hMethod) || hMethod.wrapped.isDirectRootMethod() && hMethod.wrapped.isSimplyImplementationInvoked()) {
                    if (hMethod.wrapped.isInBaseLayer()) {
                        this.baseLayerMethods.add(hMethod);
                    } else {
                        this.ensureParsed(hMethod, null, new EntryPointReason());
                    }
                }
                if (!hMethod.wrapped.isVirtualRootMethod()) continue;
                HostedMethod[] hostedMethodArray = hMethod.getImplementations();
                int n = hostedMethodArray.length;
                for (int i = 0; i < n; ++i) {
                    HostedMethod impl = hostedMethodArray[i];
                    if (impl.wrapped.isInBaseLayer()) {
                        this.baseLayerMethods.add(impl);
                        continue;
                    }
                    VMError.guarantee(impl.wrapped.isImplementationInvoked());
                    this.ensureParsed(impl, null, new EntryPointReason());
                }
            }
        }
        SubstrateForeignCallsProvider foreignCallsProvider = (SubstrateForeignCallsProvider)this.runtimeConfig.getProviders().getForeignCalls();
        for (SubstrateForeignCallLinkage linkage : foreignCallsProvider.getForeignCalls().values()) {
            HostedMethod method = (HostedMethod)linkage.getDescriptor().findMethod(this.runtimeConfig.getProviders().getMetaAccess());
            if (method.wrapped.isDirectRootMethod() && method.wrapped.isSimplyImplementationInvoked()) {
                if (method.wrapped.isInBaseLayer()) {
                    this.baseLayerMethods.add(method);
                } else {
                    this.ensureParsed(method, null, new EntryPointReason());
                }
            }
            if (!method.wrapped.isVirtualRootMethod()) continue;
            for (HostedMethod impl : method.getImplementations()) {
                if (impl.wrapped.isInBaseLayer()) {
                    this.baseLayerMethods.add(impl);
                    continue;
                }
                VMError.guarantee(impl.wrapped.isImplementationInvoked());
                this.ensureParsed(impl, null, new EntryPointReason());
            }
        }
    }

    public boolean isRegisteredDeoptTarget(HostedMethod method) {
        return SubstrateCompilationDirectives.singleton().isRegisteredDeoptTarget(method);
    }

    private void parseDeoptimizationTargetMethods() {
        this.universe.getMethods().stream().map(method -> method.getMultiMethod(MultiMethod.DEOPT_TARGET_METHOD)).filter(deoptMethod -> {
            if (deoptMethod != null) {
                return this.isRegisteredDeoptTarget((HostedMethod)deoptMethod);
            }
            return false;
        }).forEach(deoptMethod -> this.ensureParsed((HostedMethod)deoptMethod, null, new EntryPointReason()));
    }

    private static boolean checkTrivial(HostedMethod method, StructuredGraph graph) {
        return !method.compilationInfo.isTrivialMethod() && method.canBeInlined() && InliningUtilities.isTrivialMethod(graph);
    }

    protected void inlineTrivialMethods(DebugContext debug) throws InterruptedException {
        int round = 0;
        do {
            ProgressReporter.singleton().reportStageProgress();
            this.inliningProgress = false;
            try (Indent ignored = debug.logAndIndent("==== Trivial Inlining  round %d%n", ++round);){
                this.runOnExecutor(() -> this.universe.getMethods().forEach(method -> {
                    assert (method.isOriginalMethod());
                    for (MultiMethod multiMethod : method.getAllMultiMethods()) {
                        HostedMethod hMethod = (HostedMethod)multiMethod;
                        if (hMethod.compilationInfo.getCompilationGraph() == null) continue;
                        this.executor.execute((CompletionExecutor.DebugContextRunnable)new TrivialInlineTask(hMethod));
                    }
                }));
            }
            for (Map.Entry entry : this.unpublishedTrivialMethods.entrySet()) {
                ((HostedMethod)entry.getKey()).compilationInfo.setCompilationGraph(((UnpublishedTrivialMethods)entry.getValue()).unpublishedGraph);
                if (!((UnpublishedTrivialMethods)entry.getValue()).isTrivial) continue;
                ((HostedMethod)entry.getKey()).compilationInfo.setTrivialMethod(true);
            }
            this.unpublishedTrivialMethods.clear();
        } while (this.inliningProgress);
    }

    private void doInlineTrivial(DebugContext debug, HostedMethod method) {
        boolean inliningPotential = false;
        for (CompilationGraph.InvokeInfo invokeInfo : method.compilationInfo.getCompilationGraph().getInvokeInfos()) {
            if (!invokeInfo.getInvokeKind().isDirect() || !this.makeInlineDecision(method, invokeInfo.getTargetMethod())) continue;
            inliningPotential = true;
            break;
        }
        if (!inliningPotential) {
            return;
        }
        Providers providers = this.runtimeConfig.lookupBackend(method).getProviders();
        StructuredGraph graph = method.compilationInfo.createGraph(debug, this.getCustomizedOptions(method, debug), (CompilationIdentifier)CompilationIdentifier.INVALID_COMPILATION_ID, false);
        try (DebugContext.Scope s = debug.scope((Object)"InlineTrivial", (Object)graph, (Object)method, (Object)this);){
            TrivialInliningPlugin inliningPlugin = new TrivialInliningPlugin();
            InliningGraphDecoder decoder = new InliningGraphDecoder(this, graph, providers, inliningPlugin);
            new TrivialInlinePhase(this, decoder, method).apply(graph);
            if (inliningPlugin.inlinedDuringDecoding) {
                CanonicalizerPhase.create().apply(graph, (Object)providers);
                if (!method.compilationInfo.isTrivialInliningDisabled() && graph.getNodeCount() > SubstrateOptions.MaxNodesAfterTrivialInlining.getValue()) {
                    method.compilationInfo.setTrivialInliningDisabled(true);
                    this.inliningProgress = true;
                } else if (CompileQueue.checkTrivial(method, graph)) {
                    this.unpublishedTrivialMethods.put(method, new UnpublishedTrivialMethods(CompilationGraph.encode(graph), true));
                    this.inliningProgress = true;
                } else {
                    this.unpublishedTrivialMethods.put(method, new UnpublishedTrivialMethods(CompilationGraph.encode(graph), false));
                }
            }
        }
        catch (Throwable ex) {
            throw debug.handle(ex);
        }
    }

    private boolean makeInlineDecision(HostedMethod method, HostedMethod callee) {
        if (this.universe.hostVM().neverInlineTrivial(method.getWrapped(), callee.getWrapped())) {
            return false;
        }
        if (callee.shouldBeInlined()) {
            return true;
        }
        return this.optionAOTTrivialInline && callee.compilationInfo.isTrivialMethod() && !method.compilationInfo.isTrivialInliningDisabled();
    }

    private static boolean mustNotAllocateCallee(HostedMethod method) {
        return ((RestrictHeapAccessCallees)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).mustNotAllocate(method);
    }

    private static boolean mustNotAllocate(HostedMethod method) {
        RestrictHeapAccess annotation = method.getAnnotation(RestrictHeapAccess.class);
        return annotation != null && annotation.access() == RestrictHeapAccess.Access.NO_ALLOCATION;
    }

    public static boolean callerAnnotatedWith(Invoke invoke, Class<? extends Annotation> annotationClass) {
        return CompileQueue.getCallerAnnotation(invoke, annotationClass) != null;
    }

    private static <T extends Annotation> T getCallerAnnotation(Invoke invoke, Class<T> annotationClass) {
        for (FrameState state = invoke.stateAfter(); state != null; state = state.outerFrameState()) {
            assert (state.getMethod() != null) : state;
            Annotation annotation = state.getMethod().getAnnotation(annotationClass);
            if (annotation == null) continue;
            return (T)annotation;
        }
        return null;
    }

    protected CompileTask createCompileTask(HostedMethod method, CompileReason reason) {
        return new CompileTask(method, reason);
    }

    protected void compileAll() throws InterruptedException {
        this.runOnExecutor(this::scheduleEntryPoints);
        this.runOnExecutor(this::scheduleDeoptTargets);
        this.notifyAfterCompile();
    }

    private void notifyAfterCompile() {
        for (Policy policy : this.policies) {
            policy.afterCompile();
        }
    }

    public void scheduleEntryPoints() {
        for (HostedMethod method : this.universe.getMethods()) {
            for (MultiMethod multiMethod : method.getAllMultiMethods()) {
                HostedMethod hMethod = (HostedMethod)multiMethod;
                if (hMethod.isDeoptTarget() || SubstrateCompilationDirectives.isRuntimeCompiledMethod(hMethod)) continue;
                if (hMethod.isEntryPoint() || SubstrateCompilationDirectives.singleton().isForcedCompilation(hMethod) || hMethod.wrapped.isDirectRootMethod() && hMethod.wrapped.isSimplyImplementationInvoked()) {
                    if (hMethod.wrapped.isInBaseLayer()) {
                        this.baseLayerMethods.add(hMethod);
                    } else {
                        this.ensureCompiled(hMethod, new EntryPointReason());
                    }
                }
                if (hMethod.wrapped.isVirtualRootMethod()) {
                    MultiMethod.MultiMethodKey key = hMethod.getMultiMethodKey();
                    assert (key != MultiMethod.DEOPT_TARGET_METHOD && key != SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD) : "unexpected method as virtual root " + String.valueOf(hMethod);
                    for (HostedMethod impl : hMethod.getImplementations()) {
                        if (impl.wrapped.isInBaseLayer()) {
                            this.baseLayerMethods.add(impl);
                            continue;
                        }
                        VMError.guarantee(impl.wrapped.isImplementationInvoked());
                        this.ensureCompiled(impl, new EntryPointReason());
                    }
                }
                if (!hMethod.wrapped.isIntrinsicMethod() || !hMethod.wrapped.isInBaseLayer()) continue;
                this.baseLayerMethods.add(hMethod);
            }
        }
    }

    public void scheduleDeoptTargets() {
        for (HostedMethod method : this.universe.getMethods()) {
            HostedMethod deoptTarget = method.getMultiMethod(MultiMethod.DEOPT_TARGET_METHOD);
            if (deoptTarget == null || !this.isRegisteredDeoptTarget(deoptTarget)) continue;
            this.ensureCompiled(deoptTarget, new EntryPointReason());
        }
    }

    protected void ensureParsed(HostedMethod method, HostedMethod callerMethod, CompileReason reason) {
        if (!(NativeImageOptions.AllowFoldMethods.getValue().booleanValue() || method.getAnnotation(Fold.class) == null || callerMethod != null && this.metaAccess.lookupJavaType(GeneratedFoldInvocationPlugin.class).isAssignableFrom((ResolvedJavaType)callerMethod.getDeclaringClass()))) {
            throw VMError.shouldNotReachHere("Parsing method annotated with @" + Fold.class.getSimpleName() + ": " + method.format("%H.%n(%p)") + ". Make sure you have used Graal annotation processors on the parent-project of the method's declaring class.");
        }
        if (!method.compilationInfo.inParseQueue.getAndSet(true)) {
            this.executor.execute((CompletionExecutor.DebugContextRunnable)new ParseTask(method, reason));
        }
    }

    protected final void doParse(DebugContext debug, ParseTask task) {
        ParseFunction customFunction = task.method.compilationInfo.getCustomParseFunction();
        if (customFunction != null) {
            customFunction.parse(debug, task.method, task.reason, this.runtimeConfig);
        } else {
            ParseHooks hooks = task.method.compilationInfo.getCustomParseHooks();
            if (hooks == null) {
                hooks = this.defaultParseHooks;
            }
            this.defaultParseFunction(debug, task.method, task.reason, this.runtimeConfig, hooks);
        }
    }

    private void defaultParseFunction(DebugContext debug, HostedMethod method, CompileReason reason, RuntimeConfiguration config, ParseHooks hooks) {
        if (method.getAnnotation(Node.NodeIntrinsic.class) != null) {
            throw VMError.shouldNotReachHere("Parsing method annotated with @" + Node.NodeIntrinsic.class.getSimpleName() + ": " + method.format("%H.%n(%p)") + ". Make sure you have used Graal annotation processors on the parent-project of the method's declaring class.");
        }
        HostedProviders providers = (HostedProviders)config.lookupBackend(method).getProviders();
        StructuredGraph graph = this.graphTransplanter.transplantGraph(debug, method, reason);
        try (DebugContext.Scope s = debug.scope((Object)"Parsing", (Object)graph, (Object)method, (Object)this);){
            try {
                graph.getGraphState().configureExplicitExceptionsNoDeoptIfNecessary();
                PhaseSuite<HighTierContext> afterParseSuite = hooks.getAfterParseSuite();
                afterParseSuite.apply(graph, (Object)new HighTierContext((Providers)providers, afterParseSuite, CompileQueue.getOptimisticOpts()));
                method.compilationInfo.numNodesAfterParsing = graph.getNodeCount();
                for (Invoke invoke : graph.getInvokes()) {
                    if (!this.canBeUsedForInlining(invoke)) {
                        invoke.setUseForInlining(false);
                    }
                    CallTargetNode targetNode = invoke.callTarget();
                    this.ensureParsed(method, reason, targetNode, (HostedMethod)targetNode.targetMethod(), targetNode.invokeKind().isIndirect() || targetNode instanceof IndirectCallTargetNode);
                }
                for (Node n : graph.getNodes()) {
                    if (!(n instanceof MacroInvokable)) continue;
                    MacroInvokable macroNode = (MacroInvokable)n;
                    this.ensureParsed(method, reason, null, (HostedMethod)macroNode.getTargetMethod(), macroNode.getInvokeKind().isIndirect());
                }
                GraalError.guarantee((boolean)graph.isAfterStage(GraphState.StageFlag.GUARD_LOWERING), (String)"Hosted compilations must have explicit exceptions %s %s", (Object)graph, (Object)graph.getGraphState().getStageFlags());
                this.notifyBeforeEncode(method, graph);
                assert (GraphOrder.assertSchedulableGraph((StructuredGraph)graph));
                method.compilationInfo.encodeGraph(graph);
                if (CompileQueue.checkTrivial(method, graph)) {
                    method.compilationInfo.setTrivialMethod(true);
                }
            }
            catch (Throwable ex) {
                GraalError error = ex instanceof GraalError ? (GraalError)ex : new GraalError(ex);
                error.addContext("method: " + method.format("%r %H.%n(%p)"));
                throw error;
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    private void ensureParsed(HostedMethod method, CompileReason reason, CallTargetNode targetNode, HostedMethod invokeTarget, boolean isIndirect) {
        if (isIndirect) {
            for (HostedMethod invokeImplementation : invokeTarget.getImplementations()) {
                if (invokeImplementation.wrapped.isInBaseLayer()) {
                    this.baseLayerMethods.add(invokeImplementation);
                    continue;
                }
                CompileQueue.handleSpecialization(method, targetNode, invokeTarget, invokeImplementation);
                this.ensureParsed(invokeImplementation, method, new VirtualCallReason(method, invokeImplementation, reason));
            }
        } else if (invokeTarget.wrapped.isSimplyImplementationInvoked()) {
            if (invokeTarget.wrapped.isInBaseLayer()) {
                this.baseLayerMethods.add(invokeTarget);
                return;
            }
            CompileQueue.handleSpecialization(method, targetNode, invokeTarget, invokeTarget);
            this.ensureParsed(invokeTarget, method, new DirectCallReason(method, reason));
        }
    }

    protected void notifyBeforeEncode(HostedMethod method, StructuredGraph graph) {
        HostedProviders providers = (HostedProviders)this.runtimeConfig.lookupBackend(method).getProviders();
        HighTierContext highTierContext = new HighTierContext((Providers)providers, null, CompileQueue.getOptimisticOpts());
        for (Policy policy : this.policies) {
            policy.beforeEncode(method, graph, highTierContext);
        }
    }

    protected OptionValues getCustomizedOptions(HostedMethod method, DebugContext debug) {
        return debug.getOptions();
    }

    protected boolean canBeUsedForInlining(Invoke invoke) {
        HostedMethod callee;
        HostedMethod caller = (HostedMethod)invoke.asNode().graph().method();
        if (!DeoptimizationUtils.canBeUsedForInlining(this.universe, caller, callee = (HostedMethod)invoke.callTarget().targetMethod(), invoke.bci())) {
            return false;
        }
        if (callee.getAnnotation(Specialize.class) != null) {
            return false;
        }
        if (CompileQueue.callerAnnotatedWith(invoke, Specialize.class) && callee.getAnnotation(DeoptTest.class) != null) {
            return false;
        }
        if (!Uninterruptible.Utils.inliningAllowed(caller, callee)) {
            return false;
        }
        if (!CompileQueue.mustNotAllocateCallee(caller) && CompileQueue.mustNotAllocate(callee)) {
            return false;
        }
        return invoke.useForInlining();
    }

    private static void handleSpecialization(HostedMethod method, CallTargetNode targetNode, HostedMethod invokeTarget, HostedMethod invokeImplementation) {
        if (method.getAnnotation(Specialize.class) != null && !method.isDeoptTarget() && invokeTarget.getAnnotation(DeoptTest.class) != null) {
            if (invokeImplementation.compilationInfo.specializedArguments != null) {
                VMError.shouldNotReachHere("Specialized method " + invokeImplementation.format("%H.%n(%p)") + " can only be called from one place");
            }
            invokeImplementation.compilationInfo.specializedArguments = new ConstantNode[targetNode.arguments().size()];
            int idx = 0;
            for (ValueNode argument : targetNode.arguments()) {
                if (!(argument instanceof ConstantNode)) {
                    VMError.shouldNotReachHere("Argument " + idx + " of specialized method " + invokeImplementation.format("%H.%n(%p)") + " is not constant");
                }
                invokeImplementation.compilationInfo.specializedArguments[idx++] = (ConstantNode)argument;
            }
        }
    }

    protected void ensureCompiled(HostedMethod method, CompileReason reason) {
        CompilationInfo compilationInfo = method.compilationInfo;
        assert (method.getMultiMethodKey() != SubstrateCompilationDirectives.RUNTIME_COMPILED_METHOD);
        if (this.printMethodHistogram) {
            if (reason instanceof DirectCallReason) {
                compilationInfo.numDirectCalls.incrementAndGet();
            } else if (reason instanceof VirtualCallReason) {
                compilationInfo.numVirtualCalls.incrementAndGet();
            } else if (reason instanceof EntryPointReason) {
                compilationInfo.numEntryPointCalls.incrementAndGet();
            }
        }
        if (compilationInfo.inCompileQueue) {
            return;
        }
        CompileTask task = this.createCompileTask(method, reason);
        CompileTask oldTask = this.compilations.putIfAbsent(method, task);
        if (oldTask != null) {
            return;
        }
        compilationInfo.inCompileQueue = true;
        this.executor.execute((CompletionExecutor.DebugContextRunnable)task);
        method.setCompiled();
    }

    protected final CompilationResult doCompile(DebugContext debug, HostedMethod method, CompilationIdentifier compilationIdentifier, CompileReason reason) {
        CompileFunction fun = method.compilationInfo.getCustomCompileFunction();
        if (fun == null) {
            fun = this::defaultCompileFunction;
        }
        return fun.compile(debug, method, compilationIdentifier, reason, this.runtimeConfig);
    }

    private CompilationResult defaultCompileFunction(DebugContext debug, HostedMethod method, CompilationIdentifier compilationIdentifier, CompileReason reason, RuntimeConfiguration config) {
        CompilationResult compilationResult;
        block22: {
            if (NativeImageOptions.PrintAOTCompilation.getValue().booleanValue()) {
                TTY.println((String)String.format("[CompileQueue] Compiling [idHash=%10d] %s Reason: %s", System.identityHashCode(method), method.format("%r %H.%n(%p)"), reason));
            }
            SubstrateBackend backend = config.lookupBackend(method);
            VMError.guarantee(method.compilationInfo.getCompilationGraph() != null, "The following method is reachable during compilation, but was not seen during Bytecode parsing: %s", method);
            StructuredGraph graph = method.compilationInfo.createGraph(debug, this.getCustomizedOptions(method, debug), compilationIdentifier, true);
            this.customizeGraph(graph, reason);
            GraalError.guarantee((graph.getGraphState().getGuardsStage() == GraphState.GuardsStage.FIXED_DEOPTS ? 1 : 0) != 0, (String)"Hosted compilations must have explicit exceptions [guard stage] %s=%s", (Object)graph, (Object)graph.getGraphState().getGuardsStage());
            GraalError.guarantee((boolean)graph.isAfterStage(GraphState.StageFlag.GUARD_LOWERING), (String)"Hosted compilations must have explicit exceptions [guard lowering] %s=%s -> %s", (Object)graph, (Object)graph.getGraphState().getStageFlags(), (Object)graph.getGuardsStage());
            if (method.compilationInfo.specializedArguments != null) {
                int idx = 0;
                for (ConstantNode argument : method.compilationInfo.specializedArguments) {
                    ParameterNode local;
                    if ((local = graph.getParameter(idx++)) == null) continue;
                    local.replaceAndDelete((Node)ConstantNode.forConstant((JavaConstant)argument.asJavaConstant(), (MetaAccessProvider)this.runtimeConfig.getProviders().getMetaAccess(), (StructuredGraph)graph));
                }
            }
            assert (GraphOrder.assertSchedulableGraph((StructuredGraph)graph));
            DebugContext.Scope s = debug.scope((Object)"Compiling", (Object)graph, (Object)method, (Object)this);
            try {
                if (this.deoptimizeAll.booleanValue() && method.compilationInfo.canDeoptForTesting) {
                    DeoptimizationUtils.insertDeoptTests(method, graph);
                }
                method.compilationInfo.numNodesBeforeCompilation = graph.getNodeCount();
                method.compilationInfo.numDeoptEntryPoints = graph.getNodes().filter(DeoptEntryNode.class).count();
                method.compilationInfo.numDuringCallEntryPoints = graph.getNodes(MethodCallTargetNode.TYPE).snapshot().stream().map(CallTargetNode::invoke).filter(invoke -> method.compilationInfo.isDeoptEntry(invoke.bci(), FrameState.StackState.AfterPop)).count();
                Suites suites = method.isDeoptTarget() ? this.deoptTargetSuites : this.createSuitesForRegularCompile(graph, this.regularSuites);
                LIRSuites lirSuites = method.isDeoptTarget() ? this.deoptTargetLIRSuites : this.regularLIRSuites;
                CompilationResult result = backend.newCompilationResult(compilationIdentifier, method.getQualifiedName());
                try (Indent indent = debug.logAndIndent("compile %s", (Object)method);){
                    GraalCompiler.compileGraph((StructuredGraph)graph, (ResolvedJavaMethod)method, (Providers)backend.getProviders(), (Backend)backend, null, (OptimisticOptimizations)CompileQueue.getOptimisticOpts(), null, (Suites)suites, (LIRSuites)lirSuites, (CompilationResult)result, (CompilationResultBuilderFactory)new HostedCompilationResultBuilderFactory(this), (boolean)false);
                }
                graph.getOptimizationLog().emit(m -> m.format("%H.%n(%p)"));
                method.compilationInfo.numNodesAfterCompilation = graph.getNodeCount();
                if (method.isDeoptTarget()) assert (DeoptimizationUtils.verifyDeoptTarget(method, graph, result));
                this.ensureCalleesCompiled(method, reason, result);
                if (result.getTargetCode().length > result.getTargetCodeSize()) {
                    result.setTargetCode(Arrays.copyOf(result.getTargetCode(), result.getTargetCodeSize()), result.getTargetCodeSize());
                }
                compilationResult = result;
                if (s == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable ex) {
                    GraalError error = ex instanceof GraalError ? (GraalError)ex : new GraalError(ex);
                    error.addContext("method: " + method.format("%r %H.%n(%p)") + "  [" + String.valueOf(reason) + "]");
                    throw error;
                }
            }
            s.close();
        }
        return compilationResult;
    }

    protected void customizeGraph(StructuredGraph graph, CompileReason reason) {
    }

    protected boolean isDynamicallyResolvedCall(CompilationResult result, Call call) {
        return false;
    }

    protected void ensureCalleesCompiled(HostedMethod method, CompileReason reason, CompilationResult result) {
        for (Infopoint infopoint : result.getInfopoints()) {
            if (!(infopoint instanceof Call)) continue;
            Call call = (Call)infopoint;
            HostedMethod callTarget = (HostedMethod)call.target;
            if (call.direct || this.isDynamicallyResolvedCall(result, call)) {
                if (callTarget.wrapped.isInBaseLayer()) {
                    this.baseLayerMethods.add(callTarget);
                    continue;
                }
                this.ensureCompiled(callTarget, new DirectCallReason(method, reason));
                continue;
            }
            if (callTarget == null || callTarget.getImplementations() == null) continue;
            for (HostedMethod impl : callTarget.getImplementations()) {
                if (impl.wrapped.isInBaseLayer()) {
                    this.baseLayerMethods.add(impl);
                    continue;
                }
                this.ensureCompiled(impl, new VirtualCallReason(method, callTarget, reason));
            }
        }
        this.ensureCompiledForMethodPointerConstants(method, reason, result);
    }

    protected void removeDeoptTargetOptimizations(Suites suites) {
        DeoptimizationUtils.removeDeoptTargetOptimizations(suites);
    }

    protected void removeDeoptTargetOptimizations(LIRSuites lirSuites) {
        DeoptimizationUtils.removeDeoptTargetOptimizations(lirSuites);
    }

    protected final void ensureCompiledForMethodPointerConstants(HostedMethod method, CompileReason reason, CompilationResult result) {
        for (DataPatch dataPatch : result.getDataPatches()) {
            VMConstant constant;
            Reference reference = dataPatch.reference;
            if (!(reference instanceof ConstantReference) || !((constant = ((ConstantReference)reference).getConstant()) instanceof SubstrateMethodPointerConstant)) continue;
            MethodPointer pointer = ((SubstrateMethodPointerConstant)constant).pointer();
            HostedMethod referencedMethod = (HostedMethod)pointer.getMethod();
            if (referencedMethod.wrapped.isInBaseLayer()) {
                this.baseLayerMethods.add(referencedMethod);
                continue;
            }
            this.ensureCompiled(referencedMethod, new MethodPointerConstantReason(method, referencedMethod, reason));
        }
    }

    public Set<HostedMethod> getBaseLayerMethods() {
        return this.baseLayerMethods;
    }

    public Map<HostedMethod, CompilationResult> getCompilationResults() {
        TreeMap<HostedMethod, CompilationResult> result = new TreeMap<HostedMethod, CompilationResult>(HostedUniverse.METHOD_COMPARATOR);
        for (Map.Entry entry : this.compilations.entrySet()) {
            result.put((HostedMethod)entry.getKey(), ((CompileTask)entry.getValue()).result);
        }
        return result;
    }

    public Suites getRegularSuites() {
        return this.regularSuites;
    }

    public static class ParseHooks {
        private final CompileQueue compileQueue;

        protected ParseHooks(CompileQueue compileQueue) {
            this.compileQueue = compileQueue;
        }

        protected PhaseSuite<HighTierContext> getAfterParseSuite() {
            return this.compileQueue.afterParseCanonicalization();
        }
    }

    public class CompileTask
    implements Task {
        public final HostedMethod method;
        protected final CompileReason reason;
        public CompilationResult result;
        public final CompilationIdentifier compilationIdentifier;

        public CompileTask(HostedMethod method, CompileReason reason) {
            this.method = method;
            this.reason = reason;
            this.compilationIdentifier = new SubstrateHostedCompilationIdentifier(method);
        }

        @Override
        public DebugContext getDebug(OptionValues options, List<DebugHandlersFactory> factories) {
            return new DebugContext.Builder(options, factories).description(this.getDescription()).globalMetrics(CompileQueue.this.metricValues).build();
        }

        public void run(DebugContext debug) {
            this.result = CompileQueue.this.doCompile(debug, this.method, this.compilationIdentifier, this.reason);
        }

        public DebugContext.Description getDescription() {
            return new DebugContext.Description((Object)this.method, this.compilationIdentifier.toString(CompilationIdentifier.Verbosity.ID));
        }

        public CompileReason getReason() {
            return this.reason;
        }
    }

    public static class EntryPointReason
    extends CompileReason {
        public EntryPointReason() {
            super(null);
        }

        public String toString() {
            return "entry point";
        }
    }

    public static abstract class CompileReason {
        private final CompileReason prevReason;

        public CompileReason(CompileReason prevReason) {
            this.prevReason = prevReason;
        }
    }

    public record UnpublishedTrivialMethods(CompilationGraph unpublishedGraph, boolean isTrivial) {
    }

    class TrivialInliningPlugin
    implements InlineInvokePlugin {
        boolean inlinedDuringDecoding;

        TrivialInliningPlugin() {
        }

        public InlineInvokePlugin.InlineInfo shouldInlineInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
            if (CompileQueue.this.makeInlineDecision((HostedMethod)b.getMethod(), (HostedMethod)method) && b.recursiveInliningDepth(method) == 0) {
                this.inlinedDuringDecoding = true;
                return InlineInvokePlugin.InlineInfo.createStandardInlineInfo((ResolvedJavaMethod)method);
            }
            return InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION;
        }
    }

    class InliningGraphDecoder
    extends PEGraphDecoder {
        InliningGraphDecoder(CompileQueue this$0, StructuredGraph graph, Providers providers, TrivialInliningPlugin inliningPlugin) {
            super(AnalysisParsedGraph.HOST_ARCHITECTURE, graph, (CoreProviders)providers, null, null, new InlineInvokePlugin[]{inliningPlugin}, null, null, null, null, new ConcurrentHashMap(), new ConcurrentHashMap(), true, false);
        }

        protected EncodedGraph lookupEncodedGraph(ResolvedJavaMethod method, BytecodeProvider intrinsicBytecodeProvider) {
            return ((HostedMethod)method).compilationInfo.getCompilationGraph().getEncodedGraph();
        }

        protected GraphDecoder.LoopScope trySimplifyInvoke(PEGraphDecoder.PEMethodScope methodScope, GraphDecoder.LoopScope loopScope, GraphDecoder.InvokeData invokeData, MethodCallTargetNode callTarget) {
            if (((HostedMethod)callTarget.targetMethod()).wrapped.isInBaseLayer()) {
                return null;
            }
            return super.trySimplifyInvoke(methodScope, loopScope, invokeData, callTarget);
        }
    }

    class TrivialInlinePhase
    extends Phase {
        final InliningGraphDecoder decoder;
        final HostedMethod method;

        TrivialInlinePhase(CompileQueue this$0, InliningGraphDecoder decoder, HostedMethod method) {
            this.decoder = decoder;
            this.method = method;
        }

        protected void run(StructuredGraph graph) {
            this.decoder.decode(this.method);
        }

        public CharSequence getName() {
            return "TrivialInline";
        }
    }

    public static abstract class Policy {
        protected final HostedUniverse universe;

        public Policy(HostedUniverse universe) {
            this.universe = universe;
        }

        public abstract void beforeEncode(HostedMethod var1, StructuredGraph var2, HighTierContext var3);

        public void afterCompile() {
        }
    }

    public class ParseTask
    implements Task {
        protected final CompileReason reason;
        private final HostedMethod method;
        private final DebugContext.Description description;

        public ParseTask(HostedMethod method, CompileReason reason) {
            this.method = method;
            this.reason = reason;
            this.description = new DebugContext.Description((Object)method, method.getName());
        }

        public void run(DebugContext debug) {
            CompileQueue.this.doParse(debug, this);
        }

        public DebugContext.Description getDescription() {
            return this.description;
        }
    }

    public static interface ParseFunction {
        public void parse(DebugContext var1, HostedMethod var2, CompileReason var3, RuntimeConfiguration var4);
    }

    public static class VirtualCallReason
    extends CompileReason {
        private final HostedMethod caller;
        private final HostedMethod callTarget;

        public VirtualCallReason(HostedMethod caller, HostedMethod callTarget, CompileReason prevReason) {
            super(prevReason);
            this.caller = caller;
            this.callTarget = callTarget;
        }

        public String toString() {
            return "Virtual call from " + this.caller.format("%r %h.%n(%p)") + ", callTarget " + this.callTarget.format("%r %h.%n(%p)");
        }
    }

    public static class DirectCallReason
    extends CompileReason {
        private final HostedMethod caller;

        public DirectCallReason(HostedMethod caller, CompileReason prevReason) {
            super(prevReason);
            this.caller = caller;
        }

        public String toString() {
            return "Direct call from " + this.caller.format("%r %h.%n(%p)");
        }
    }

    public static interface CompileFunction {
        public CompilationResult compile(DebugContext var1, HostedMethod var2, CompilationIdentifier var3, CompileReason var4, RuntimeConfiguration var5);
    }

    class HostedCompilationResultBuilderFactory
    implements CompilationResultBuilderFactory {
        HostedCompilationResultBuilderFactory(CompileQueue this$0) {
        }

        public CompilationResultBuilder createBuilder(CoreProviders providers, FrameMap frameMap, Assembler<?> asm, DataBuilder dataBuilder, FrameContext frameContext, OptionValues options, DebugContext debug, CompilationResult compilationResult, Register uncompressedNullRegister, LIR lir) {
            return new CompilationResultBuilder(providers, frameMap, asm, dataBuilder, frameContext, options, debug, compilationResult, uncompressedNullRegister, CompilationResultBuilder.NO_VERIFIERS, lir);
        }
    }

    public static class MethodPointerConstantReason
    extends CompileReason {
        private final HostedMethod owner;
        private final HostedMethod callTarget;

        public MethodPointerConstantReason(HostedMethod owner, HostedMethod callTarget, CompileReason prevReason) {
            super(prevReason);
            this.owner = owner;
            this.callTarget = callTarget;
        }

        public String toString() {
            return "Method " + this.callTarget.format("%r %h.%n(%p)") + " is reachable through a method pointer from " + this.owner.format("%r %h.%n(%p)");
        }
    }

    protected class TrivialInlineTask
    implements Task {
        private final HostedMethod method;
        private final DebugContext.Description description;

        TrivialInlineTask(HostedMethod method) {
            this.method = method;
            this.description = new DebugContext.Description((Object)method, method.getName());
        }

        public void run(DebugContext debug) {
            CompileQueue.this.doInlineTrivial(debug, this.method);
        }

        public DebugContext.Description getDescription() {
            return this.description;
        }
    }

    protected static interface Task
    extends CompletionExecutor.DebugContextRunnable {
        default public DebugContext getDebug(OptionValues options, List<DebugHandlersFactory> factories) {
            return new DebugContext.Builder(options, factories).description(this.getDescription()).build();
        }
    }
}

