/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.graal.pointsto.util.TimerCollection;
import com.oracle.objectfile.BasicProgbitsSectionImpl;
import com.oracle.objectfile.ElementImpl;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import com.oracle.objectfile.io.AssemblyBuffer;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.UniqueShortNameProvider;
import com.oracle.svm.core.UniqueShortNameProviderDefaultImpl;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import com.oracle.svm.hosted.image.AbstractImage;
import com.oracle.svm.hosted.image.NativeImageBFDNameProvider;
import com.oracle.svm.hosted.image.NativeImageDebugInfoProvider;
import com.oracle.svm.hosted.image.sources.SourceManager;
import com.oracle.svm.hosted.util.DiagnosticUtils;
import com.oracle.svm.util.ReflectionUtil;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredFeature
class NativeImageDebugInfoFeature
implements InternalFeature {
    private NativeImageBFDNameProvider bfdNameProvider;

    NativeImageDebugInfoFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.useDebugInfoGeneration();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (!UniqueShortNameProviderDefaultImpl.UseDefault.useDefaultProvider() && !ImageSingletons.contains(UniqueShortNameProvider.class)) {
            FeatureImpl.AfterRegistrationAccessImpl accessImpl = (FeatureImpl.AfterRegistrationAccessImpl)access;
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            ClassLoader appLoader = accessImpl.getApplicationClassLoader();
            ClassLoader imageLoader = accessImpl.getImageClassLoader().getClassLoader();
            ClassLoader imageLoaderParent = imageLoader.getParent();
            assert (imageLoaderParent == appLoader.getParent());
            List<ClassLoader> ignored = List.of(systemLoader, imageLoaderParent, appLoader, imageLoader);
            this.bfdNameProvider = new NativeImageBFDNameProvider(ignored);
            ImageSingletons.add(UniqueShortNameProvider.class, (Object)this.bfdNameProvider);
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (this.bfdNameProvider != null) {
            FeatureImpl.BeforeAnalysisAccessImpl accessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
            this.bfdNameProvider.setNativeLibs(accessImpl.getNativeLibraries());
        }
        access.registerAsAccessed(ReflectionUtil.lookupField(ClassLoader.class, (String)"nameAndId"));
        CompressEncoding compressEncoding = (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
        CGlobalData compressedShift = CGlobalDataFactory.createWord((WordBase)WordFactory.signed((int)compressEncoding.getShift()), "__svm_compressed_shift");
        CGlobalData useHeapBase = CGlobalDataFactory.createWord((WordBase)WordFactory.unsigned((int)(compressEncoding.hasBase() ? 1 : 0)), "__svm_use_heap_base");
        CGlobalData oopTagsMask = CGlobalDataFactory.createWord((WordBase)WordFactory.unsigned((int)Heap.getHeap().getObjectHeader().getReservedBitsMask()), "__svm_oop_tags_mask");
        CGlobalData objectAlignment = CGlobalDataFactory.createWord((WordBase)WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment()), "__svm_object_alignment");
        CGlobalDataFeature.singleton().registerWithGlobalHiddenSymbol(compressedShift);
        CGlobalDataFeature.singleton().registerWithGlobalHiddenSymbol(useHeapBase);
        CGlobalDataFeature.singleton().registerWithGlobalHiddenSymbol(oopTagsMask);
        CGlobalDataFeature.singleton().registerWithGlobalHiddenSymbol(objectAlignment);
    }

    public void beforeImageWrite(Feature.BeforeImageWriteAccess access) {
        Timer timer = TimerCollection.singleton().get(TimerCollection.Registry.DEBUG_INFO);
        try (Timer.StopTimer t = timer.start();){
            ImageSingletons.add(SourceManager.class, (Object)new SourceManager());
            FeatureImpl.BeforeImageWriteAccessImpl accessImpl = (FeatureImpl.BeforeImageWriteAccessImpl)access;
            AbstractImage image = accessImpl.getImage();
            DebugContext debugContext = new DebugContext.Builder(HostedOptionValues.singleton(), (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalAccess.getOriginalSnippetReflection())).build();
            RuntimeConfiguration runtimeConfiguration = ((FeatureImpl.BeforeImageWriteAccessImpl)access).getRuntimeConfiguration();
            NativeImageDebugInfoProvider provider = new NativeImageDebugInfoProvider(debugContext, image.getCodeCache(), image.getHeap(), image.getNativeLibs(), accessImpl.getHostedMetaAccess(), runtimeConfiguration);
            ObjectFile objectFile = image.getObjectFile();
            objectFile.installDebugInfo((DebugInfoProvider)provider);
            if (Platform.includedIn(Platform.LINUX.class) && SubstrateOptions.UseImagebuildDebugSections.getValue().booleanValue()) {
                Function<List, BasicProgbitsSectionImpl> makeSectionImpl = customInfo -> {
                    AssemblyBuffer content = AssemblyBuffer.createOutputAssembler((ByteOrder)objectFile.getByteOrder());
                    for (String elem : customInfo) {
                        content.writeString(elem);
                    }
                    return new BasicProgbitsSectionImpl(this, content.getBlob()){

                        public boolean isLoadable() {
                            return false;
                        }
                    };
                };
                Supplier<BasicProgbitsSectionImpl> makeGDBSectionImpl = () -> {
                    AssemblyBuffer content = AssemblyBuffer.createOutputAssembler((ByteOrder)objectFile.getByteOrder());
                    content.writeByte((byte)1);
                    content.writeString("./svmhelpers.py");
                    return new BasicProgbitsSectionImpl(this, content.getBlob()){

                        public boolean isLoadable() {
                            return false;
                        }
                    };
                };
                ImageClassLoader imageClassLoader = accessImpl.getImageClassLoader();
                objectFile.newUserDefinedSection(".debug.svm.imagebuild.classpath", (ElementImpl)makeSectionImpl.apply(DiagnosticUtils.getClassPath(imageClassLoader)));
                objectFile.newUserDefinedSection(".debug.svm.imagebuild.modulepath", (ElementImpl)makeSectionImpl.apply(DiagnosticUtils.getModulePath(imageClassLoader)));
                objectFile.newUserDefinedSection(".debug.svm.imagebuild.arguments", (ElementImpl)makeSectionImpl.apply(DiagnosticUtils.getBuilderArguments(imageClassLoader)));
                objectFile.newUserDefinedSection(".debug.svm.imagebuild.java.properties", (ElementImpl)makeSectionImpl.apply(DiagnosticUtils.getBuilderProperties()));
                Path svmDebugHelper = Path.of(System.getProperty("java.home"), "lib/svm/debug/svmhelpers.py");
                if (Files.exists(svmDebugHelper, new LinkOption[0])) {
                    objectFile.newUserDefinedSection(".debug_gdb_scripts", (ElementImpl)makeGDBSectionImpl.get());
                }
            }
        }
        ProgressReporter.singleton().setDebugInfoTimer(timer);
    }
}

