/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.imagelayer.DynamicImageLayerInfo;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.imagelayer.HostedDynamicLayerInfo;
import com.oracle.svm.hosted.meta.HostedMethod;
import jdk.graal.compiler.code.CompilationResult;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class HostedDynamicLayerInfoFeature
implements InternalFeature {
    HostedDynamicLayerInfoFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ImageLayerBuildingSupport.buildingImageLayer();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (ImageLayerBuildingSupport.buildingInitialLayer()) {
            ImageSingletons.add(DynamicImageLayerInfo.class, (Object)new HostedDynamicLayerInfo());
        }
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        if (ImageLayerBuildingSupport.buildingApplicationLayer()) {
            return;
        }
        FeatureImpl.AfterCompilationAccessImpl config = (FeatureImpl.AfterCompilationAccessImpl)access;
        assert (HostedDynamicLayerInfo.singleton().verifyUniqueOffsets(config.getMethods()));
        for (Pair<HostedMethod, CompilationResult> entry : config.getCodeCache().getOrderedCompilations()) {
            HostedDynamicLayerInfo.singleton().registerOffset((HostedMethod)entry.getLeft());
        }
    }
}

