/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.bootstrap.BootstrapMethodConfiguration;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.phases.SharedGraphBuilderPhase;
import com.oracle.svm.util.ModuleSupport;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.invoke.WrongMethodTypeException;
import java.util.List;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.java.BciBlockMapping;
import jdk.graal.compiler.java.BytecodeParser;
import jdk.graal.compiler.java.FrameStateBuilder;
import jdk.graal.compiler.java.GraphBuilderPhase;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.calc.ObjectEqualsNode;
import jdk.graal.compiler.nodes.extended.BoxNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.UnboxNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.IntrinsicContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.java.StoreIndexedNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.collections.Pair;

public class AnalysisGraphBuilderPhase
extends SharedGraphBuilderPhase {
    protected final SVMHost hostVM;

    public AnalysisGraphBuilderPhase(CoreProviders providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext, SVMHost hostVM) {
        super(providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext);
        this.hostVM = hostVM;
    }

    protected BytecodeParser createBytecodeParser(StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
        return new AnalysisBytecodeParser((GraphBuilderPhase.Instance)this, graph, parent, method, entryBCI, intrinsicContext, this.hostVM, true);
    }

    public static class AnalysisBytecodeParser
    extends SharedGraphBuilderPhase.SharedBytecodeParser {
        private final SVMHost hostVM;

        protected AnalysisBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext, SVMHost hostVM, boolean explicitExceptionEdges) {
            super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext, explicitExceptionEdges);
            this.hostVM = hostVM;
        }

        protected boolean tryInvocationPlugin(CallTargetNode.InvokeKind invokeKind, ValueNode[] args, ResolvedJavaMethod targetMethod, JavaKind resultType) {
            boolean result = super.tryInvocationPlugin(invokeKind, args, targetMethod, resultType);
            if (result) {
                ((AnalysisMethod)targetMethod).registerAsIntrinsicMethod(AnalysisBytecodeParser.nonNullReason(this.graph.currentNodeSourcePosition()));
            }
            return result;
        }

        private static Object nonNullReason(Object reason) {
            return reason == null ? "Unknown invocation location." : reason;
        }

        protected boolean applyInvocationPlugin(CallTargetNode.InvokeKind invokeKind, ValueNode[] args, ResolvedJavaMethod targetMethod, JavaKind resultType, InvocationPlugin plugin) {
            Class<?> accessingClass = plugin.getClass();
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, accessingClass, (boolean)false, (String)"jdk.internal.vm.ci", (String[])new String[]{"jdk.vm.ci.meta"});
            ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, accessingClass, (boolean)false, (String)"jdk.graal.compiler", (String[])new String[]{"jdk.graal.compiler.nodes"});
            return super.applyInvocationPlugin(invokeKind, args, targetMethod, resultType, plugin);
        }

        private boolean tryNodePluginForDynamicInvocation(ConstantPool.BootstrapMethodInvocation bootstrap) {
            for (NodePlugin plugin : this.graphBuilderConfig.getPlugins().getNodePlugins()) {
                Pair result = plugin.convertInvokeDynamic((GraphBuilderContext)this, bootstrap);
                if (result == null) continue;
                this.appendInvoke(CallTargetNode.InvokeKind.Static, (ResolvedJavaMethod)result.getLeft(), (ValueNode[])result.getRight(), null);
                return true;
            }
            return false;
        }

        protected void genInvokeDynamic(int cpi, int opcode) {
            ConstantPool.BootstrapMethodInvocation bootstrap;
            try {
                bootstrap = this.constantPool.lookupBootstrapMethodInvocation(cpi, opcode);
            }
            catch (Throwable ex) {
                this.bootstrapMethodHandler.handleBootstrapException(ex, "invoke dynamic");
                return;
            }
            if (bootstrap != null && this.tryNodePluginForDynamicInvocation(bootstrap)) {
                return;
            }
            JavaMethod calleeMethod = this.lookupMethodInPool(cpi, opcode);
            if (bootstrap == null || calleeMethod instanceof ResolvedJavaMethod || BootstrapMethodConfiguration.singleton().isIndyAllowedAtBuildTime(OriginalMethodProvider.getJavaMethod((ResolvedJavaMethod)bootstrap.getMethod()))) {
                super.genInvokeDynamic(cpi, opcode);
                return;
            }
            int parameterLength = bootstrap.getMethod().getParameters().length;
            List staticArgumentsList = bootstrap.getStaticArguments();
            boolean isVarargs = bootstrap.getMethod().isVarArgs();
            int bci = this.bci();
            MethodType methodType = (MethodType)this.getSnippetReflection().asObject(MethodType.class, bootstrap.getType());
            for (JavaConstant argument : staticArgumentsList) {
                Object arg = this.getSnippetReflection().asObject(Object.class, argument);
                if (!(arg instanceof UnresolvedJavaType)) continue;
                UnresolvedJavaType unresolvedJavaType = (UnresolvedJavaType)arg;
                this.handleUnresolvedType((JavaType)unresolvedJavaType);
                return;
            }
            if (!this.bootstrapMethodHandler.checkBootstrapParameters(bootstrap.getMethod(), staticArgumentsList, false)) {
                WrongMethodTypeException cause = new WrongMethodTypeException("Cannot convert " + String.valueOf(methodType) + " to correct MethodType");
                AnalysisBytecodeParser.replaceWithThrowingAtRuntime(this, new BootstrapMethodError("Bootstrap method initialization exception", cause));
                return;
            }
            Object initializedCallSite = this.bootstrapMethodHandler.resolveLinkedObject(bci, cpi, opcode, bootstrap, parameterLength, staticArgumentsList, isVarargs, false);
            if (initializedCallSite instanceof UnresolvedJavaType) {
                UnresolvedJavaType unresolvedJavaType = (UnresolvedJavaType)initializedCallSite;
                this.handleUnresolvedType((JavaType)unresolvedJavaType);
                return;
            }
            if (initializedCallSite instanceof Throwable) {
                return;
            }
            ValueNode initializedCallSiteNode = (ValueNode)initializedCallSite;
            LogicNode isInitializedCallSiteNodeNull = (LogicNode)this.graph.unique((Node)IsNullNode.create((ValueNode)initializedCallSiteNode));
            this.createBytecodeExceptionCheck(bci, isInitializedCallSiteNodeNull, BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, false, new ValueNode[0]);
            ResolvedJavaType callSiteType = this.getMetaAccess().lookupJavaType(CallSite.class);
            LogicNode isInstanceOfCallSite = (LogicNode)this.graph.unique((Node)InstanceOfNode.create((TypeReference)TypeReference.create((Assumptions)this.getAssumptions(), (ResolvedJavaType)callSiteType), (ValueNode)initializedCallSiteNode));
            ConstantNode callSiteClass = ConstantNode.forConstant((Stamp)StampFactory.forKind((JavaKind)JavaKind.Object), (Constant)this.getConstantReflection().asJavaClass(callSiteType), (MetaAccessProvider)this.getMetaAccess(), (StructuredGraph)this.getGraph());
            this.createBytecodeExceptionCheck(bci, isInstanceOfCallSite, BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, true, new ValueNode[]{initializedCallSiteNode, callSiteClass});
            this.bootstrapMethodHandler.invokeMethodAndAppend(bci, CallSite.class, MethodHandle.class, "dynamicInvoker", CallTargetNode.InvokeKind.Virtual, new ValueNode[]{initializedCallSiteNode}, new Class[0]);
            ValueNode methodHandleNode = this.frameState.pop(JavaKind.Object);
            this.bootstrapMethodHandler.invokeMethodAndAppend(bci, MethodHandle.class, MethodType.class, "type", CallTargetNode.InvokeKind.Virtual, new ValueNode[]{methodHandleNode}, new Class[0]);
            ValueNode callSiteMethodTypeNode = this.frameState.pop(JavaKind.Object);
            LogicNode checkMethodTypeEqual = (LogicNode)this.graph.unique((Node)ObjectEqualsNode.create((ValueNode)callSiteMethodTypeNode, (ValueNode)ConstantNode.forConstant((JavaConstant)bootstrap.getType(), (MetaAccessProvider)this.getMetaAccess(), (StructuredGraph)this.getGraph()), (ConstantReflectionProvider)this.getConstantReflection(), (NodeView)NodeView.DEFAULT));
            EndNode checkMethodTypeEqualTrueEnd = (EndNode)this.graph.add((Node)new EndNode());
            EndNode checkMethodTypeEqualFalseEnd = (EndNode)this.graph.add((Node)new EndNode());
            JavaConstant wrongMethodTypeException = this.getSnippetReflection().forObject((Object)new WrongMethodTypeException("CallSite MethodType should be of type " + String.valueOf(methodType)));
            ConstantNode wrongMethodTypeExceptionNode = ConstantNode.forConstant((Stamp)StampFactory.forKind((JavaKind)JavaKind.Object), (Constant)wrongMethodTypeException, (MetaAccessProvider)this.getMetaAccess(), (StructuredGraph)this.getGraph());
            InvokeWithExceptionNode throwWrongMethodTypeNode = this.bootstrapMethodHandler.throwBootstrapMethodError(bci, (ValueNode)wrongMethodTypeExceptionNode);
            throwWrongMethodTypeNode.setNext((FixedNode)checkMethodTypeEqualFalseEnd);
            this.append((Node)new IfNode(checkMethodTypeEqual, (FixedNode)checkMethodTypeEqualTrueEnd, (FixedNode)throwWrongMethodTypeNode, BranchProbabilityNode.NOT_LIKELY_PROFILE));
            MergeNode checkMethodTypeEqualMergeNode = (MergeNode)this.append((Node)new MergeNode());
            checkMethodTypeEqualMergeNode.setStateAfter(this.createFrameState(this.stream.nextBCI(), (StateSplit)checkMethodTypeEqualMergeNode));
            checkMethodTypeEqualMergeNode.addForwardEnd(checkMethodTypeEqualTrueEnd);
            checkMethodTypeEqualMergeNode.addForwardEnd(checkMethodTypeEqualFalseEnd);
            int paramLength = calleeMethod.getSignature().getParameterCount(false);
            ValueNode[] invokeExactArguments = this.popArguments(paramLength);
            NewArrayNode newArrayNode = (NewArrayNode)this.append((Node)new NewArrayNode(this.getMetaAccess().lookupJavaType(Object.class), (ValueNode)ConstantNode.forInt((int)paramLength, (StructuredGraph)this.getGraph()), true));
            for (int i = 0; i < paramLength; ++i) {
                JavaKind stackKind = invokeExactArguments[i].getStackKind();
                if (stackKind.isPrimitive()) {
                    invokeExactArguments[i] = (ValueNode)this.append((Node)BoxNode.create((ValueNode)invokeExactArguments[i], (ResolvedJavaType)this.getMetaAccess().lookupJavaType(stackKind.toBoxedJavaClass()), (JavaKind)stackKind));
                }
                this.append((Node)new StoreIndexedNode((ValueNode)newArrayNode, (ValueNode)ConstantNode.forInt((int)i, (StructuredGraph)this.getGraph()), null, null, JavaKind.Object, invokeExactArguments[i]));
            }
            ValueNode[] invokeArguments = new ValueNode[]{methodHandleNode, newArrayNode};
            TypeDescriptor.OfField returnType = methodType.returnType();
            JavaKind returnKind = this.getMetaAccessExtensionProvider().getStorageKind((JavaType)this.getMetaAccess().lookupJavaType((Class)returnType));
            this.bootstrapMethodHandler.invokeMethodAndAppend(bci, MethodHandle.class, Object.class, "invokeExact", CallTargetNode.InvokeKind.Virtual, invokeArguments, new Class[]{Object.class.arrayType()});
            if (returnKind.equals((Object)JavaKind.Void)) {
                this.frameState.pop(JavaKind.Object);
            } else if (returnKind.isPrimitive()) {
                this.frameState.push(returnKind, (ValueNode)this.append((Node)UnboxNode.create((MetaAccessProvider)this.getMetaAccess(), (ConstantReflectionProvider)this.getConstantReflection(), (ValueNode)this.frameState.pop(JavaKind.Object), (JavaKind)returnKind)));
            }
        }

        private void createBytecodeExceptionCheck(int bci, LogicNode logicNode, BytecodeExceptionNode.BytecodeExceptionKind exception, boolean passingOnTrue, ValueNode ... arguments) {
            AbstractBeginNode passingPath = this.emitBytecodeExceptionCheck(logicNode, passingOnTrue, exception, arguments);
            IfNode bytecodeExceptionIfNode = (IfNode)passingPath.predecessor();
            FixedWithNextNode bytecodeException = (FixedWithNextNode)(passingOnTrue ? bytecodeExceptionIfNode.falseSuccessor() : bytecodeExceptionIfNode.trueSuccessor()).next();
            InvokeWithExceptionNode bootstrapMethodError = this.bootstrapMethodHandler.throwBootstrapMethodError(bci, (ValueNode)bytecodeException);
            FixedNode bytecodeExceptionNext = bytecodeException.next();
            bytecodeException.setNext((FixedNode)bootstrapMethodError);
            bootstrapMethodError.setNext(bytecodeExceptionNext);
        }

        protected void genStoreField(ValueNode receiver, ResolvedJavaField field, ValueNode value) {
            this.hostVM.recordFieldStore(field, this.method);
            super.genStoreField(receiver, field, value);
        }

        protected FrameStateBuilder createFrameStateForExceptionHandling(int bci) {
            FrameStateBuilder dispatchState = super.createFrameStateForExceptionHandling(bci);
            AnalysisMethod aMethod = (AnalysisMethod)this.method;
            if (aMethod.isOriginalMethod() && !SubstrateCompilationDirectives.singleton().isRegisteredForDeoptTesting((ResolvedJavaMethod)aMethod)) {
                BciBlockMapping.BciBlock dispatchBlock = this.getDispatchBlock(bci);
                this.clearNonLiveLocals(dispatchState, dispatchBlock, true);
            }
            return dispatchState;
        }
    }
}

