/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.c.InvokeJavaFunctionPointer;
import com.oracle.svm.core.c.struct.CInterfaceLocationIdentity;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.nodes.CInterfaceReadNode;
import com.oracle.svm.core.graal.nodes.CInterfaceWriteNode;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.CInterfaceError;
import com.oracle.svm.hosted.c.CInterfaceWrapper;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.AccessorInfo;
import com.oracle.svm.hosted.c.info.ConstantInfo;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.PointerToInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import com.oracle.svm.hosted.c.info.StructBitfieldInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.CEntryPointJavaCallStubMethod;
import com.oracle.svm.hosted.code.CFunctionPointerCallStubSupport;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.IndirectCallTargetNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.AndNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.LeftShiftNode;
import jdk.graal.compiler.nodes.calc.MulNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.calc.OrNode;
import jdk.graal.compiler.nodes.calc.RightShiftNode;
import jdk.graal.compiler.nodes.calc.SignExtendNode;
import jdk.graal.compiler.nodes.calc.UnsignedRightShiftNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.extended.JavaReadNode;
import jdk.graal.compiler.nodes.extended.JavaWriteNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordBase;
import org.graalvm.word.impl.WordBoxFactory;

public class CInterfaceInvocationPlugin
implements NodePlugin {
    private final NativeLibraries nativeLibs;
    private final ResolvedJavaType functionPointerType;

    public CInterfaceInvocationPlugin(MetaAccessProvider metaAccess, NativeLibraries nativeLibs) {
        this.nativeLibs = nativeLibs;
        this.functionPointerType = metaAccess.lookupJavaType(CFunctionPointer.class);
    }

    public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod m, ValueNode[] args) {
        AnalysisMethod method = (AnalysisMethod)m;
        ElementInfo methodInfo = this.nativeLibs.findElementInfo((AnnotatedElement)method);
        if (methodInfo instanceof AccessorInfo) {
            ElementInfo parentInfo = methodInfo.getParent();
            if (parentInfo instanceof StructFieldInfo) {
                int offset = ((StructFieldInfo)parentInfo).getOffsetInfo().getProperty();
                if (((AccessorInfo)methodInfo).getAccessorKind() == AccessorInfo.AccessorKind.OFFSET) {
                    return CInterfaceInvocationPlugin.replaceOffsetOf(b, method, args, (AccessorInfo)methodInfo, offset);
                }
                return this.replaceAccessor(b, method, args, (AccessorInfo)methodInfo, offset);
            }
            if (parentInfo instanceof StructBitfieldInfo) {
                return this.replaceBitfieldAccessor(b, method, args, (StructBitfieldInfo)parentInfo, (AccessorInfo)methodInfo);
            }
            if (parentInfo instanceof StructInfo || parentInfo instanceof PointerToInfo) {
                return this.replaceAccessor(b, method, args, (AccessorInfo)methodInfo, 0);
            }
            throw VMError.shouldNotReachHereUnexpectedInput(parentInfo);
        }
        if (methodInfo instanceof ConstantInfo) {
            return this.replaceConstant(b, method, (ConstantInfo)methodInfo);
        }
        if (method.getAnnotation(InvokeCFunctionPointer.class) != null) {
            return this.replaceCFunctionPointerInvoke(b, method, args);
        }
        if (method.getAnnotation(InvokeJavaFunctionPointer.class) != null) {
            return this.replaceJavaFunctionPointerInvoke(b, method, args);
        }
        if (method.getAnnotation(CEntryPoint.class) != null) {
            assert (!(method.getWrapped() instanceof CEntryPointJavaCallStubMethod)) : "Call stub should never have a @CEntryPoint annotation";
            AnalysisMethod stub = CEntryPointCallStubSupport.singleton().registerJavaStubForMethod(method);
            assert (!b.getMethod().equals((Object)stub)) : "Plugin should not be called for the invoke in the stub itself";
            b.handleReplacedInvoke(CallTargetNode.InvokeKind.Static, (ResolvedJavaMethod)stub, args, false);
            return true;
        }
        return false;
    }

    private static boolean replaceOffsetOf(GraphBuilderContext b, AnalysisMethod method, ValueNode[] args, AccessorInfo accessorInfo, int displacement) {
        assert (args.length == accessorInfo.parameterCount(!method.isStatic()));
        JavaKind kind = b.getWordTypes().asKind(b.getInvokeReturnType());
        b.addPush(CInterfaceInvocationPlugin.pushKind(method), (ValueNode)ConstantNode.forIntegerKind((JavaKind)kind, (long)displacement, (StructuredGraph)b.getGraph()));
        return true;
    }

    private boolean replaceAccessor(GraphBuilderContext b, AnalysisMethod method, ValueNode[] args, AccessorInfo accessorInfo, int displacement) {
        assert (args.length == accessorInfo.parameterCount(true));
        SizableInfo typeInC = (SizableInfo)accessorInfo.getParent();
        ValueNode base = args[AccessorInfo.baseParameterNumber(true)];
        assert (base.getStackKind() == ConfigurationValues.getWordKind());
        switch (accessorInfo.getAccessorKind()) {
            case ADDRESS: {
                CInterfaceInvocationPlugin.replaceWithAddress(b, method, base, args, accessorInfo, displacement, typeInC);
                break;
            }
            case GETTER: {
                this.replaceWithRead(b, method, base, args, accessorInfo, displacement, typeInC);
                break;
            }
            case SETTER: {
                CInterfaceInvocationPlugin.replaceWithWrite(b, method, base, args, accessorInfo, displacement, typeInC);
                break;
            }
            default: {
                throw VMError.shouldNotReachHereUnexpectedInput((Object)accessorInfo.getAccessorKind());
            }
        }
        return true;
    }

    private static void replaceWithAddress(GraphBuilderContext b, AnalysisMethod method, ValueNode base, ValueNode[] args, AccessorInfo accessorInfo, int displacement, SizableInfo typeInC) {
        StructuredGraph graph = b.getGraph();
        ValueNode address = (ValueNode)graph.addOrUniqueWithInputs((Node)new AddNode(base, CInterfaceInvocationPlugin.makeOffset(graph, args, accessorInfo, displacement, typeInC.getSizeInBytes())));
        b.addPush(CInterfaceInvocationPlugin.pushKind(method), address);
    }

    private void replaceWithRead(GraphBuilderContext b, AnalysisMethod method, ValueNode base, ValueNode[] args, AccessorInfo accessorInfo, int displacement, SizableInfo typeInC) {
        ValueNode node;
        StructuredGraph graph = b.getGraph();
        OffsetAddressNode offsetAddress = CInterfaceInvocationPlugin.makeOffsetAddress(graph, args, accessorInfo, base, displacement, typeInC.getSizeInBytes());
        LocationIdentity locationIdentity = CInterfaceInvocationPlugin.makeLocationIdentity(b, method, args, accessorInfo);
        JavaKind returnKind = b.getWordTypes().asKind(b.getInvokeReturnType());
        if (returnKind == JavaKind.Object) {
            Stamp stamp = b.getInvokeReturnStamp(null).getTrustedStamp();
            node = (ValueNode)b.add((Node)new JavaReadNode(stamp, returnKind, (AddressNode)offsetAddress, locationIdentity, BarrierType.NONE, MemoryOrderMode.PLAIN, true));
        } else if (returnKind == JavaKind.Float || returnKind == JavaKind.Double) {
            Stamp stamp = StampFactory.forKind((JavaKind)returnKind);
            node = CInterfaceInvocationPlugin.readPrimitive(b, offsetAddress, locationIdentity, stamp, accessorInfo, method);
        } else {
            IntegerStamp stamp = IntegerStamp.create((int)(typeInC.getSizeInBytes() * 8));
            ValueNode read = CInterfaceInvocationPlugin.readPrimitive(b, offsetAddress, locationIdentity, (Stamp)stamp, accessorInfo, method);
            node = this.convertCIntegerToMethodReturnType(graph, method, read, typeInC.isUnsigned());
        }
        b.push(CInterfaceInvocationPlugin.pushKind(method), node);
    }

    private static void replaceWithWrite(GraphBuilderContext b, AnalysisMethod method, ValueNode base, ValueNode[] args, AccessorInfo accessorInfo, int displacement, SizableInfo typeInC) {
        StructuredGraph graph = b.getGraph();
        OffsetAddressNode offsetAddress = CInterfaceInvocationPlugin.makeOffsetAddress(graph, args, accessorInfo, base, displacement, typeInC.getSizeInBytes());
        LocationIdentity locationIdentity = CInterfaceInvocationPlugin.makeLocationIdentity(b, method, args, accessorInfo);
        ValueNode value = args[accessorInfo.valueParameterNumber(true)];
        JavaKind valueKind = value.getStackKind();
        if (valueKind == JavaKind.Object) {
            b.add((Node)new JavaWriteNode(valueKind, (AddressNode)offsetAddress, locationIdentity, value, BarrierType.NONE, true));
        } else if (valueKind == JavaKind.Float || valueKind == JavaKind.Double) {
            CInterfaceInvocationPlugin.writePrimitive(b, offsetAddress, locationIdentity, value, accessorInfo, method);
        } else {
            ValueNode adaptedValue = CInterfaceInvocationPlugin.adaptPrimitiveTypeForWrite(graph, value, typeInC.getSizeInBytes() * 8, typeInC.isUnsigned());
            CInterfaceInvocationPlugin.writePrimitive(b, offsetAddress, locationIdentity, adaptedValue, accessorInfo, method);
        }
    }

    private static ValueNode adaptPrimitiveTypeForWrite(StructuredGraph graph, ValueNode value, int toBits, boolean isCValueUnsigned) {
        JavaKind valueKind = value.getStackKind();
        int valueBits = valueKind.getBitCount();
        if (valueBits == toBits) {
            return value;
        }
        if (valueBits > toBits) {
            return (ValueNode)graph.unique((Node)new NarrowNode(value, toBits));
        }
        if (isCValueUnsigned) {
            return (ValueNode)graph.unique((Node)new ZeroExtendNode(value, toBits));
        }
        return (ValueNode)graph.unique((Node)new SignExtendNode(value, toBits));
    }

    private boolean replaceBitfieldAccessor(GraphBuilderContext b, AnalysisMethod method, ValueNode[] args, StructBitfieldInfo bitfieldInfo, AccessorInfo accessorInfo) {
        int byteOffset = bitfieldInfo.getByteOffsetInfo().getProperty();
        int startBit = bitfieldInfo.getStartBitInfo().getProperty();
        int endBit = bitfieldInfo.getEndBitInfo().getProperty();
        boolean isCValueUnsigned = bitfieldInfo.isUnsigned();
        assert (byteOffset >= 0 && byteOffset < ((SizableInfo)bitfieldInfo.getParent()).getSizeInBytes());
        assert (startBit >= 0 && startBit < 8);
        assert (endBit >= startBit && endBit < 64);
        JavaKind readKind = endBit < 8 ? JavaKind.Byte : (endBit < 16 ? JavaKind.Short : (endBit < 32 ? JavaKind.Int : JavaKind.Long));
        int readBytes = readKind.getByteCount();
        int alignmentCorrection = byteOffset % readBytes;
        if (alignmentCorrection > 0 && endBit + alignmentCorrection * 8 < readKind.getBitCount()) {
            byteOffset -= alignmentCorrection;
            startBit += alignmentCorrection * 8;
            endBit += alignmentCorrection * 8;
        }
        assert (byteOffset >= 0 && byteOffset < ((SizableInfo)bitfieldInfo.getParent()).getSizeInBytes());
        assert (startBit >= 0 && startBit < readKind.getBitCount());
        assert (endBit >= startBit && endBit < readKind.getBitCount());
        assert (args.length == accessorInfo.parameterCount(true));
        ValueNode base = args[AccessorInfo.baseParameterNumber(true)];
        StructuredGraph graph = b.getGraph();
        OffsetAddressNode address = CInterfaceInvocationPlugin.makeOffsetAddress(graph, args, accessorInfo, base, byteOffset, -1);
        LocationIdentity locationIdentity = CInterfaceInvocationPlugin.makeLocationIdentity(b, method, args, accessorInfo);
        IntegerStamp stamp = IntegerStamp.create((int)readKind.getBitCount());
        ValueNode cValue = CInterfaceInvocationPlugin.readPrimitive(b, address, locationIdentity, (Stamp)stamp, accessorInfo, method);
        JavaKind computeKind = readKind.getStackKind();
        int computeBits = computeKind.getBitCount();
        assert (startBit >= 0 && startBit < computeBits);
        assert (endBit >= startBit && endBit < computeBits);
        int accessedBits = endBit - startBit + 1;
        assert (accessedBits > 0 && accessedBits <= readKind.getBitCount() && accessedBits <= 64);
        assert (computeBits >= accessedBits);
        if (readKind.getBitCount() < 32) {
            cValue = (ValueNode)graph.unique((Node)new ZeroExtendNode(cValue, computeBits));
        }
        switch (accessorInfo.getAccessorKind()) {
            case GETTER: {
                cValue = (ValueNode)graph.unique((Node)new LeftShiftNode(cValue, (ValueNode)ConstantNode.forInt((int)(computeBits - endBit - 1), (StructuredGraph)graph)));
                cValue = isCValueUnsigned ? (ValueNode)graph.unique((Node)new UnsignedRightShiftNode(cValue, (ValueNode)ConstantNode.forInt((int)(computeBits - accessedBits), (StructuredGraph)graph))) : (ValueNode)graph.unique((Node)new RightShiftNode(cValue, (ValueNode)ConstantNode.forInt((int)(computeBits - accessedBits), (StructuredGraph)graph)));
                int targetBits = 1 << CodeUtil.log2((int)accessedBits);
                if (targetBits < accessedBits) {
                    targetBits *= 2;
                }
                if (targetBits < 8) {
                    targetBits = 8;
                }
                if (computeBits > targetBits) {
                    cValue = (ValueNode)graph.unique((Node)new NarrowNode(cValue, targetBits));
                }
                ValueNode result = this.convertCIntegerToMethodReturnType(graph, method, cValue, isCValueUnsigned);
                b.push(CInterfaceInvocationPlugin.pushKind(method), result);
                return true;
            }
            case SETTER: {
                ValueNode newValue = args[accessorInfo.valueParameterNumber(true)];
                newValue = CInterfaceInvocationPlugin.adaptPrimitiveTypeForWrite(graph, newValue, computeBits, isCValueUnsigned);
                if (accessedBits == 64) {
                    assert (startBit == 0);
                    cValue = newValue;
                } else {
                    newValue = (ValueNode)graph.unique((Node)new LeftShiftNode(newValue, (ValueNode)ConstantNode.forInt((int)(computeBits - accessedBits), (StructuredGraph)graph)));
                    newValue = (ValueNode)graph.unique((Node)new UnsignedRightShiftNode(newValue, (ValueNode)ConstantNode.forInt((int)(computeBits - accessedBits - startBit), (StructuredGraph)graph)));
                    long mask = (1L << accessedBits) - 1L << startBit ^ 0xFFFFFFFFFFFFFFFFL;
                    cValue = (ValueNode)graph.unique((Node)new AndNode(cValue, (ValueNode)ConstantNode.forIntegerBits((int)computeBits, (long)mask, (StructuredGraph)graph)));
                    cValue = (ValueNode)graph.unique((Node)new OrNode(cValue, newValue));
                }
                cValue = CInterfaceInvocationPlugin.adaptPrimitiveTypeForWrite(graph, cValue, readKind.getBitCount(), isCValueUnsigned);
                CInterfaceInvocationPlugin.writePrimitive(b, address, locationIdentity, cValue, accessorInfo, method);
                return true;
            }
        }
        throw VMError.shouldNotReachHereUnexpectedInput((Object)accessorInfo.getAccessorKind());
    }

    private static ValueNode readPrimitive(GraphBuilderContext b, OffsetAddressNode address, LocationIdentity locationIdentity, Stamp stamp, AccessorInfo accessorInfo, AnalysisMethod method) {
        ValueNode replaced;
        if (ImageSingletons.contains(CInterfaceWrapper.class) && (replaced = ((CInterfaceWrapper)ImageSingletons.lookup(CInterfaceWrapper.class)).replacePrimitiveRead(b, address, stamp, (ResolvedJavaMethod)method)) != null) {
            return replaced;
        }
        CInterfaceReadNode read = (CInterfaceReadNode)b.add((Node)new CInterfaceReadNode((AddressNode)address, locationIdentity, stamp, BarrierType.NONE, MemoryOrderMode.PLAIN, CInterfaceInvocationPlugin.accessName(accessorInfo)));
        read.setForceFixed(true);
        return read;
    }

    private static void writePrimitive(GraphBuilderContext b, OffsetAddressNode address, LocationIdentity locationIdentity, ValueNode value, AccessorInfo accessorInfo, AnalysisMethod method) {
        boolean replaced;
        if (ImageSingletons.contains(CInterfaceWrapper.class) && (replaced = ((CInterfaceWrapper)ImageSingletons.lookup(CInterfaceWrapper.class)).replacePrimitiveWrite(b, address, value, (ResolvedJavaMethod)method))) {
            return;
        }
        b.add((Node)new CInterfaceWriteNode((AddressNode)address, locationIdentity, value, BarrierType.NONE, MemoryOrderMode.PLAIN, CInterfaceInvocationPlugin.accessName(accessorInfo)));
    }

    private static String accessName(AccessorInfo accessorInfo) {
        if (accessorInfo.getParent() instanceof StructFieldInfo) {
            return accessorInfo.getParent().getParent().getName() + "." + accessorInfo.getParent().getName();
        }
        return accessorInfo.getParent().getName() + "*";
    }

    private static ValueNode makeOffset(StructuredGraph graph, ValueNode[] args, AccessorInfo accessorInfo, int displacement, int indexScaling) {
        ConstantNode offset = ConstantNode.forIntegerKind((JavaKind)ConfigurationValues.getWordKind(), (long)displacement, (StructuredGraph)graph);
        if (accessorInfo.isIndexed()) {
            ValueNode index = args[accessorInfo.indexParameterNumber(true)];
            assert (index.getStackKind().isPrimitive());
            ValueNode wordIndex = CInterfaceInvocationPlugin.extend(graph, index, ConfigurationValues.getWordKind().getBitCount(), false);
            ValueNode scaledIndex = (ValueNode)graph.unique((Node)new MulNode(wordIndex, (ValueNode)ConstantNode.forIntegerKind((JavaKind)ConfigurationValues.getWordKind(), (long)indexScaling, (StructuredGraph)graph)));
            offset = (ValueNode)graph.unique((Node)new AddNode(scaledIndex, (ValueNode)offset));
        }
        return offset;
    }

    private static OffsetAddressNode makeOffsetAddress(StructuredGraph graph, ValueNode[] args, AccessorInfo accessorInfo, ValueNode base, int displacement, int indexScaling) {
        return (OffsetAddressNode)graph.addOrUniqueWithInputs((Node)new OffsetAddressNode(base, CInterfaceInvocationPlugin.makeOffset(graph, args, accessorInfo, displacement, indexScaling)));
    }

    private static LocationIdentity makeLocationIdentity(GraphBuilderContext b, AnalysisMethod method, ValueNode[] args, AccessorInfo accessorInfo) {
        LocationIdentity locationIdentity;
        if (accessorInfo.hasLocationIdentityParameter()) {
            ValueNode locationIdentityNode = args[accessorInfo.locationIdentityParameterNumber(true)];
            if (!locationIdentityNode.isConstant()) {
                throw UserError.abort(new CInterfaceError("locationIdentity is not a compile time constant for call to " + method.format("%H.%n(%p)") + " in " + String.valueOf(b.getMethod().asStackTraceElement(b.bci())), method).getMessage(), new Object[0]);
            }
            locationIdentity = (LocationIdentity)b.getSnippetReflection().asObject(LocationIdentity.class, locationIdentityNode.asJavaConstant());
        } else if (accessorInfo.hasUniqueLocationIdentity()) {
            StructFieldInfo fieldInfo = (StructFieldInfo)accessorInfo.getParent();
            assert (fieldInfo.getLocationIdentity() != null);
            locationIdentity = fieldInfo.getLocationIdentity();
        } else {
            locationIdentity = CInterfaceLocationIdentity.DEFAULT_LOCATION_IDENTITY;
        }
        return locationIdentity;
    }

    private ValueNode convertCIntegerToMethodReturnType(StructuredGraph graph, AnalysisMethod method, ValueNode cValue, boolean isCValueUnsigned) {
        return CInterfaceInvocationPlugin.convertCIntegerToMethodReturnType(graph, this.nativeLibs, method.getSignature().getReturnType(), cValue, isCValueUnsigned);
    }

    public static ValueNode convertCIntegerToMethodReturnType(StructuredGraph graph, NativeLibraries nativeLibs, ResolvedJavaType declaredReturnType, ValueNode cValue, boolean isCValueUnsigned) {
        IntegerStamp cValueStamp = (IntegerStamp)cValue.stamp(NodeView.DEFAULT);
        int bitsInC = cValueStamp.getBits();
        JavaKind declaredReturnKind = nativeLibs.getWordTypes().asKind((JavaType)declaredReturnType);
        if (declaredReturnKind == JavaKind.Boolean) {
            ValueNode comparisonValue = cValue;
            int comparisonBits = bitsInC;
            if (bitsInC < 32) {
                comparisonValue = (ValueNode)graph.unique((Node)new ZeroExtendNode(cValue, 32));
                comparisonBits = 32;
            }
            LogicNode comparison = (LogicNode)graph.unique((Node)new IntegerEqualsNode(comparisonValue, (ValueNode)ConstantNode.forIntegerBits((int)comparisonBits, (long)0L, (StructuredGraph)graph)));
            return (ValueNode)graph.unique((Node)new ConditionalNode(comparison, (ValueNode)ConstantNode.forBoolean((boolean)false, (StructuredGraph)graph), (ValueNode)ConstantNode.forBoolean((boolean)true, (StructuredGraph)graph)));
        }
        ValueNode result = cValue;
        int resultBits = bitsInC;
        if (bitsInC > declaredReturnKind.getBitCount()) {
            result = (ValueNode)graph.unique((Node)new NarrowNode(result, declaredReturnKind.getBitCount()));
            resultBits = declaredReturnKind.getBitCount();
        }
        int actualReturnTypeBitCount = declaredReturnKind.getStackKind().getBitCount();
        assert (actualReturnTypeBitCount >= resultBits);
        boolean zeroExtend = CInterfaceInvocationPlugin.shouldZeroExtend(nativeLibs, declaredReturnType, isCValueUnsigned, bitsInC);
        return CInterfaceInvocationPlugin.extend(graph, result, actualReturnTypeBitCount, zeroExtend);
    }

    private static boolean shouldZeroExtend(NativeLibraries nativeLibs, ResolvedJavaType declaredReturnType, boolean isCValueUnsigned, int bitsInC) {
        JavaKind declaredReturnKind = nativeLibs.getWordTypes().asKind((JavaType)declaredReturnType);
        boolean isDeclaredReturnTypeSigned = nativeLibs.isSigned(declaredReturnType);
        return !isDeclaredReturnTypeSigned || isCValueUnsigned && bitsInC < declaredReturnKind.getBitCount();
    }

    private ValueNode convertCIntegerToMethodReturnType(StructuredGraph graph, AnalysisMethod method, long cValue, int bitsInC, boolean isCValueUnsigned) {
        return CInterfaceInvocationPlugin.convertCIntegerToMethodReturnType(graph, this.nativeLibs, method.getSignature().getReturnType(), cValue, bitsInC, isCValueUnsigned);
    }

    public static ValueNode convertCIntegerToMethodReturnType(StructuredGraph graph, NativeLibraries nativeLibs, ResolvedJavaType declaredReturnType, long cValue, int bitsInC, boolean isCValueUnsigned) {
        JavaKind declaredReturnKind = nativeLibs.getWordTypes().asKind((JavaType)declaredReturnType);
        if (declaredReturnKind == JavaKind.Boolean) {
            return ConstantNode.forBoolean((cValue != 0L ? 1 : 0) != 0, (StructuredGraph)graph);
        }
        long result = CInterfaceInvocationPlugin.convertCIntegerToMethodReturnType(nativeLibs, declaredReturnType, cValue, bitsInC, isCValueUnsigned);
        int resultBits = declaredReturnKind.getStackKind().getBitCount();
        boolean zeroExtend = CInterfaceInvocationPlugin.shouldZeroExtend(nativeLibs, declaredReturnType, isCValueUnsigned, bitsInC);
        if (zeroExtend) {
            IntegerStamp stamp = StampFactory.forUnsignedInteger((int)resultBits, (long)result, (long)result);
            return ConstantNode.forIntegerStamp((Stamp)stamp, (long)result, (StructuredGraph)graph);
        }
        return ConstantNode.forIntegerBits((int)resultBits, (long)result, (StructuredGraph)graph);
    }

    public static Object convertCIntegerToMethodReturnType(NativeLibraries nativeLibs, Class<?> objectReturnType, long cValue, int bitsInC, boolean isCValueUnsigned) {
        ResolvedJavaType declaredReturnType = nativeLibs.getMetaAccess().lookupJavaType(CInterfaceInvocationPlugin.getPrimitiveOrWordClass(nativeLibs, objectReturnType));
        return CInterfaceInvocationPlugin.createReturnObject(objectReturnType, CInterfaceInvocationPlugin.convertCIntegerToMethodReturnType(nativeLibs, declaredReturnType, cValue, bitsInC, isCValueUnsigned));
    }

    private static long convertCIntegerToMethodReturnType(NativeLibraries nativeLibs, ResolvedJavaType declaredReturnType, long cValue, int bitsInC, boolean isCValueUnsigned) {
        JavaKind declaredReturnKind = nativeLibs.getWordTypes().asKind((JavaType)declaredReturnType);
        if (declaredReturnKind == JavaKind.Boolean) {
            return cValue != 0L ? 1L : 0L;
        }
        boolean zeroExtend = CInterfaceInvocationPlugin.shouldZeroExtend(nativeLibs, declaredReturnType, isCValueUnsigned, bitsInC);
        int inputBits = Math.min(bitsInC, declaredReturnKind.getBitCount());
        if (zeroExtend) {
            return CodeUtil.zeroExtend((long)cValue, (int)inputBits);
        }
        return CodeUtil.signExtend((long)cValue, (int)inputBits);
    }

    private static Class<?> getPrimitiveOrWordClass(NativeLibraries nativeLibs, Class<?> type) {
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        if (type == Character.class) {
            return Character.TYPE;
        }
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        if (nativeLibs.getWordTypes().isWord(type)) {
            return type;
        }
        throw VMError.shouldNotReachHere("Unexpected type: " + String.valueOf(type));
    }

    private static Object createReturnObject(Class<?> returnType, long value) {
        if (returnType == Boolean.class) {
            return value != 0L;
        }
        if (returnType == Byte.class) {
            return (byte)value;
        }
        if (returnType == Short.class) {
            return (short)value;
        }
        if (returnType == Character.class) {
            return Character.valueOf((char)value);
        }
        if (returnType == Integer.class) {
            return (int)value;
        }
        if (returnType == Long.class) {
            return value;
        }
        if (WordBase.class.isAssignableFrom(returnType)) {
            return WordBoxFactory.box((long)value);
        }
        throw VMError.shouldNotReachHere("Unexpected returnType: " + returnType.getName());
    }

    private static ValueNode extend(StructuredGraph graph, ValueNode value, int resultBits, boolean zeroExtend) {
        if (zeroExtend) {
            return (ValueNode)graph.unique((Node)new ZeroExtendNode(value, resultBits));
        }
        return (ValueNode)graph.unique((Node)new SignExtendNode(value, resultBits));
    }

    private boolean replaceConstant(GraphBuilderContext b, AnalysisMethod method, ConstantInfo constantInfo) {
        Object value = constantInfo.getValue();
        JavaKind declaredReturnKind = b.getWordTypes().asKind(b.getInvokeReturnType());
        StructuredGraph graph = b.getGraph();
        ConstantNode valueNode = switch (constantInfo.getKind()) {
            case SizableInfo.ElementKind.INTEGER, SizableInfo.ElementKind.POINTER -> this.convertCIntegerToMethodReturnType(graph, method, (Long)value, constantInfo.getSizeInBytes() * 8, constantInfo.isUnsigned());
            case SizableInfo.ElementKind.FLOAT -> ConstantNode.forFloatingKind((JavaKind)declaredReturnKind, (double)((Double)value), (StructuredGraph)graph);
            case SizableInfo.ElementKind.STRING, SizableInfo.ElementKind.BYTEARRAY -> ConstantNode.forConstant((JavaConstant)b.getSnippetReflection().forObject(value), (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)graph);
            default -> throw VMError.shouldNotReachHere("Unexpected constant kind " + String.valueOf(constantInfo));
        };
        b.push(CInterfaceInvocationPlugin.pushKind(method), (ValueNode)valueNode);
        return true;
    }

    private boolean replaceCFunctionPointerInvoke(GraphBuilderContext b, AnalysisMethod method, ValueNode[] args) {
        if (CFunctionPointerCallStubSupport.singleton().isStub(method)) {
            return false;
        }
        if (!this.functionPointerType.isAssignableFrom((ResolvedJavaType)method.getDeclaringClass())) {
            throw UserError.abort(new CInterfaceError("Function pointer invocation method " + method.format("%H.%n(%p)") + " must be in a type that extends " + CFunctionPointer.class.getSimpleName(), method).getMessage(), new Object[0]);
        }
        assert (b.getInvokeKind() == CallTargetNode.InvokeKind.Interface);
        AnalysisMethod stub = CFunctionPointerCallStubSupport.singleton().getOrCreateStubForMethod(method);
        b.handleReplacedInvoke(CallTargetNode.InvokeKind.Static, (ResolvedJavaMethod)stub, args, false);
        return true;
    }

    private boolean replaceJavaFunctionPointerInvoke(GraphBuilderContext b, AnalysisMethod method, ValueNode[] args) {
        if (!this.functionPointerType.isAssignableFrom((ResolvedJavaType)method.getDeclaringClass())) {
            throw UserError.abort(new CInterfaceError("Function pointer invocation method " + method.format("%H.%n(%p)") + " must be in a type that extends " + CFunctionPointer.class.getSimpleName(), method).getMessage(), new Object[0]);
        }
        assert (b.getInvokeKind() == CallTargetNode.InvokeKind.Interface);
        JavaType[] parameterTypes = method.getSignature().toParameterTypes(null);
        assert (args.length >= 1);
        ValueNode methodAddress = args[0];
        ValueNode[] argsWithoutReceiver = Arrays.copyOfRange(args, 1, args.length);
        assert (argsWithoutReceiver.length == parameterTypes.length);
        Stamp returnStamp = b.getWordTypes().isWord(b.getInvokeReturnType()) ? b.getWordTypes().getWordStamp((ResolvedJavaType)((AnalysisType)b.getInvokeReturnType())) : b.getInvokeReturnStamp(null).getTrustedStamp();
        CallTargetNode indirectCallTargetNode = (CallTargetNode)b.add((Node)new IndirectCallTargetNode(methodAddress, argsWithoutReceiver, StampPair.createSingle((Stamp)returnStamp), parameterTypes, null, (CallingConvention.Type)SubstrateCallingConventionKind.Java.toType(true), CallTargetNode.InvokeKind.Static));
        b.handleReplacedInvoke(indirectCallTargetNode, b.getInvokeReturnType().getJavaKind());
        return true;
    }

    public static JavaKind pushKind(AnalysisMethod method) {
        return method.getSignature().getReturnKind().getStackKind();
    }
}

