/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ReflectionConfigurationParser;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.ClassForNameSupportFeature;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.reflect.ReflectionAccessorHolder;
import com.oracle.svm.core.reflect.SubstrateAccessor;
import com.oracle.svm.core.reflect.SubstrateConstructorAccessor;
import com.oracle.svm.core.reflect.SubstrateMethodAccessor;
import com.oracle.svm.core.reflect.target.ReflectionSubstitutionSupport;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.annotation.SubstrateAnnotationExtractor;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.code.FactoryMethodSupport;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.reflect.ComputeInterfaceTypeID;
import com.oracle.svm.hosted.reflect.ComputeVTableOffset;
import com.oracle.svm.hosted.reflect.NativeImageConditionResolver;
import com.oracle.svm.hosted.reflect.ReflectionDataBuilder;
import com.oracle.svm.hosted.reflect.ReflectionExpandSignatureMethod;
import com.oracle.svm.hosted.reflect.ReflectionHostedSupport;
import com.oracle.svm.hosted.reflect.SignatureKey;
import com.oracle.svm.hosted.reflect.proxy.DynamicProxyFeature;
import com.oracle.svm.hosted.reflect.proxy.ProxyRegistry;
import com.oracle.svm.hosted.snippets.ReflectionPlugins;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.AnnotationExtractor;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.ReflectionRegistry;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

@AutomaticallyRegisteredFeature
public class ReflectionFeature
implements InternalFeature,
ReflectionSubstitutionSupport {
    private static final Method findCallerSensitiveAdapterMethod = ReflectionUtil.lookupMethod((Class)ReflectionUtil.lookupClass((boolean)false, (String)"jdk.internal.reflect.DirectMethodHandleAccessor"), (String)"findCSMethodAdapter", (Class[])new Class[]{Method.class});
    private static final List<Class<?>> PRIMITIVE_CLASSES = List.of(Void.TYPE, Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
    private AnnotationSubstitutionProcessor annotationSubstitutions;
    private ReflectionDataBuilder reflectionData;
    private ImageClassLoader loader;
    private AnalysisUniverse aUniverse;
    private int loadedConfigurations;
    private UniverseMetaAccess metaAccess;
    final Map<Executable, SubstrateAccessor> accessors = new ConcurrentHashMap<Executable, SubstrateAccessor>();
    private final Map<SignatureKey, MethodPointer> expandSignatureMethods = new ConcurrentHashMap<SignatureKey, MethodPointer>();
    private static final Method invokePrototype = ReflectionUtil.lookupMethod(ReflectionAccessorHolder.class, (String)"invokePrototype", (Class[])new Class[]{Object.class, Object[].class, CFunctionPointer.class});
    private static final Method invokePrototypeForCallerSensitiveAdapter = ReflectionUtil.lookupMethod(ReflectionAccessorHolder.class, (String)"invokePrototypeForCallerSensitiveAdapter", (Class[])new Class[]{Object.class, Object[].class, CFunctionPointer.class, Class.class});
    private static final Method methodHandleInvokeErrorMethod = ReflectionUtil.lookupMethod(ReflectionAccessorHolder.class, (String)"methodHandleInvokeError", (Class[])new Class[]{Object.class, Object[].class, CFunctionPointer.class});
    private static final Method newInstanceErrorMethod = ReflectionUtil.lookupMethod(ReflectionAccessorHolder.class, (String)"newInstanceError", (Class[])new Class[]{Object.class, Object[].class, CFunctionPointer.class});
    FeatureImpl.BeforeAnalysisAccessImpl analysisAccess;

    @Override
    public SubstrateAccessor getOrCreateAccessor(Executable member) {
        SubstrateAccessor existing = this.accessors.get(member);
        if (existing != null) {
            return existing;
        }
        if (this.analysisAccess == null) {
            throw VMError.shouldNotReachHere("New Method or Constructor found as reachable after static analysis: " + String.valueOf(member));
        }
        return this.accessors.computeIfAbsent(member, this::createAccessor);
    }

    private SubstrateAccessor createAccessor(Executable member) {
        MethodPointer expandSignature;
        MethodPointer directTarget = null;
        AnalysisMethod targetMethod = null;
        DynamicHub initializeBeforeInvoke = null;
        if (member instanceof Method) {
            MethodPointer expandSignature2;
            int vtableOffset = -1;
            Class<?> receiverType = null;
            boolean callerSensitiveAdapter = false;
            if (member.getDeclaringClass() == MethodHandle.class && (member.getName().equals("invoke") || member.getName().equals("invokeExact"))) {
                expandSignature2 = this.asMethodPointer((ResolvedJavaMethod)this.analysisAccess.getMetaAccess().lookupJavaMethod((Executable)methodHandleInvokeErrorMethod));
            } else {
                Method target = (Method)member;
                try {
                    Method adapter = (Method)findCallerSensitiveAdapterMethod.invoke(null, member);
                    if (adapter != null) {
                        target = adapter;
                        callerSensitiveAdapter = true;
                    }
                }
                catch (ReflectiveOperationException ex) {
                    throw VMError.shouldNotReachHere(ex);
                }
                expandSignature2 = this.createExpandSignatureMethod(target, callerSensitiveAdapter);
                targetMethod = this.analysisAccess.getMetaAccess().lookupJavaMethod((Executable)target);
                if (!targetMethod.isAbstract()) {
                    directTarget = this.asMethodPointer((ResolvedJavaMethod)targetMethod);
                }
                if (!targetMethod.canBeStaticallyBound()) {
                    vtableOffset = -559087615;
                }
                VMError.guarantee(directTarget != null || vtableOffset != -1, "Must have either a directTarget or a vtableOffset");
                if (!targetMethod.isStatic()) {
                    receiverType = target.getDeclaringClass();
                }
                if (targetMethod.isStatic() && !targetMethod.getDeclaringClass().isInitialized()) {
                    initializeBeforeInvoke = this.analysisAccess.getHostVM().dynamicHub((ResolvedJavaType)targetMethod.getDeclaringClass());
                }
            }
            return new SubstrateMethodAccessor(member, receiverType, expandSignature2, directTarget, (ResolvedJavaMethod)targetMethod, vtableOffset, initializeBeforeInvoke, callerSensitiveAdapter);
        }
        Class<?> holder = member.getDeclaringClass();
        MethodPointer factoryMethodTarget = null;
        AnalysisMethod factoryMethod = null;
        if (Modifier.isAbstract(holder.getModifiers()) || holder.isInterface() || holder.isPrimitive() || holder.isArray()) {
            expandSignature = this.asMethodPointer((ResolvedJavaMethod)this.analysisAccess.getMetaAccess().lookupJavaMethod((Executable)newInstanceErrorMethod));
        } else {
            expandSignature = this.createExpandSignatureMethod(member, false);
            targetMethod = this.analysisAccess.getMetaAccess().lookupJavaMethod(member);
            directTarget = this.asMethodPointer((ResolvedJavaMethod)targetMethod);
            factoryMethod = FactoryMethodSupport.singleton().lookup(this.analysisAccess.getMetaAccess(), targetMethod, false);
            factoryMethodTarget = this.asMethodPointer((ResolvedJavaMethod)factoryMethod);
            if (!targetMethod.getDeclaringClass().isInitialized()) {
                initializeBeforeInvoke = this.analysisAccess.getHostVM().dynamicHub((ResolvedJavaType)targetMethod.getDeclaringClass());
            }
        }
        return new SubstrateConstructorAccessor(member, expandSignature, directTarget, (ResolvedJavaMethod)targetMethod, factoryMethodTarget, (ResolvedJavaMethod)factoryMethod, initializeBeforeInvoke);
    }

    private MethodPointer createExpandSignatureMethod(Executable member, boolean callerSensitiveAdapter) {
        return this.expandSignatureMethods.computeIfAbsent(new SignatureKey(member, callerSensitiveAdapter), signatureKey -> {
            ResolvedJavaMethod prototype = this.analysisAccess.getMetaAccess().lookupJavaMethod((Executable)(callerSensitiveAdapter ? invokePrototypeForCallerSensitiveAdapter : invokePrototype)).getWrapped();
            return this.asMethodPointer(new ReflectionExpandSignatureMethod("invoke_" + signatureKey.uniqueShortName(), prototype, signatureKey.isStatic, signatureKey.argTypes, signatureKey.returnKind, signatureKey.callerSensitiveAdapter));
        });
    }

    private MethodPointer asMethodPointer(ResolvedJavaMethod method) {
        AnalysisMethod aMethod = method instanceof AnalysisMethod ? (AnalysisMethod)method : this.analysisAccess.getUniverse().lookup((JavaMethod)method);
        return new MethodPointer((ResolvedJavaMethod)aMethod);
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(ClassForNameSupportFeature.class, DynamicProxyFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ModuleSupport.accessPackagesToClass((ModuleSupport.Access)ModuleSupport.Access.OPEN, null, (boolean)false, (String)"java.base", (String[])new String[]{"jdk.internal.reflect"});
        ImageSingletons.add(ReflectionSubstitutionSupport.class, (Object)this);
        this.reflectionData = new ReflectionDataBuilder((SubstrateAnnotationExtractor)ImageSingletons.lookup(AnnotationExtractor.class));
        ImageSingletons.add(RuntimeReflectionSupport.class, (Object)this.reflectionData);
        ImageSingletons.add(ReflectionHostedSupport.class, (Object)this.reflectionData);
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.aUniverse = access.getUniverse();
        NativeImageConditionResolver conditionResolver = new NativeImageConditionResolver(access.getImageClassLoader(), ClassInitializationSupport.singleton());
        this.reflectionData.duringSetup(access.getMetaAccess(), this.aUniverse);
        ProxyRegistry proxyRegistry = (ProxyRegistry)ImageSingletons.lookup(ProxyRegistry.class);
        ReflectionConfigurationParser<ConfigurationCondition, Class<?>> parser = ConfigurationParserUtils.create("reflection", true, conditionResolver, (ReflectionRegistry)this.reflectionData, proxyRegistry, access.getImageClassLoader());
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurationsFromCombinedFile(parser, access.getImageClassLoader(), "reflection");
        ReflectionConfigurationParser<ConfigurationCondition, Class<?>> legacyParser = ConfigurationParserUtils.create(null, false, conditionResolver, (ReflectionRegistry)this.reflectionData, proxyRegistry, access.getImageClassLoader());
        this.loadedConfigurations += ConfigurationParserUtils.parseAndRegisterConfigurations(legacyParser, access.getImageClassLoader(), "reflection", ConfigurationFiles.Options.ReflectionConfigurationFiles, ConfigurationFiles.Options.ReflectionConfigurationResources, ConfigurationFile.REFLECTION.getFileName());
        this.loader = access.getImageClassLoader();
        this.annotationSubstitutions = ((Inflation)access.getBigBang()).getAnnotationSubstitutionProcessor();
        for (Class<?> primitiveClass : PRIMITIVE_CLASSES) {
            ClassForNameSupport.singleton().registerNegativeQuery(ConfigurationCondition.alwaysTrue(), primitiveClass.getName());
        }
        access.registerObjectReachableCallback(SubstrateAccessor.class, ReflectionFeature::onAccessorReachable);
    }

    private static void onAccessorReachable(Feature.DuringAnalysisAccess a, SubstrateAccessor accessor, ObjectScanner.ScanReason reason) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        ResolvedJavaMethod expandSignatureMethod = ((MethodPointer)accessor.getExpandSignature()).getMethod();
        access.registerAsRoot((AnalysisMethod)expandSignatureMethod, true, reason, new MultiMethod.MultiMethodKey[0]);
        ResolvedJavaMethod targetMethod = accessor.getTargetMethod();
        if (targetMethod != null) {
            SubstrateMethodAccessor mAccessor;
            if (!targetMethod.isAbstract()) {
                access.registerAsRoot((AnalysisMethod)targetMethod, true, reason, new MultiMethod.MultiMethodKey[0]);
            }
            if (accessor instanceof SubstrateMethodAccessor && (mAccessor = (SubstrateMethodAccessor)accessor).getVTableOffset() != -1) {
                access.registerAsRoot((AnalysisMethod)targetMethod, false, reason, new MultiMethod.MultiMethodKey[0]);
            }
            if (accessor instanceof SubstrateConstructorAccessor) {
                SubstrateConstructorAccessor cAccessor = (SubstrateConstructorAccessor)accessor;
                access.registerAsRoot((AnalysisMethod)cAccessor.getFactoryMethod(), false, reason, new MultiMethod.MultiMethodKey[0]);
            }
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.analysisAccess = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        this.metaAccess = this.analysisAccess.getMetaAccess();
        this.reflectionData.beforeAnalysis(this.analysisAccess);
        this.reflectionData.setAnalysisAccess(access);
        access.registerFieldValueTransformer(ReflectionUtil.lookupField(SubstrateMethodAccessor.class, (String)"vtableOffset"), (FieldValueTransformer)new ComputeVTableOffset());
        if (!SubstrateOptions.closedTypeWorld()) {
            access.registerFieldValueTransformer(ReflectionUtil.lookupField(SubstrateMethodAccessor.class, (String)"interfaceTypeID"), (FieldValueTransformer)new ComputeInterfaceTypeID());
        }
        RuntimeReflection.register((Executable[])Object.class.getDeclaredMethods());
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.analysisAccess = null;
        this.reflectionData.afterAnalysis();
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        FallbackFeature.FallbackImageRequest reflectionFallback;
        this.metaAccess = ((FeatureImpl.BeforeCompilationAccessImpl)access).getMetaAccess();
        if (ImageSingletons.contains(FallbackFeature.class) && (reflectionFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).reflectionFallback) != null && this.loadedConfigurations == 0) {
            throw reflectionFallback;
        }
    }

    public HostedMetaAccess hostedMetaAccess() {
        return (HostedMetaAccess)this.metaAccess;
    }

    @Override
    public int getFieldOffset(Field field, boolean checkUnsafeAccessed) {
        VMError.guarantee(this.metaAccess instanceof HostedMetaAccess, "Field offsets are available only for compilation and afterwards.");
        HostedField hostedField = this.hostedMetaAccess().optionalLookupJavaField(field);
        if (hostedField == null || checkUnsafeAccessed && !hostedField.wrapped.isUnsafeAccessed()) {
            return -1;
        }
        return hostedField.getLocation();
    }

    @Override
    public String getDeletionReason(Field reflectionField) {
        ResolvedJavaField field = this.metaAccess.lookupJavaField(reflectionField);
        Delete annotation = (Delete)AnnotationAccess.getAnnotation((AnnotatedElement)field, Delete.class);
        return annotation != null ? annotation.value() : null;
    }

    @Override
    public void registerInvocationPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        FallbackFeature fallbackFeature = ImageSingletons.contains(FallbackFeature.class) ? (FallbackFeature)ImageSingletons.lookup(FallbackFeature.class) : null;
        ReflectionPlugins.registerInvocationPlugins(this.loader, this.annotationSubstitutions, plugins.getClassInitializationPlugin(), plugins.getInvocationPlugins(), this.aUniverse, reason, fallbackFeature);
    }
}

