/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.AnnotateOriginal;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.annotate.KeepOriginal;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.substitute.AnnotatedField;
import com.oracle.svm.hosted.substitute.AnnotatedMethod;
import com.oracle.svm.hosted.substitute.ComputedValueField;
import com.oracle.svm.hosted.substitute.DeletedElementException;
import com.oracle.svm.hosted.substitute.DeletedMethod;
import com.oracle.svm.hosted.substitute.InjectedFieldsType;
import com.oracle.svm.hosted.substitute.PolymorphicSignatureWrapperMethod;
import com.oracle.svm.hosted.substitute.SubstitutionField;
import com.oracle.svm.hosted.substitute.SubstitutionMethod;
import com.oracle.svm.hosted.substitute.SubstitutionType;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class AnnotationSubstitutionProcessor
extends SubstitutionProcessor {
    private static final int SUBSTITUTE_ARRAY_DIMENSIONS = 255;
    protected final ImageClassLoader imageClassLoader;
    protected final MetaAccessProvider metaAccess;
    private final Map<Object, Delete> deleteAnnotations;
    private final Map<ResolvedJavaType, ResolvedJavaType> typeSubstitutions;
    private final Map<ResolvedJavaMethod, ResolvedJavaMethod> methodSubstitutions;
    private final Map<ResolvedJavaMethod, ResolvedJavaMethod> polymorphicMethodSubstitutions;
    private final Map<ResolvedJavaField, ResolvedJavaField> fieldSubstitutions;
    private final ClassInitializationSupport classInitializationSupport;
    @Delete(value="The declaring class of this element has been substituted, but this element is not present in the substitution class")
    static final int SUBSTITUTION_DELETE_HOLDER = 0;
    static final Delete SUBSTITUTION_DELETE;

    public AnnotationSubstitutionProcessor(ImageClassLoader imageClassLoader, MetaAccessProvider metaAccess, ClassInitializationSupport classInitializationSupport) {
        this.imageClassLoader = imageClassLoader;
        this.metaAccess = metaAccess;
        this.classInitializationSupport = classInitializationSupport;
        this.deleteAnnotations = new HashMap<Object, Delete>();
        this.typeSubstitutions = new ConcurrentHashMap<ResolvedJavaType, ResolvedJavaType>();
        this.methodSubstitutions = new ConcurrentHashMap<ResolvedJavaMethod, ResolvedJavaMethod>();
        this.polymorphicMethodSubstitutions = new HashMap<ResolvedJavaMethod, ResolvedJavaMethod>();
        this.fieldSubstitutions = new ConcurrentHashMap<ResolvedJavaField, ResolvedJavaField>();
    }

    public ResolvedJavaType lookup(ResolvedJavaType type) {
        Delete deleteAnnotation = this.deleteAnnotations.get(type);
        if (deleteAnnotation != null) {
            throw new DeletedElementException(AnnotationSubstitutionProcessor.deleteErrorMessage((AnnotatedElement)type, deleteAnnotation, true));
        }
        ResolvedJavaType substitution = this.findTypeSubstitution(type);
        if (substitution != null) {
            return substitution;
        }
        return type;
    }

    private ResolvedJavaType findTypeSubstitution(ResolvedJavaType type) {
        ResolvedJavaType elementalType;
        ResolvedJavaType elementalTypeSubstitution;
        ResolvedJavaType substitution = this.typeSubstitutions.get(type);
        if (substitution != null) {
            return substitution;
        }
        if (type.isArray() && (elementalTypeSubstitution = this.typeSubstitutions.get(elementalType = type.getElementalType())) != null) {
            int dimension = SubstrateUtil.arrayTypeDimension(type);
            ResolvedJavaType annotated = elementalType;
            ResolvedJavaType original = elementalTypeSubstitution;
            for (int i = 0; i < dimension; ++i) {
                annotated = annotated.getArrayClass();
                original = original.getArrayClass();
                this.typeSubstitutions.putIfAbsent(annotated, original);
            }
            return original;
        }
        return null;
    }

    public ResolvedJavaField lookup(ResolvedJavaField field) {
        Delete deleteAnnotation = this.deleteAnnotations.get(field);
        if (deleteAnnotation != null) {
            throw new DeletedElementException(AnnotationSubstitutionProcessor.deleteErrorMessage((AnnotatedElement)field, deleteAnnotation, true));
        }
        ResolvedJavaField existing = this.fieldSubstitutions.get(field);
        return existing != null ? existing : field;
    }

    public boolean isDeleted(Field field) {
        return this.isDeleted(this.metaAccess.lookupJavaField(field));
    }

    public boolean isDeleted(ResolvedJavaField field) {
        if (this.deleteAnnotations.get(field) != null) {
            return true;
        }
        return this.isAnnotationPresent(field, Delete.class);
    }

    public boolean isAnnotationPresent(Field field, Class<? extends Annotation> annotationClass) {
        return this.isAnnotationPresent(this.metaAccess.lookupJavaField(field), annotationClass);
    }

    public boolean isAnnotationPresent(ResolvedJavaField field, Class<? extends Annotation> annotationClass) {
        ResolvedJavaField substitutionField = this.fieldSubstitutions.get(field);
        if (substitutionField != null) {
            return AnnotationAccess.isAnnotationPresent((AnnotatedElement)substitutionField, annotationClass);
        }
        return false;
    }

    public boolean isDeleted(Class<?> clazz) {
        return this.deleteAnnotations.containsKey(this.metaAccess.lookupJavaType(clazz));
    }

    public Optional<ResolvedJavaField> findSubstitution(ResolvedJavaField field) {
        assert (!this.isDeleted(field)) : "Field " + field.format("%H.%n") + "is deleted.";
        return Optional.ofNullable(this.fieldSubstitutions.get(field));
    }

    public Optional<ResolvedJavaType> findFullSubstitution(ResolvedJavaType type) {
        ResolvedJavaType subst = this.findTypeSubstitution(type);
        return subst instanceof SubstitutionType ? Optional.of(subst) : Optional.empty();
    }

    public boolean isAliased(ResolvedJavaType type) {
        if (type instanceof SubstitutionType) {
            return false;
        }
        return this.typeSubstitutions.containsValue(type) || this.typeSubstitutions.containsValue(type.getElementalType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        Delete deleteAnnotation = this.deleteAnnotations.get(method);
        if (deleteAnnotation != null) {
            throw new DeletedElementException(AnnotationSubstitutionProcessor.deleteErrorMessage((AnnotatedElement)method, deleteAnnotation, true));
        }
        ResolvedJavaMethod substitution = this.methodSubstitutions.get(method);
        if (substitution != null) {
            return substitution;
        }
        for (ResolvedJavaMethod baseMethod : this.polymorphicMethodSubstitutions.keySet()) {
            if (!method.getDeclaringClass().equals((Object)baseMethod.getDeclaringClass()) || !method.getName().equals(baseMethod.getName())) continue;
            SubstitutionMethod substitutionBaseMethod = (SubstitutionMethod)this.polymorphicMethodSubstitutions.get(baseMethod);
            if (method.isVarArgs()) {
                return substitutionBaseMethod;
            }
            PolymorphicSignatureWrapperMethod wrapperMethod = new PolymorphicSignatureWrapperMethod(substitutionBaseMethod, method);
            SubstitutionMethod substitutionMethod = new SubstitutionMethod(method, wrapperMethod, false, true);
            Map<ResolvedJavaMethod, ResolvedJavaMethod> map = this.methodSubstitutions;
            synchronized (map) {
                ResolvedJavaMethod currentSubstitution = this.methodSubstitutions.get(method);
                if (currentSubstitution != null) {
                    return currentSubstitution;
                }
                AnnotationSubstitutionProcessor.register(this.methodSubstitutions, wrapperMethod, method, substitutionMethod);
            }
            return substitutionMethod;
        }
        return method;
    }

    public void processComputedValueFields(BigBang bb) {
        for (ResolvedJavaField field : this.fieldSubstitutions.values()) {
            if (!(field instanceof ComputedValueField)) continue;
            ComputedValueField cvField = (ComputedValueField)field;
            switch (cvField.getRecomputeValueKind()) {
                case FieldOffset: {
                    AnalysisField targetField = bb.getMetaAccess().lookupJavaField(cvField.getTargetField());
                    assert (!AnnotationAccess.isAnnotationPresent((AnnotatedElement)targetField, Delete.class));
                    targetField.registerAsUnsafeAccessed((Object)cvField);
                }
            }
        }
    }

    public void init() {
        List<Class<?>> annotatedClasses = this.findTargetClasses();
        annotatedClasses.sort(Comparator.comparing(Class::getName));
        for (Class<?> annotatedClass : annotatedClasses) {
            this.handleClass(annotatedClass);
        }
        List<Field> annotatedFields = this.imageClassLoader.findAnnotatedFields(NativeImageReinitialize.class);
        for (Field annotatedField : annotatedFields) {
            this.reinitializeField(annotatedField);
        }
    }

    protected List<Class<?>> findTargetClasses() {
        return this.imageClassLoader.findAnnotatedClasses(TargetClass.class, false);
    }

    protected void handleClass(Class<?> annotatedClass) {
        UserError.guarantee(Modifier.isFinal(annotatedClass.getModifiers()) || annotatedClass.isInterface(), "Annotated class must be final: %s", annotatedClass);
        UserError.guarantee(annotatedClass.getSuperclass() == Object.class || annotatedClass.isInterface(), "Annotated class must inherit directly from Object: %s", annotatedClass);
        if (!NativeImageGenerator.includedIn((Platform)ImageSingletons.lookup(Platform.class), this.lookupAnnotation(annotatedClass, Platforms.class))) {
            return;
        }
        TargetClass targetClassAnnotation = this.lookupAnnotation(annotatedClass, TargetClass.class);
        Class<?> originalClass = this.findTargetClass(annotatedClass, targetClassAnnotation);
        if (originalClass == null) {
            return;
        }
        this.classInitializationSupport.forceInitializeHosted(annotatedClass, "substitutions are always initialized", false);
        Delete deleteAnnotation = this.lookupAnnotation(annotatedClass, Delete.class);
        Substitute substituteAnnotation = this.lookupAnnotation(annotatedClass, Substitute.class);
        int numAnnotations = (deleteAnnotation != null ? 1 : 0) + (substituteAnnotation != null ? 1 : 0);
        UserError.guarantee(numAnnotations <= 1, "Only one of @Delete or @Substitute can be used: %s", annotatedClass);
        if (deleteAnnotation != null) {
            this.handleDeletedClass(originalClass, deleteAnnotation);
        } else if (substituteAnnotation != null) {
            this.handleSubstitutionClass(annotatedClass, originalClass);
        } else {
            this.handleAliasClass(annotatedClass, originalClass, targetClassAnnotation);
        }
    }

    private static String substitutionName(Class<?> originalClass) {
        return "Target_" + originalClass.getName().replace('.', '_').replace('$', '_');
    }

    private void handleAliasClass(Class<?> annotatedClass, Class<?> originalClass, TargetClass targetClassAnnotation) {
        if (SubstrateOptions.VerifyNamingConventions.getValue().booleanValue() && targetClassAnnotation.classNameProvider() == TargetClass.NoClassNameProvider.class) {
            String expectedName = AnnotationSubstitutionProcessor.substitutionName(originalClass);
            String actualName = annotatedClass.getSimpleName();
            UserError.guarantee(actualName.equals(expectedName) || actualName.startsWith(expectedName + "_"), "Naming convention violation: %s must be named %s or %s_<suffix>", annotatedClass, expectedName, expectedName);
        }
        ResolvedJavaType annotated = this.metaAccess.lookupJavaType(annotatedClass);
        ResolvedJavaType original = this.metaAccess.lookupJavaType(originalClass);
        UserError.guarantee(!this.typeSubstitutions.containsKey(annotated), "Already registered: %s", annotated);
        this.typeSubstitutions.put(annotated, original);
        for (Method method : annotatedClass.getDeclaredMethods()) {
            this.handleMethodInAliasClass(method, originalClass);
        }
        for (Executable executable : annotatedClass.getDeclaredConstructors()) {
            this.handleMethodInAliasClass(executable, originalClass);
        }
        for (AccessibleObject accessibleObject : annotatedClass.getDeclaredFields()) {
            this.handleFieldInAliasClass((Field)accessibleObject, originalClass);
        }
    }

    private void handleMethodInAliasClass(Executable annotatedMethod, Class<?> originalClass) {
        Alias aliasAnnotation;
        AnnotateOriginal annotateOriginalAnnotation;
        Substitute substituteAnnotation;
        if (this.skipExcludedPlatform(annotatedMethod)) {
            return;
        }
        Delete deleteAnnotation = this.lookupAnnotation(annotatedMethod, Delete.class);
        int numAnnotations = (deleteAnnotation != null ? 1 : 0) + ((substituteAnnotation = this.lookupAnnotation(annotatedMethod, Substitute.class)) != null ? 1 : 0) + ((annotateOriginalAnnotation = this.lookupAnnotation(annotatedMethod, AnnotateOriginal.class)) != null ? 1 : 0) + ((aliasAnnotation = this.lookupAnnotation(annotatedMethod, Alias.class)) != null ? 1 : 0);
        if (numAnnotations == 0) {
            if (!(annotatedMethod instanceof Constructor) && annotatedMethod.getName().startsWith("lambda$")) {
                String targetClass = annotatedMethod.getDeclaringClass().getName();
                String[] methodNameParts = annotatedMethod.getName().split("[$]");
                String method = methodNameParts.length > 1 ? methodNameParts[1] : annotatedMethod.getName();
                throw UserError.abort("Lambda usage detected in the substitution method: %s#%s. Lambdas are not supported inside substitution methods. To fix the issue, replace the culprit lambda with an equivalent anonymous class.", targetClass, method);
            }
            UserError.guarantee(annotatedMethod instanceof Constructor, "One of @Delete, @Substitute, @AnnotateOriginal, or @Alias must be used: %s", annotatedMethod);
            return;
        }
        UserError.guarantee(numAnnotations == 1, "Only one of @Delete, @Substitute, @AnnotateOriginal, or @Alias can be used: %s", annotatedMethod);
        ResolvedJavaMethod annotated = this.metaAccess.lookupJavaMethod(annotatedMethod);
        ResolvedJavaMethod original = this.findOriginalMethod(annotatedMethod, originalClass);
        if (original == null) {
            return;
        }
        if (deleteAnnotation != null) {
            int modifiers;
            if (SubstrateOptions.VerifyNamingConventions.getValue().booleanValue() && (Modifier.isProtected(modifiers = original.getModifiers()) || Modifier.isPublic(modifiers))) {
                String format = "Detected a public or protected method annotated with @Delete: %s. Such usages of @Delete are not permited since these methods can be called from third party code and can lead to unsupported features. Instead the method should be replaced with a @Substitute method and `throw VMError.unsupportedFeature()`.";
                throw UserError.abort(format, annotatedMethod);
            }
            this.registerAsDeleted(annotated, original, deleteAnnotation);
        } else if (substituteAnnotation != null) {
            if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)annotated, Uninterruptible.class) && !AnnotationSubstitutionProcessor.isEffectivelyFinal(original)) {
                throw UserError.abort("@Uninterruptible may only be combined with @Substitute if the original method is effectively final: %s", annotatedMethod);
            }
            SubstitutionMethod substitution = new SubstitutionMethod(original, annotated, false, true);
            if (substituteAnnotation.polymorphicSignature()) {
                AnnotationSubstitutionProcessor.register(this.polymorphicMethodSubstitutions, annotated, original, substitution);
            }
            AnnotationSubstitutionProcessor.register(this.methodSubstitutions, annotated, original, substitution);
        } else if (annotateOriginalAnnotation != null) {
            if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)annotated, Uninterruptible.class) && !AnnotationSubstitutionProcessor.isEffectivelyFinal(original)) {
                throw UserError.abort("@Uninterruptible may only be combined with @AnnotateOriginal if the original method is effectively final: %s", annotatedMethod);
            }
            AnnotatedMethod substitution = new AnnotatedMethod(original, annotated);
            AnnotationSubstitutionProcessor.register(this.methodSubstitutions, annotated, original, substitution);
        } else if (aliasAnnotation != null) {
            AnnotationSubstitutionProcessor.register(this.methodSubstitutions, annotated, original, original);
        }
    }

    private static boolean isEffectivelyFinal(ResolvedJavaMethod original) {
        return original.isPrivate() || original.isStatic() || original.isFinalFlagSet() || original.getDeclaringClass().isFinalFlagSet();
    }

    private boolean skipExcludedPlatform(AnnotatedElement annotatedMethod) {
        return !NativeImageGenerator.includedIn((Platform)ImageSingletons.lookup(Platform.class), this.lookupAnnotation(annotatedMethod, Platforms.class));
    }

    private void handleFieldInAliasClass(Field annotatedField, Class<?> originalClass) {
        Inject injectAnnotation;
        Alias aliasAnnotation;
        if (this.skipExcludedPlatform(annotatedField)) {
            return;
        }
        ResolvedJavaField annotated = this.metaAccess.lookupJavaField(annotatedField);
        Delete deleteAnnotation = this.lookupAnnotation(annotatedField, Delete.class);
        int numAnnotations = (deleteAnnotation != null ? 1 : 0) + ((aliasAnnotation = this.lookupAnnotation(annotatedField, Alias.class)) != null ? 1 : 0) + ((injectAnnotation = this.lookupAnnotation(annotatedField, Inject.class)) != null ? 1 : 0);
        if (numAnnotations == 0) {
            UserError.guarantee(annotatedField.getName().equals("$assertionsDisabled"), "One of @Delete, @Alias, or @Inject must be used: %s", annotatedField);
            ResolvedJavaField original = this.findOriginalField(annotatedField, originalClass, true);
            if (original != null) {
                AnnotationSubstitutionProcessor.register(this.fieldSubstitutions, annotated, null, original);
            }
            return;
        }
        UserError.guarantee(numAnnotations == 1, "Only one of @Delete, @Alias, or @Inject can be used: %s", annotatedField);
        if (injectAnnotation != null) {
            InjectedFieldsType substitution;
            UserError.guarantee(!annotated.isStatic(), "@Inject field must not be static: %s", annotated);
            ResolvedJavaField injected = this.fieldValueRecomputation(originalClass, annotated, annotated, annotatedField);
            AnnotationSubstitutionProcessor.register(this.fieldSubstitutions, annotated, null, injected);
            ResolvedJavaType original = this.metaAccess.lookupJavaType(originalClass);
            if (this.typeSubstitutions.get(original) instanceof InjectedFieldsType) {
                substitution = (InjectedFieldsType)this.typeSubstitutions.get(original);
                AnnotationSubstitutionProcessor.register(this.typeSubstitutions, annotated.getDeclaringClass(), original, substitution);
            } else {
                substitution = new InjectedFieldsType(original);
                AnnotationSubstitutionProcessor.register(this.typeSubstitutions, annotated.getDeclaringClass(), original, substitution);
            }
            substitution.addInjectedField(injected);
        } else {
            ResolvedJavaField original = this.findOriginalField(annotatedField, originalClass, false);
            if (original == null) {
                return;
            }
            UserError.guarantee(annotated.isStatic() == original.isStatic(), "Static modifier mismatch: %s, %s", annotated, original);
            UserError.guarantee(annotated.getJavaKind() == original.getJavaKind(), "Type mismatch: %s, %s", annotated, original);
            RecomputeFieldValue recomputeAnnotation = this.lookupAnnotation(annotatedField, RecomputeFieldValue.class);
            if (Modifier.isStatic(annotatedField.getModifiers()) && (recomputeAnnotation == null || recomputeAnnotation.kind() != RecomputeFieldValue.Kind.FromAlias)) {
                UserError.guarantee(AnnotationSubstitutionProcessor.hasDefaultValue(annotatedField), "The value assigned to a static @Alias field is ignored unless @RecomputeFieldValue with kind=FromAlias is used: %s", annotated);
            }
            UserError.guarantee(!Modifier.isFinal(annotatedField.getModifiers()), "The `final` modifier for the @Alias field is ignored and therefore misleading: %s", annotated);
            if (deleteAnnotation != null) {
                this.registerAsDeleted(annotated, original, deleteAnnotation);
            } else {
                ResolvedJavaField computedAlias = this.fieldValueRecomputation(originalClass, original, annotated, annotatedField);
                ResolvedJavaField existingAlias = this.fieldSubstitutions.get(original);
                ResolvedJavaField alias = computedAlias;
                if (existingAlias != null) {
                    if (computedAlias.equals((Object)original) || AnnotationSubstitutionProcessor.isCompatible(computedAlias, existingAlias)) {
                        alias = existingAlias;
                    } else if (existingAlias.equals((Object)original)) {
                        this.fieldSubstitutions.replaceAll((key, value) -> value.equals((Object)existingAlias) ? computedAlias : value);
                    }
                }
                AnnotationSubstitutionProcessor.register(this.fieldSubstitutions, annotated, original, alias);
            }
        }
    }

    private static boolean isCompatible(ResolvedJavaField computedAlias, ResolvedJavaField existingAlias) {
        ComputedValueField c;
        if (computedAlias instanceof ComputedValueField && (c = (ComputedValueField)computedAlias).getRecomputeValueKind() == RecomputeFieldValue.Kind.None) {
            return c.isCompatible(existingAlias);
        }
        return false;
    }

    private static boolean hasDefaultValue(Field annotatedField) {
        try {
            annotatedField.setAccessible(true);
            if (!annotatedField.getType().isPrimitive()) {
                return annotatedField.get(null) == null;
            }
            if (annotatedField.getType() == Float.TYPE || annotatedField.getType() == Double.TYPE) {
                return annotatedField.getDouble(null) == 0.0;
            }
            if (annotatedField.getType() == Boolean.TYPE) {
                return !annotatedField.getBoolean(null);
            }
            return annotatedField.getLong(null) == 0L;
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private void handleDeletedClass(Class<?> originalClass, Delete deleteAnnotation) {
        if (NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
            ResolvedJavaType type = this.metaAccess.lookupJavaType(originalClass);
            try {
                type.link();
            }
            catch (LinkageError ignored) {
                return;
            }
            for (ResolvedJavaMethod resolvedJavaMethod : type.getDeclaredMethods()) {
                this.registerAsDeleted(null, resolvedJavaMethod, deleteAnnotation);
            }
            for (ResolvedJavaMethod resolvedJavaMethod : type.getDeclaredConstructors()) {
                this.registerAsDeleted(null, resolvedJavaMethod, deleteAnnotation);
            }
            for (ResolvedJavaMethod resolvedJavaMethod : type.getInstanceFields(false)) {
                this.registerAsDeleted(null, (ResolvedJavaField)resolvedJavaMethod, deleteAnnotation);
            }
            for (ResolvedJavaMethod resolvedJavaMethod : type.getStaticFields()) {
                this.registerAsDeleted(null, (ResolvedJavaField)resolvedJavaMethod, deleteAnnotation);
            }
        } else {
            this.deleteAnnotations.put(this.metaAccess.lookupJavaType(originalClass), deleteAnnotation);
        }
    }

    private void registerAsDeleted(ResolvedJavaMethod annotated, ResolvedJavaMethod original, Delete deleteAnnotation) {
        if (NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
            AnnotationSubstitutionProcessor.register(this.methodSubstitutions, annotated, original, new DeletedMethod(original, deleteAnnotation));
        } else {
            this.deleteAnnotations.put(original, deleteAnnotation);
            this.deleteAnnotations.put(annotated, deleteAnnotation);
        }
    }

    private void registerAsDeleted(ResolvedJavaField annotated, ResolvedJavaField original, Delete deleteAnnotation) {
        if (NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
            AnnotationSubstitutionProcessor.register(this.fieldSubstitutions, annotated, original, new AnnotatedField(original, (Annotation)deleteAnnotation));
        } else {
            this.deleteAnnotations.put(original, deleteAnnotation);
            this.deleteAnnotations.put(annotated, deleteAnnotation);
        }
    }

    private void handleSubstitutionClass(Class<?> annotatedClass, Class<?> originalClass) {
        UserError.guarantee(annotatedClass.isInterface() == originalClass.isInterface(), "if original is interface, target must also be interface: %s", annotatedClass);
        UserError.guarantee(originalClass.getSuperclass() == Object.class || originalClass.isInterface(), "target class must inherit directly from Object: %s", originalClass);
        boolean keepOriginalElements = this.lookupAnnotation(annotatedClass, KeepOriginal.class) != null;
        ResolvedJavaType original = this.metaAccess.lookupJavaType(originalClass);
        ResolvedJavaType annotated = this.metaAccess.lookupJavaType(annotatedClass);
        SubstitutionType substitution = new SubstitutionType(original, annotated, true);
        AnnotationSubstitutionProcessor.register(this.typeSubstitutions, annotated, original, substitution);
        for (int i = 1; i <= 255; ++i) {
            original = original.getArrayClass();
            annotated = annotated.getArrayClass();
            SubstitutionType arrayTypeSubstitution = new SubstitutionType(original, annotated, true);
            AnnotationSubstitutionProcessor.register(this.typeSubstitutions, annotated, original, arrayTypeSubstitution);
        }
        for (Method method : annotatedClass.getDeclaredMethods()) {
            this.handleAnnotatedMethodInSubstitutionClass(method, originalClass);
        }
        for (Executable executable : annotatedClass.getDeclaredConstructors()) {
            this.handleAnnotatedMethodInSubstitutionClass(executable, originalClass);
        }
        for (Executable executable : originalClass.getDeclaredMethods()) {
            this.handleOriginalMethodInSubstitutionClass(executable, keepOriginalElements);
        }
        for (Executable executable : originalClass.getDeclaredConstructors()) {
            this.handleOriginalMethodInSubstitutionClass(executable, keepOriginalElements);
        }
        for (AccessibleObject accessibleObject : annotatedClass.getDeclaredFields()) {
            ResolvedJavaField field = this.metaAccess.lookupJavaField((Field)accessibleObject);
            ResolvedJavaField alias = this.fieldValueRecomputation(annotatedClass, field, field, (Field)accessibleObject);
            if (!alias.equals((Object)field)) {
                ResolvedJavaField originalField = this.findOriginalField((Field)accessibleObject, originalClass, true);
                UserError.guarantee(originalField == null || !alias.isFinal() || originalField.isFinal(), "a non-final field cannot be redeclared as final through substitution: %s", field);
                AnnotationSubstitutionProcessor.register(this.fieldSubstitutions, field, originalField, alias);
                continue;
            }
            this.handleAnnotatedFieldInSubstitutionClass((Field)accessibleObject, originalClass);
        }
        for (AccessibleObject accessibleObject : originalClass.getDeclaredFields()) {
            this.handleOriginalFieldInSubstitutionClass((Field)accessibleObject, keepOriginalElements, substitution);
        }
    }

    private void handleAnnotatedMethodInSubstitutionClass(Executable annotatedMethod, Class<?> originalClass) {
        KeepOriginal keepOriginalAnnotation;
        if (this.skipExcludedPlatform(annotatedMethod)) {
            return;
        }
        if (annotatedMethod.isSynthetic()) {
            return;
        }
        Substitute substituteAnnotation = this.lookupAnnotation(annotatedMethod, Substitute.class);
        int numAnnotations = (substituteAnnotation != null ? 1 : 0) + ((keepOriginalAnnotation = this.lookupAnnotation(annotatedMethod, KeepOriginal.class)) != null ? 1 : 0);
        if (numAnnotations == 0) {
            return;
        }
        UserError.guarantee(numAnnotations == 1, "only one of @Substitute or @KeepOriginal can be used: %s", annotatedMethod);
        ResolvedJavaMethod annotated = this.metaAccess.lookupJavaMethod(annotatedMethod);
        ResolvedJavaMethod original = this.findOriginalMethod(annotatedMethod, originalClass);
        if (original != null) {
            if (substituteAnnotation != null) {
                SubstitutionMethod substitution = new SubstitutionMethod(original, annotated, true, true);
                if (substituteAnnotation.polymorphicSignature()) {
                    AnnotationSubstitutionProcessor.register(this.polymorphicMethodSubstitutions, annotated, original, substitution);
                }
                AnnotationSubstitutionProcessor.register(this.methodSubstitutions, annotated, original, substitution);
            } else if (keepOriginalAnnotation != null) {
                AnnotationSubstitutionProcessor.register(this.methodSubstitutions, annotated, original, original);
            }
        }
    }

    private void handleAnnotatedFieldInSubstitutionClass(Field annotatedField, Class<?> originalClass) {
        if (this.skipExcludedPlatform(annotatedField)) {
            return;
        }
        Substitute substituteAnnotation = this.lookupAnnotation(annotatedField, Substitute.class);
        if (substituteAnnotation == null) {
            return;
        }
        ResolvedJavaField annotated = this.metaAccess.lookupJavaField(annotatedField);
        ResolvedJavaField original = this.findOriginalField(annotatedField, originalClass, false);
        if (original != null) {
            AnnotationSubstitutionProcessor.register(this.fieldSubstitutions, annotated, original, new SubstitutionField(original, annotated, true));
        }
    }

    private void handleOriginalMethodInSubstitutionClass(Executable m, boolean keepOriginalElements) {
        ResolvedJavaMethod method = this.metaAccess.lookupJavaMethod(m);
        if (!this.methodSubstitutions.containsKey(method)) {
            if (keepOriginalElements || method.isSynthetic()) {
                AnnotationSubstitutionProcessor.register(this.methodSubstitutions, null, method, method);
            } else {
                this.registerAsDeleted(null, method, SUBSTITUTION_DELETE);
            }
        }
    }

    private void handleOriginalFieldInSubstitutionClass(Field f, boolean keepOriginalElements, SubstitutionType substitution) {
        ResolvedJavaField field = this.metaAccess.lookupJavaField(f);
        if (!this.fieldSubstitutions.containsKey(field)) {
            if (keepOriginalElements || field.isSynthetic()) {
                AnnotationSubstitutionProcessor.register(this.fieldSubstitutions, null, field, field);
                if (!field.isStatic()) {
                    substitution.addInstanceField(field);
                }
            } else {
                this.registerAsDeleted(null, field, SUBSTITUTION_DELETE);
            }
        }
    }

    public String findOriginalElementName(AnnotatedElement annotatedElement, Class<?> originalClass) {
        TargetElement targetElementAnnotation = this.lookupAnnotation(annotatedElement, TargetElement.class);
        String originalName = "";
        if (targetElementAnnotation != null) {
            originalName = targetElementAnnotation.name();
            if (!AnnotationSubstitutionProcessor.isIncluded(targetElementAnnotation, originalClass, annotatedElement)) {
                return null;
            }
        }
        if (originalName.length() == 0) {
            originalName = ((Member)((Object)annotatedElement)).getName();
        }
        return originalName;
    }

    private ResolvedJavaMethod findOriginalMethod(Executable annotatedMethod, Class<?> originalClass) {
        String originalName = this.findOriginalElementName(annotatedMethod, originalClass);
        if (originalName == null) {
            return null;
        }
        try {
            if (annotatedMethod instanceof Method && !originalName.equals("<init>")) {
                Class<?>[] originalParams = this.interceptParameterTypes(annotatedMethod.getParameterTypes());
                Method originalMethod = originalClass.getDeclaredMethod(originalName, originalParams);
                UserError.guarantee(Modifier.isStatic(annotatedMethod.getModifiers()) == Modifier.isStatic(originalMethod.getModifiers()), "Static modifier mismatch: %s, %s", annotatedMethod, originalMethod);
                UserError.guarantee(this.getTargetClass(((Method)annotatedMethod).getReturnType()).equals(originalMethod.getReturnType()), "Return type mismatch:%n    %s%n    %s", annotatedMethod, originalMethod);
                return this.metaAccess.lookupJavaMethod((Executable)originalMethod);
            }
            UserError.guarantee(!Modifier.isStatic(annotatedMethod.getModifiers()), "Constructor Alias method %s must not be static", annotatedMethod);
            Class<?>[] originalParams = this.interceptParameterTypes(annotatedMethod.getParameterTypes());
            Constructor<?> originalMethod = originalClass.getDeclaredConstructor(originalParams);
            return this.metaAccess.lookupJavaMethod(originalMethod);
        }
        catch (NoSuchMethodException ex) {
            throw UserError.abort("Could not find target method: %s", annotatedMethod);
        }
        catch (LinkageError error) {
            throw UserError.abort("Cannot find %s.%s, %s can not be loaded, due to %s not being available in the classpath. Are you missing a dependency in your classpath?", originalClass.getName(), originalName, originalClass.getName(), error.getMessage());
        }
    }

    private ResolvedJavaField findOriginalField(Field annotatedField, Class<?> originalClass, boolean forceOptional) {
        String originalName = this.findOriginalElementName(annotatedField, originalClass);
        if (originalName == null) {
            return null;
        }
        try {
            Field originalField = originalClass.getDeclaredField(originalName);
            UserError.guarantee(this.getTargetClass(annotatedField.getType()).equals(originalField.getType()), "Type mismatch:%n    %s %s%n    %s %s", annotatedField.getType(), annotatedField, originalField.getType(), originalField);
            return this.metaAccess.lookupJavaField(originalField);
        }
        catch (NoSuchFieldException ex) {
            ResolvedJavaField[] fields = Modifier.isStatic(annotatedField.getModifiers()) ? this.metaAccess.lookupJavaType(originalClass).getStaticFields() : this.metaAccess.lookupJavaType(originalClass).getInstanceFields(true);
            for (ResolvedJavaField f : fields) {
                if (!f.getName().equals(originalName)) continue;
                return f;
            }
            UserError.guarantee(forceOptional, "could not find target field: %s", annotatedField);
            return null;
        }
    }

    private static boolean isIncluded(TargetElement targetElementAnnotation, Class<?> originalClass, AnnotatedElement annotatedElement) {
        for (Class onlyWithClass : targetElementAnnotation.onlyWith()) {
            boolean onlyWithResult;
            Object onlyWithProvider;
            try {
                onlyWithProvider = ReflectionUtil.newInstance((Class)onlyWithClass);
            }
            catch (ReflectionUtil.ReflectionUtilError ex) {
                throw UserError.abort(ex.getCause(), "Class specified as onlyWith for %s cannot be loaded or instantiated: %s", annotatedElement, onlyWithClass.getTypeName());
            }
            if (onlyWithProvider instanceof BooleanSupplier) {
                onlyWithResult = ((BooleanSupplier)onlyWithProvider).getAsBoolean();
            } else if (onlyWithProvider instanceof Predicate) {
                Predicate onlyWithPredicate = (Predicate)onlyWithProvider;
                onlyWithResult = onlyWithPredicate.test(originalClass);
            } else {
                throw UserError.abort("Class specified as onlyWith for %s does not implement %s or %s", annotatedElement, BooleanSupplier.class.getSimpleName(), Predicate.class.getSimpleName());
            }
            if (onlyWithResult) continue;
            return false;
        }
        return true;
    }

    private static <T> void register(Map<T, T> substitutions, T annotated, T original, T target) {
        if (annotated != null) {
            UserError.guarantee(!substitutions.containsKey(annotated) || substitutions.get(annotated) == original || substitutions.get(annotated) == target, "Substition: %s conflicts with previously registered: %s", annotated, substitutions.get(annotated));
            substitutions.put(annotated, target);
        }
        if (original != null) {
            UserError.guarantee(!substitutions.containsKey(original) || substitutions.get(original) == original || substitutions.get(original) == target, "Substition: %s conflicts with previously registered: %s", original, substitutions.get(original));
            substitutions.put(original, target);
        }
    }

    private ResolvedJavaField fieldValueRecomputation(Class<?> originalClass, ResolvedJavaField original, ResolvedJavaField annotated, Field annotatedField) {
        boolean isFinal;
        RecomputeFieldValue recomputeAnnotation = this.lookupAnnotation(annotatedField, RecomputeFieldValue.class);
        InjectAccessors injectAccessorsAnnotation = this.lookupAnnotation(annotatedField, InjectAccessors.class);
        int numAnnotations = (recomputeAnnotation != null ? 1 : 0) + (injectAccessorsAnnotation != null ? 1 : 0);
        UserError.guarantee(numAnnotations <= 1, "Only one of @RecomputeFieldValue or @InjectAccessors can be used: %s", annotatedField);
        if (injectAccessorsAnnotation != null) {
            return new AnnotatedField(original, (Annotation)injectAccessorsAnnotation);
        }
        if (recomputeAnnotation == null && !original.isFinal()) {
            return original;
        }
        RecomputeFieldValue.Kind kind = RecomputeFieldValue.Kind.None;
        Class<?> targetClass = originalClass;
        String targetName = "";
        boolean bl = isFinal = original.isFinal() && annotated.isFinal();
        if (recomputeAnnotation != null) {
            kind = recomputeAnnotation.kind();
            targetName = recomputeAnnotation.name();
            isFinal = recomputeAnnotation.isFinal();
            UserError.guarantee(!isFinal || !ComputedValueField.isOffsetRecomputation(kind), "@%s with %s can never be final during analysis: unset isFinal in the annotation on %s", RecomputeFieldValue.class.getSimpleName(), kind, annotated);
            if (recomputeAnnotation.declClass() != RecomputeFieldValue.class) {
                UserError.guarantee(recomputeAnnotation.declClassName().isEmpty(), "Both class and class name specified", new Object[0]);
                targetClass = recomputeAnnotation.declClass();
            } else if (!recomputeAnnotation.declClassName().isEmpty()) {
                targetClass = this.imageClassLoader.findClassOrFail(recomputeAnnotation.declClassName());
            }
        }
        Class<?> transformedValueAllowedType = this.getTargetClass(annotatedField.getType());
        return ComputedValueField.create(original, annotated, kind, transformedValueAllowedType, null, targetClass, targetName, isFinal);
    }

    protected void reinitializeField(Field annotatedField) {
        ResolvedJavaField annotated = this.metaAccess.lookupJavaField(annotatedField);
        ComputedValueField alias = ComputedValueField.create(annotated, annotated, RecomputeFieldValue.Kind.Reset, annotatedField.getDeclaringClass(), "", false);
        AnnotationSubstitutionProcessor.register(this.fieldSubstitutions, annotated, annotated, alias);
    }

    public Class<?> getTargetClass(Class<?> annotatedClass) {
        Class<?> annotatedBaseClass = annotatedClass;
        int arrayDepth = 0;
        while (annotatedBaseClass.isArray()) {
            ++arrayDepth;
            annotatedBaseClass = annotatedBaseClass.getComponentType();
        }
        TargetClass targetClassAnnotation = this.lookupAnnotation(annotatedBaseClass, TargetClass.class);
        if (targetClassAnnotation == null) {
            return annotatedClass;
        }
        Class<?> targetClass = this.findTargetClass(annotatedBaseClass, targetClassAnnotation);
        for (int i = 0; i < arrayDepth; ++i) {
            targetClass = Array.newInstance(targetClass, 0).getClass();
        }
        return targetClass;
    }

    Class<?> findTargetClass(Class<?> annotatedBaseClass, TargetClass target) {
        return this.findTargetClass(annotatedBaseClass, target, true);
    }

    protected Class<?> findTargetClass(Class<?> annotatedBaseClass, TargetClass target, boolean checkOnlyWith) {
        return this.findTargetClass(TargetClass.class, TargetClass.NoClassNameProvider.class, annotatedBaseClass, target, target.value(), target.className(), target.classNameProvider(), target.innerClass(), checkOnlyWith ? target.onlyWith() : null);
    }

    protected <T> Class<?> findTargetClass(Class<T> targetClass, Class<?> noClassNameProviderClass, Class<?> annotatedBaseClass, T target, Class<?> value, String targetClassName, Class<? extends Function<T, String>> classNameProvider, String[] innerClasses, Class<?>[] onlyWith) {
        Class<?> holder;
        String className;
        if (value != targetClass) {
            UserError.guarantee(targetClassName.isEmpty(), "Both class and class name specified for substitution", new Object[0]);
            UserError.guarantee(classNameProvider == noClassNameProviderClass, "Both class and classNameProvider specified for substitution", new Object[0]);
            className = value.getName();
        } else if (classNameProvider != noClassNameProviderClass) {
            try {
                className = (String)((Function)ReflectionUtil.newInstance(classNameProvider)).apply(target);
            }
            catch (ReflectionUtil.ReflectionUtilError ex) {
                throw UserError.abort(ex.getCause(), "Cannot instantiate classNameProvider: %s. The class must have a parameterless constructor.", classNameProvider.getTypeName());
            }
        } else {
            UserError.guarantee(!targetClassName.isEmpty(), "Neither class, className, nor classNameProvider specified for substitution", new Object[0]);
            className = targetClassName;
        }
        if (onlyWith != null) {
            for (Class<?> onlyWithClass : onlyWith) {
                boolean onlyWithResult;
                Object onlyWithProvider;
                try {
                    onlyWithProvider = ReflectionUtil.newInstance(onlyWithClass);
                }
                catch (ReflectionUtil.ReflectionUtilError ex) {
                    throw UserError.abort(ex.getCause(), "Class specified as onlyWith for %s cannot be loaded or instantiated: %s", annotatedBaseClass.getTypeName(), onlyWithClass.getTypeName());
                }
                if (onlyWithProvider instanceof BooleanSupplier) {
                    onlyWithResult = ((BooleanSupplier)onlyWithProvider).getAsBoolean();
                } else if (onlyWithProvider instanceof Predicate) {
                    Predicate onlyWithPredicate = (Predicate)onlyWithProvider;
                    onlyWithResult = onlyWithPredicate.test(className);
                } else {
                    throw UserError.abort("Class specified as onlyWith for %s does not implement %s or %s", annotatedBaseClass.getTypeName(), BooleanSupplier.class.getSimpleName(), Predicate.class.getSimpleName());
                }
                if (onlyWithResult) continue;
                return null;
            }
        }
        if ((holder = this.imageClassLoader.findClass(className).get()) == null) {
            throw UserError.abort("Substitution target for %s is not loaded. Use field `onlyWith` in the `TargetClass` annotation to make substitution only active when needed.", annotatedBaseClass.getName());
        }
        if (innerClasses.length > 0) {
            String[] stringArray = innerClasses;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?> prevHolder = holder;
                String innerClass = stringArray[i];
                if ((holder = AnnotationSubstitutionProcessor.findInnerClass(prevHolder, innerClass)) != null) continue;
                throw UserError.abort("Substitution target for %s is invalid as inner class %s in %s can not be found. Make sure that the inner class is present.", annotatedBaseClass.getName(), innerClass, prevHolder.getName());
            }
        }
        return holder;
    }

    protected static Class<?> findInnerClass(Class<?> outerClass, String innerClassSimpleName) {
        for (Class<?> innerClass : outerClass.getDeclaredClasses()) {
            String simpleName = innerClass.getSimpleName();
            if (!simpleName.equals(innerClassSimpleName)) continue;
            return innerClass;
        }
        return null;
    }

    private Class<?> interceptParameterType(Class<?> type) {
        Class<?> componentType;
        Class<?> componentRet;
        TargetClass targetClassAnnotation = this.lookupAnnotation(type, TargetClass.class);
        if (targetClassAnnotation != null) {
            return this.findTargetClass(type, targetClassAnnotation);
        }
        if (type.isArray() && !(componentRet = this.interceptParameterType(componentType = type.getComponentType())).equals(componentType)) {
            Object tmp = Array.newInstance(componentRet, 0);
            return tmp.getClass();
        }
        return type;
    }

    private Class<?>[] interceptParameterTypes(Class<?>[] types) {
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.interceptParameterType(types[i]);
        }
        return types;
    }

    protected <T extends Annotation> T lookupAnnotation(AnnotatedElement element, Class<T> annotationClass) {
        assert (element instanceof Class || element instanceof Executable || element instanceof Field) : element.getClass();
        return (T)AnnotationAccess.getAnnotation((AnnotatedElement)element, annotationClass);
    }

    protected static String deleteErrorMessage(AnnotatedElement element, Delete deleteAnnotation, boolean hosted) {
        return AnnotationSubstitutionProcessor.deleteErrorMessage(element, deleteAnnotation.value(), hosted);
    }

    public static String deleteErrorMessage(AnnotatedElement element, String message, boolean hosted) {
        StringBuilder result = new StringBuilder();
        result.append("Unsupported ");
        if (element instanceof ResolvedJavaField) {
            result.append("field ").append(((ResolvedJavaField)element).format("%H.%n"));
        } else if (element instanceof ResolvedJavaMethod) {
            ResolvedJavaMethod method = (ResolvedJavaMethod)element;
            result.append(method.isConstructor() ? "constructor " : "method ");
            result.append(method.format("%H.%n(%p)"));
        } else if (element instanceof ResolvedJavaType) {
            result.append("type ").append(((ResolvedJavaType)element).toJavaName(true));
        } else {
            throw VMError.shouldNotReachHere("Unknown @Delete annotated element " + String.valueOf(element));
        }
        result.append(" is reachable");
        if (message != null && !message.isEmpty()) {
            result.append(": ").append(message);
        }
        if (hosted) {
            result.append(System.lineSeparator()).append("To diagnose the issue, you can add the option ").append(SubstrateOptionsParser.commandArgument(NativeImageOptions.ReportUnsupportedElementsAtRuntime, "+")).append(". The unsupported element is then reported at run time when it is accessed the first time.");
        }
        return result.toString();
    }

    static {
        try {
            SUBSTITUTION_DELETE = AnnotationSubstitutionProcessor.class.getDeclaredField("SUBSTITUTION_DELETE_HOLDER").getAnnotation(Delete.class);
        }
        catch (NoSuchFieldException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

