/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.dcmd;

import com.oracle.svm.core.dcmd.DCmdOption;
import com.oracle.svm.core.util.BasedOnJDKFile;
import org.graalvm.collections.EconomicMap;

public class DCmdArguments {
    private final EconomicMap<DCmdOption<?>, Object> values = EconomicMap.create();

    public boolean hasBeenSet(DCmdOption<?> option) {
        Object value = this.values.get(option);
        return value != null;
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/diagnosticArgument.cpp#L54-L68")
    public void set(DCmdOption<?> option, Object value) {
        if (this.hasBeenSet(option)) {
            throw new IllegalArgumentException("Duplicates in diagnostic command arguments");
        }
        assert (value == null || option.type().isAssignableFrom(value.getClass()));
        this.values.put(option, value);
    }

    public <T> T get(DCmdOption<T> option) {
        Object value = this.values.get(option);
        if (value == null) {
            return option.defaultValue();
        }
        return (T)value;
    }
}

