/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.dcmd;

import com.oracle.svm.core.dcmd.AbstractDCmd;
import com.oracle.svm.core.dcmd.DCmd;
import com.oracle.svm.core.dcmd.DCmdArguments;
import com.oracle.svm.core.dcmd.DCmdOption;
import com.oracle.svm.core.dcmd.DCmdSupport;
import com.oracle.svm.core.util.BasedOnJDKFile;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/diagnosticCommand.hpp#L42-L57")
public class HelpDCmd
extends AbstractDCmd {
    private static final DCmdOption<String> COMMAND_NAME = new DCmdOption<Object>(String.class, "command name", "The name of the command for which we want help", false, null);
    private static final DCmdOption<Boolean> PRINT_ALL = new DCmdOption<Boolean>(Boolean.class, "-all", "Show help for all commands", false, false);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public HelpDCmd() {
        super("help", "For more information about a specific command use 'help <command>'. With no argument this will show a list of available commands. 'help -all' will show help for all commands.", DCmd.Impact.Low, new DCmdOption[]{COMMAND_NAME}, new DCmdOption[]{PRINT_ALL}, new String[]{"$ jcmd <pid> help Thread.dump_to_file"});
    }

    @Override
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+18/src/hotspot/share/services/diagnosticCommand.cpp#L188-L232")
    public String execute(DCmdArguments args) throws Throwable {
        if (args.get(PRINT_ALL).booleanValue()) {
            String lineBreak = System.lineSeparator();
            StringBuilder response = new StringBuilder();
            for (DCmd cmd : DCmdSupport.singleton().getCommands()) {
                response.append(cmd.getName()).append(lineBreak);
                response.append("\t").append(cmd.getDescription()).append(lineBreak);
                response.append(lineBreak);
            }
            return response.toString();
        }
        String commandName = args.get(COMMAND_NAME);
        if (commandName == null) {
            String lineBreak = System.lineSeparator();
            StringBuilder response = new StringBuilder("The following commands are available:").append(lineBreak);
            for (DCmd cmd : DCmdSupport.singleton().getCommands()) {
                response.append(cmd.getName()).append(lineBreak);
            }
            response.append(lineBreak);
            response.append("For more information about a specific command use 'help <command>'.");
            return response.toString();
        }
        DCmd cmd = DCmdSupport.singleton().getCommand(commandName);
        if (cmd == null) {
            throw new IllegalArgumentException("Help unavailable : '" + commandName + "' : No such command");
        }
        return cmd.getHelp();
    }
}

