/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateLoweringProvider;
import com.oracle.svm.core.graal.nodes.FloatingWordCastNode;
import com.oracle.svm.core.graal.nodes.LoadOpenTypeWorldDispatchTableStartingOffset;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.graal.nodes.SubstrateCompressionNode;
import com.oracle.svm.core.graal.nodes.SubstrateFieldLocationIdentity;
import com.oracle.svm.core.graal.nodes.SubstrateNarrowOopStamp;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.identityhashcode.IdentityHashCodeSupport;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.snippets.SubstrateIsArraySnippets;
import java.util.HashMap;
import java.util.Map;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.core.common.spi.MetaAccessExtensionProvider;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.CompressionNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.DeadEndNode;
import jdk.graal.compiler.nodes.FieldLocationIdentity;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.AndNode;
import jdk.graal.compiler.nodes.calc.LeftShiftNode;
import jdk.graal.compiler.nodes.calc.UnsignedRightShiftNode;
import jdk.graal.compiler.nodes.extended.LoadHubNode;
import jdk.graal.compiler.nodes.extended.LoadMethodNode;
import jdk.graal.compiler.nodes.memory.FloatingReadNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.spi.PlatformConfigurationProvider;
import jdk.graal.compiler.nodes.type.NarrowOopStamp;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.DefaultJavaLoweringProvider;
import jdk.graal.compiler.replacements.IdentityHashCodeSnippets;
import jdk.graal.compiler.replacements.IsArraySnippets;
import jdk.graal.compiler.replacements.SnippetCounter;
import jdk.graal.compiler.replacements.nodes.AssertionNode;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public abstract class SubstrateBasicLoweringProvider
extends DefaultJavaLoweringProvider
implements SubstrateLoweringProvider {
    private final Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings = new HashMap();
    private RuntimeConfiguration runtimeConfig;
    private final KnownOffsets knownOffsets;
    private final AbstractObjectStamp hubStamp;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateBasicLoweringProvider(MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls, PlatformConfigurationProvider platformConfig, MetaAccessExtensionProvider metaAccessExtensionProvider, TargetDescription target) {
        super(metaAccess, foreignCalls, platformConfig, metaAccessExtensionProvider, target, ReferenceAccess.singleton().haveCompressedReferences());
        ObjectStamp hubRefStamp = StampFactory.objectNonNull((TypeReference)TypeReference.createExactTrusted((ResolvedJavaType)metaAccess.lookupJavaType(DynamicHub.class)));
        if (ReferenceAccess.singleton().haveCompressedReferences()) {
            hubRefStamp = SubstrateNarrowOopStamp.compressed((AbstractObjectStamp)hubRefStamp, ReferenceAccess.singleton().getCompressEncoding());
        }
        this.hubStamp = hubRefStamp;
        this.knownOffsets = KnownOffsets.singleton();
    }

    @Override
    public void setConfiguration(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers) {
        this.runtimeConfig = runtimeConfig;
        this.isArraySnippets = new IsArraySnippets.Templates((IsArraySnippets)new SubstrateIsArraySnippets(), options, providers);
        this.initialize(options, SnippetCounter.Group.NullFactory, providers);
    }

    protected IdentityHashCodeSnippets.Templates createIdentityHashCodeSnippets(OptionValues options, Providers providers) {
        return IdentityHashCodeSupport.createSnippetTemplates(options, providers);
    }

    protected Providers getProviders() {
        return this.runtimeConfig.getProviders();
    }

    protected ObjectLayout getObjectLayout() {
        return ConfigurationValues.getObjectLayout();
    }

    @Override
    public Map<Class<? extends Node>, NodeLoweringProvider<?>> getLowerings() {
        return this.lowerings;
    }

    public void lower(Node n, LoweringTool tool) {
        if (n instanceof AssertionNode) {
            SubstrateBasicLoweringProvider.lowerAssertionNode((AssertionNode)n);
        } else if (n instanceof DeadEndNode) {
            this.lowerDeadEnd((DeadEndNode)n);
        } else if (n instanceof LoadMethodNode) {
            this.lowerLoadMethodNode((LoadMethodNode)n, tool);
        } else {
            super.lower(n, tool);
        }
    }

    private void lowerLoadMethodNode(LoadMethodNode loadMethodNode, LoweringTool tool) {
        StructuredGraph graph = loadMethodNode.graph();
        SharedMethod method = (SharedMethod)loadMethodNode.getMethod();
        ValueNode hub = loadMethodNode.getHub();
        if (SubstrateOptions.useClosedTypeWorldHubLayout()) {
            int vtableEntryOffset = this.knownOffsets.getVTableOffset(method.getVTableIndex(), true);
            assert (vtableEntryOffset > 0);
            AddressNode address = this.createOffsetAddress(graph, hub, vtableEntryOffset);
            ReadNode virtualMethod = (ReadNode)graph.add((Node)new ReadNode(address, SubstrateBackend.getVTableIdentity(), loadMethodNode.stamp(NodeView.DEFAULT), BarrierType.NONE, MemoryOrderMode.PLAIN));
            graph.replaceFixed((FixedWithNextNode)loadMethodNode, (Node)virtualMethod);
        } else {
            LoadOpenTypeWorldDispatchTableStartingOffset tableStartingOffset = (LoadOpenTypeWorldDispatchTableStartingOffset)graph.add((Node)new LoadOpenTypeWorldDispatchTableStartingOffset(hub, method));
            ValueNode methodAddress = (ValueNode)graph.unique((Node)new AddNode((ValueNode)tableStartingOffset, (ValueNode)ConstantNode.forIntegerKind((JavaKind)ConfigurationValues.getWordKind(), (long)this.knownOffsets.getVTableOffset(method.getVTableIndex(), false), (StructuredGraph)graph)));
            AddressNode dispatchTableAddress = (AddressNode)graph.unique((Node)new OffsetAddressNode(hub, methodAddress));
            ReadNode virtualMethod = (ReadNode)graph.add((Node)new ReadNode(dispatchTableAddress, SubstrateBackend.getVTableIdentity(), loadMethodNode.stamp(NodeView.DEFAULT), BarrierType.NONE, MemoryOrderMode.PLAIN));
            FixedWithNextNode predecessor = (FixedWithNextNode)loadMethodNode.predecessor();
            predecessor.setNext((FixedNode)tableStartingOffset);
            tableStartingOffset.setNext((FixedNode)virtualMethod);
            graph.replaceFixed((FixedWithNextNode)loadMethodNode, (Node)virtualMethod);
            tableStartingOffset.lower(tool);
        }
    }

    public int arrayLengthOffset() {
        return this.getObjectLayout().getArrayLengthOffset();
    }

    public ValueNode staticFieldBase(StructuredGraph graph, ResolvedJavaField f) {
        SharedField field = (SharedField)f;
        assert (field.isStatic());
        return (ValueNode)graph.unique((Node)StaticFieldsSupport.createStaticFieldBaseNode(field));
    }

    private static ValueNode maybeUncompress(ValueNode node) {
        Stamp stamp = node.stamp(NodeView.DEFAULT);
        if (stamp instanceof NarrowOopStamp) {
            return SubstrateCompressionNode.uncompress(node.graph(), node, ((NarrowOopStamp)stamp).getEncoding());
        }
        return node;
    }

    protected ValueNode createReadArrayComponentHub(StructuredGraph graph, ValueNode arrayHub, boolean isKnownObjectArray, FixedNode anchor) {
        ConstantNode componentHubOffset = ConstantNode.forIntegerKind((JavaKind)this.target.wordJavaKind, (long)this.knownOffsets.getComponentHubOffset(), (StructuredGraph)graph);
        AddressNode componentHubAddress = (AddressNode)graph.unique((Node)new OffsetAddressNode(arrayHub, (ValueNode)componentHubOffset));
        FloatingReadNode componentHubRef = (FloatingReadNode)graph.unique((Node)new FloatingReadNode(componentHubAddress, NamedLocationIdentity.FINAL_LOCATION, null, (Stamp)this.hubStamp, null, BarrierType.NONE));
        return SubstrateBasicLoweringProvider.maybeUncompress((ValueNode)componentHubRef);
    }

    protected ValueNode createReadHub(StructuredGraph graph, ValueNode object, LoweringTool tool) {
        ValueNode hubBits;
        AbstractPointerStamp loadHubStamp;
        ValueNode synonym;
        if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
            return (ValueNode)graph.unique((Node)new LoadHubNode(tool.getStampProvider(), object));
        }
        if (object.isConstant() && !object.asJavaConstant().isNull() && (synonym = LoadHubNode.findSynonym((ValueNode)object, (Stamp)(loadHubStamp = tool.getStampProvider().createHubStamp((ObjectStamp)object.stamp(NodeView.DEFAULT))), (MetaAccessProvider)tool.getMetaAccess(), (ConstantReflectionProvider)tool.getConstantReflection())) != null) {
            return synonym;
        }
        GraalError.guarantee((!object.isConstant() || object.asJavaConstant().isNull() ? 1 : 0) != 0, (String)"Object should either not be a constant or the null constant %s", (Object)object);
        ObjectLayout objectLayout = this.getObjectLayout();
        IntegerStamp headerBitsStamp = StampFactory.forUnsignedInteger((int)(8 * objectLayout.getReferenceSize()));
        ConstantNode headerOffset = ConstantNode.forIntegerKind((JavaKind)this.target.wordJavaKind, (long)objectLayout.getHubOffset(), (StructuredGraph)graph);
        AddressNode headerAddress = (AddressNode)graph.unique((Node)new OffsetAddressNode(object, (ValueNode)headerOffset));
        ValueNode headerBits = (ValueNode)graph.unique((Node)new FloatingReadNode(headerAddress, NamedLocationIdentity.FINAL_LOCATION, null, (Stamp)headerBitsStamp, null, BarrierType.NONE));
        int reservedBitsMask = Heap.getHeap().getObjectHeader().getReservedBitsMask();
        if (reservedBitsMask != 0) {
            assert (CodeUtil.isPowerOf2((int)(reservedBitsMask + 1))) : "only the lowest bits may be set";
            int numReservedBits = CodeUtil.log2((int)(reservedBitsMask + 1));
            int compressionShift = ReferenceAccess.singleton().getCompressionShift();
            int numAlignmentBits = CodeUtil.log2((int)objectLayout.getAlignment());
            assert (compressionShift <= numAlignmentBits) : "compression discards bits";
            if (numReservedBits == numAlignmentBits && compressionShift == 0) {
                hubBits = (ValueNode)graph.unique((Node)new AndNode(headerBits, (ValueNode)ConstantNode.forIntegerStamp((Stamp)headerBitsStamp, (long)(~reservedBitsMask), (StructuredGraph)graph)));
            } else {
                hubBits = (ValueNode)graph.unique((Node)new UnsignedRightShiftNode(headerBits, (ValueNode)ConstantNode.forInt((int)numReservedBits, (StructuredGraph)graph)));
                if (compressionShift != numAlignmentBits) {
                    int shift = numAlignmentBits - compressionShift;
                    hubBits = (ValueNode)graph.unique((Node)new LeftShiftNode(hubBits, (ValueNode)ConstantNode.forInt((int)shift, (StructuredGraph)graph)));
                }
            }
        } else {
            hubBits = headerBits;
        }
        FloatingWordCastNode hubRef = (FloatingWordCastNode)graph.unique((Node)new FloatingWordCastNode((Stamp)this.hubStamp, hubBits));
        return SubstrateBasicLoweringProvider.maybeUncompress((ValueNode)hubRef);
    }

    public FieldLocationIdentity overrideFieldLocationIdentity(FieldLocationIdentity field) {
        return new SubstrateFieldLocationIdentity(field);
    }

    public int fieldOffset(ResolvedJavaField f) {
        SharedField field = (SharedField)f;
        return field.isAccessed() ? field.getLocation() : -1;
    }

    private static void lowerAssertionNode(AssertionNode n) {
        n.graph().removeFixed((FixedWithNextNode)n);
    }

    protected void lowerDeadEnd(DeadEndNode deadEnd) {
        deadEnd.replaceAndDelete(deadEnd.graph().add((Node)new LoweredDeadEndNode()));
    }

    protected Stamp loadCompressedStamp(ObjectStamp stamp) {
        return SubstrateNarrowOopStamp.compressed((AbstractObjectStamp)stamp, ReferenceAccess.singleton().getCompressEncoding());
    }

    protected ValueNode newCompressionNode(CompressionNode.CompressionOp op, ValueNode value) {
        return new SubstrateCompressionNode(op, value, ReferenceAccess.singleton().getCompressEncoding());
    }

    public boolean targetingLLVM() {
        return false;
    }
}

