/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.extended.FieldOffsetProvider;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_1)
public final class FieldOffsetNode
extends FloatingNode
implements FieldOffsetProvider,
Canonicalizable,
Lowerable {
    public static final NodeClass<FieldOffsetNode> TYPE = NodeClass.create(FieldOffsetNode.class);
    private ResolvedJavaField field;

    public static ValueNode create(JavaKind kind, ResolvedJavaField field) {
        FieldOffsetNode fieldOffset = new FieldOffsetNode(field);
        switch (kind) {
            case Long: {
                return fieldOffset;
            }
            case Int: {
                return NarrowNode.create((ValueNode)fieldOffset, (int)kind.getBitCount(), (NodeView)NodeView.DEFAULT);
            }
        }
        throw GraalError.shouldNotReachHere((String)("Unsupported kind: " + String.valueOf(kind)));
    }

    protected FieldOffsetNode(ResolvedJavaField field) {
        super(TYPE, (Stamp)StampFactory.forInteger((JavaKind)JavaKind.Long, (long)0L, (long)Integer.MAX_VALUE));
        this.field = field;
    }

    public ResolvedJavaField getField() {
        return this.field;
    }

    public Node canonical(CanonicalizerTool tool) {
        ResolvedJavaField resolvedJavaField = this.field;
        if (resolvedJavaField instanceof SharedField) {
            SharedField sharedField = (SharedField)resolvedJavaField;
            long fieldOffset = sharedField.getLocation();
            if (fieldOffset <= 0L) {
                throw VMError.shouldNotReachHere("No offset for field " + String.valueOf(this.field));
            }
            return ConstantNode.forIntegerKind((JavaKind)this.stamp.getStackKind(), (long)fieldOffset);
        }
        return this;
    }

    public void lower(LoweringTool tool) {
        throw GraalError.shouldNotReachHere((String)("Field offset must be available before first lowering: " + String.valueOf(this.field)));
    }
}

