/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class FloatingWordCastNode
extends FloatingNode
implements LIRLowerable,
Canonicalizable {
    public static final NodeClass<FloatingWordCastNode> TYPE = NodeClass.create(FloatingWordCastNode.class);
    @Node.Input
    protected ValueNode input;

    public FloatingWordCastNode(Stamp stamp, ValueNode input) {
        super(TYPE, stamp);
        this.input = input;
    }

    public ValueNode getInput() {
        return this.input;
    }

    public Node canonical(CanonicalizerTool tool) {
        if (this.hasNoUsages()) {
            return this.input;
        }
        return this;
    }

    public void generate(NodeLIRBuilderTool generator) {
        Value value = generator.operand((Node)this.input);
        LIRKind kind = generator.getLIRGeneratorTool().getLIRKind(this.stamp(NodeView.DEFAULT));
        assert (kind.getPlatformKind().getSizeInBytes() == value.getPlatformKind().getSizeInBytes());
        if (kind.equals(value.getValueKind())) {
            generator.setResult((ValueNode)this, value);
        } else {
            Variable result = generator.getLIRGeneratorTool().newVariable((ValueKind)kind);
            generator.getLIRGeneratorTool().emitMove((AllocatableValue)result, value);
            generator.setResult((ValueNode)this, (Value)result);
        }
    }
}

