/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes.aarch64;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.graal.nodes.aarch64.AArch64XPACOp;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.nativeimage.c.function.CodePointer;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public class AArch64XPACNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<AArch64XPACNode> TYPE = NodeClass.create(AArch64XPACNode.class);
    @Node.Input
    ValueNode address;

    public AArch64XPACNode(ValueNode address) {
        super(TYPE, FrameAccess.getWordStamp());
        this.address = address;
    }

    public void generate(NodeLIRBuilderTool gen) {
        LIRGeneratorTool lirGeneratorTool = gen.getLIRGeneratorTool();
        Value addressVal = gen.operand((Node)this.address);
        Variable result = lirGeneratorTool.newVariable((ValueKind)LIRKind.combine((Value[])new Value[]{addressVal}));
        lirGeneratorTool.append((LIRInstruction)new AArch64XPACOp(lirGeneratorTool.asAllocatable(addressVal), (AllocatableValue)result));
        gen.setResult((ValueNode)this, (Value)result);
    }

    @Node.NodeIntrinsic
    public static native CodePointer stripAddress(CodePointer var0);
}

