/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.nodes.NewStoredContinuationNode;
import com.oracle.svm.core.heap.CodeReferenceMapDecoder;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaFrame;
import com.oracle.svm.core.stack.JavaFrames;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.ContinuationInternals;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.Target_jdk_internal_vm_Continuation;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.extended.MembarNode;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class StoredContinuationAccess {
    private StoredContinuationAccess() {
    }

    private static StoredContinuation allocate(int framesSize) {
        int nwords = Integer.divideUnsigned(framesSize, ConfigurationValues.getTarget().wordSize);
        assert (nwords * ConfigurationValues.getTarget().wordSize == framesSize);
        StoredContinuation s = (StoredContinuation)NewStoredContinuationNode.allocate(StoredContinuation.class, Word.class, nwords);
        assert (StoredContinuationAccess.getFramesSizeInBytes(s) == framesSize);
        return s;
    }

    @Node.NodeIntrinsic(value=ArrayLengthNode.class)
    private static native int arrayLength(StoredContinuation var0);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static int getSizeInBytes(StoredContinuation s) {
        return StoredContinuationAccess.arrayLength(s) * ConfigurationValues.getTarget().wordSize;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getFramesSizeInBytes(StoredContinuation s) {
        return StoredContinuationAccess.getSizeInBytes(s);
    }

    @Uninterruptible(reason="Prevent GC during accesses via object address.", callerMustBe=true)
    public static Pointer getFramesStart(StoredContinuation s) {
        int layout = KnownIntrinsics.readHub(s).getLayoutEncoding();
        UnsignedWord baseOffset = LayoutEncoding.getArrayBaseOffset(layout);
        return Word.objectToUntrackedPointer((Object)s).add(baseOffset);
    }

    @Uninterruptible(reason="Prevent GC during accesses via object address.", callerMustBe=true)
    public static Pointer getFramesEnd(StoredContinuation s) {
        return StoredContinuationAccess.getFramesStart(s).add(StoredContinuationAccess.getFramesSizeInBytes(s));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static CodePointer getIP(StoredContinuation s) {
        return s.ip;
    }

    public static int allocateToYield(Target_jdk_internal_vm_Continuation c, Pointer baseSp, Pointer sp, CodePointer ip) {
        assert (baseSp.isNonNull() && sp.isNonNull() && ip.isNonNull());
        int framesSize = UnsignedUtils.safeToInt((UnsignedWord)baseSp.subtract((UnsignedWord)sp));
        StoredContinuation instance = StoredContinuationAccess.allocate(framesSize);
        StoredContinuationAccess.fillUninterruptibly(instance, ip, sp, framesSize);
        ContinuationInternals.setStoredContinuation(c, instance);
        return 0;
    }

    @Uninterruptible(reason="Prevent modifications to the stack while initializing instance and copying frames.")
    private static void fillUninterruptibly(StoredContinuation stored, CodePointer ip, Pointer sp, int size) {
        UnmanagedMemoryUtil.copyWordsForward(sp, StoredContinuationAccess.getFramesStart(stored), WordFactory.unsigned((int)size));
        StoredContinuationAccess.setIP(stored, ip);
        StoredContinuationAccess.afterFill(stored);
    }

    @Uninterruptible(reason="Prevent modifications to the stack while initializing instance.")
    private static void afterFill(StoredContinuation stored) {
        Object opaque = GraalDirectives.opaque((Object)stored);
        Heap.getHeap().dirtyAllReferencesOf(opaque);
    }

    public static StoredContinuation clone(StoredContinuation cont) {
        StoredContinuation clone = StoredContinuationAccess.allocate(StoredContinuationAccess.getFramesSizeInBytes(cont));
        Object preparedData = ((ContinuationSupport)ImageSingletons.lookup(ContinuationSupport.class)).prepareCopy(cont);
        return StoredContinuationAccess.fillCloneUninterruptibly(cont, clone, preparedData);
    }

    @Uninterruptible(reason="Prevent garbage collection while initializing instance and copying frames.")
    private static StoredContinuation fillCloneUninterruptibly(StoredContinuation cont, StoredContinuation clone, Object preparedData) {
        CodePointer ip = ((ContinuationSupport)ImageSingletons.lookup(ContinuationSupport.class)).copyFrames(cont, clone, preparedData);
        StoredContinuationAccess.setIP(clone, ip);
        StoredContinuationAccess.afterFill(clone);
        return clone;
    }

    @Uninterruptible(reason="Prevent that the GC sees a partially initialized StoredContinuation.", callerMustBe=true)
    private static void setIP(StoredContinuation cont, CodePointer ip) {
        MembarNode.memoryBarrier((MembarNode.FenceKind)MembarNode.FenceKind.ALLOCATION_INIT, (LocationIdentity)LocationIdentity.INIT_LOCATION);
        cont.ip = ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AlwaysInline(value="De-virtualize calls to ObjectReferenceVisitor")
    @Uninterruptible(reason="StoredContinuation must not move.", callerMustBe=true)
    public static boolean walkReferences(StoredContinuation s, ObjectReferenceVisitor visitor) {
        assert (!Heap.getHeap().isInImageHeap(s)) : "StoredContinuations in the image heap are read-only and don't need to be visited";
        JavaStackWalk walk = (JavaStackWalk)StackValue.get((int)JavaStackWalker.sizeOfJavaStackWalk());
        JavaStackWalker.initializeForContinuation(walk, s);
        while (JavaStackWalker.advanceForContinuation(walk, s)) {
            JavaFrame frame = JavaStackWalker.getCurrentFrame(walk);
            VMError.guarantee(!JavaFrames.isEntryPoint(frame), "Entry point frames are not supported");
            VMError.guarantee(!JavaFrames.isUnknownFrame(frame), "Stack walk must not encounter unknown frame");
            VMError.guarantee(Deoptimizer.checkDeoptimized(frame) == null, "Deoptimized frames are not supported");
            UntetheredCodeInfo untetheredCodeInfo = frame.getIPCodeInfo();
            Object tether = CodeInfoAccess.acquireTether(untetheredCodeInfo);
            try {
                CodeInfo codeInfo = CodeInfoAccess.convert(untetheredCodeInfo, tether);
                StoredContinuationAccess.walkFrameReferences(frame, codeInfo, visitor, s);
            }
            finally {
                CodeInfoAccess.releaseTether(untetheredCodeInfo, tether);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AlwaysInline(value="De-virtualize calls to visitor.")
    @Uninterruptible(reason="StoredContinuation must not move.", callerMustBe=true)
    public static void walkFrames(StoredContinuation s, ContinuationStackFrameVisitor visitor, ContinuationStackFrameVisitorData data) {
        assert (!Heap.getHeap().isInImageHeap(s)) : "StoredContinuations in the image heap are read-only and don't need to be visited";
        JavaStackWalk walk = (JavaStackWalk)StackValue.get((int)JavaStackWalker.sizeOfJavaStackWalk());
        JavaStackWalker.initializeForContinuation(walk, s);
        while (JavaStackWalker.advanceForContinuation(walk, s)) {
            JavaFrame frame = JavaStackWalker.getCurrentFrame(walk);
            VMError.guarantee(!JavaFrames.isEntryPoint(frame), "Entry point frames are not supported");
            VMError.guarantee(!JavaFrames.isUnknownFrame(frame), "Stack walk must not encounter unknown frame");
            VMError.guarantee(Deoptimizer.checkDeoptimized(frame) == null, "Deoptimized frames are not supported");
            UntetheredCodeInfo untetheredCodeInfo = frame.getIPCodeInfo();
            Object tether = CodeInfoAccess.acquireTether(untetheredCodeInfo);
            try {
                CodeInfo codeInfo = CodeInfoAccess.convert(untetheredCodeInfo, tether);
                NonmovableArray<Byte> referenceMapEncoding = CodeInfoAccess.getStackReferenceMapEncoding(codeInfo);
                long referenceMapIndex = frame.getReferenceMapIndex();
                if (referenceMapIndex == -1L) continue;
                visitor.visitFrame(data, frame.getSP(), referenceMapEncoding, referenceMapIndex, visitor);
            }
            finally {
                CodeInfoAccess.releaseTether(untetheredCodeInfo, tether);
            }
        }
    }

    @Uninterruptible(reason="StoredContinuation must not move.", callerMustBe=true)
    public static void walkFrameReferences(JavaFrame frame, CodeInfo codeInfo, ObjectReferenceVisitor visitor, Object holderObject) {
        NonmovableArray<Byte> referenceMapEncoding = CodeInfoAccess.getStackReferenceMapEncoding(codeInfo);
        long referenceMapIndex = frame.getReferenceMapIndex();
        if (referenceMapIndex != -1L) {
            CodeReferenceMapDecoder.walkOffsetsFromPointer((PointerBase)frame.getSP(), referenceMapEncoding, referenceMapIndex, visitor, holderObject);
        }
    }

    public static abstract class ContinuationStackFrameVisitor {
        @Uninterruptible(reason="StoredContinuation must not move.", callerMustBe=true)
        public abstract void visitFrame(ContinuationStackFrameVisitorData var1, Pointer var2, NonmovableArray<Byte> var3, long var4, ContinuationStackFrameVisitor var6);
    }

    @RawStructure
    public static interface ContinuationStackFrameVisitorData
    extends PointerBase {
    }

    private static final class PreemptVisitor
    extends StackFrameVisitor {
        private final Pointer endSP;
        private boolean startFromNextFrame = false;
        Pointer leafSP;
        CodePointer leafIP;
        int preemptStatus = 0;

        PreemptVisitor(Pointer endSP) {
            this.endSP = endSP;
        }

        @Override
        protected boolean visitRegularFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo) {
            if (sp.aboveOrEqual((UnsignedWord)this.endSP)) {
                return false;
            }
            FrameInfoQueryResult frameInfo = CodeInfoTable.lookupCodeInfoQueryResult(codeInfo, ip).getFrameInfo();
            if (frameInfo.getSourceClass().equals(StoredContinuationAccess.class) && frameInfo.getSourceMethodName().equals("allocateToYield")) {
                this.preemptStatus = -2;
                return false;
            }
            if (this.leafSP.isNull()) {
                if (this.startFromNextFrame) {
                    this.leafSP = sp;
                    this.leafIP = ip;
                } else {
                    if (frameInfo.getSourceClass().equals(Safepoint.class) && frameInfo.getSourceMethodName().equals("enterSlowPathSafepointCheck")) {
                        this.startFromNextFrame = true;
                    }
                    return true;
                }
            }
            VMError.guarantee(CodeInfoAccess.isAOTImageCode(codeInfo));
            return true;
        }

        @Override
        protected boolean visitDeoptimizedFrame(Pointer originalSP, CodePointer deoptStubIP, DeoptimizedFrame deoptimizedFrame) {
            throw VMError.shouldNotReachHere("Continuations can't contain JIT compiled code.");
        }
    }
}

