/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.jdk.Target_java_io_FileDescriptor_JNI;
import com.oracle.svm.core.jdk.Target_java_io_FileInputStream_JNI;
import com.oracle.svm.core.jdk.Target_java_io_FileOutputStream_JNI;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.word.PointerBase;

public abstract class JNIPlatformNativeLibrarySupport
extends PlatformNativeLibrarySupport {
    @Platforms(value={InternalPlatform.PLATFORM_JNI.class})
    protected void loadJavaLibrary() {
        System.loadLibrary("java");
        Target_java_io_FileDescriptor_JNI.initIDs();
        Target_java_io_FileInputStream_JNI.initIDs();
        Target_java_io_FileOutputStream_JNI.initIDs();
        JNIPlatformNativeLibrarySupport.initializeEncoding();
    }

    private static void initializeEncoding() {
        try (CTypeConversion.CCharPointerHolder name = CTypeConversion.toCString((CharSequence)System.getProperty("sun.jnu.encoding"));){
            JNIPlatformNativeLibrarySupport.nativeInitializeEncoding((PointerBase)CurrentIsolate.getCurrentThread(), name.get());
        }
    }

    @CFunction(value="InitializeEncoding")
    private static native void nativeInitializeEncoding(PointerBase var0, CCharPointer var1);
}

