/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.util.VMError;
import java.util.EnumSet;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AVXKind;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.CPUFeatureName;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton
public final class VectorAPISupport {
    private final int maxVectorBytes;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected VectorAPISupport() {
        SubstrateTargetDescription targetDescription = (SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class));
        EnumSet features = null;
        Architecture architecture = targetDescription.arch;
        if (architecture instanceof AMD64) {
            AMD64 amd64 = (AMD64)architecture;
            features = amd64.getFeatures();
        } else {
            architecture = targetDescription.arch;
            if (architecture instanceof AArch64) {
                AArch64 aarch64 = (AArch64)architecture;
                features = aarch64.getFeatures();
            }
        }
        this.maxVectorBytes = VectorAPISupport.computeMaxVectorBytes(features);
    }

    public static VectorAPISupport singleton() {
        return (VectorAPISupport)ImageSingletons.lookup(VectorAPISupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static int computeMaxVectorBytes(EnumSet<? extends CPUFeatureName> features) {
        if (features == null) {
            return -1;
        }
        if (features.contains(AArch64.CPUFeature.ASIMD)) {
            return AArch64Kind.V128_BYTE.getSizeInBytes();
        }
        if (features.contains(AMD64.CPUFeature.AVX)) {
            if (features.contains(AMD64.CPUFeature.AVX512F) && AMD64BaseAssembler.supportsFullAVX512(features)) {
                return AVXKind.AVXSize.ZMM.getBytes();
            }
            if (features.contains(AMD64.CPUFeature.AVX2)) {
                return AVXKind.AVXSize.YMM.getBytes();
            }
            if (features.contains(AMD64.CPUFeature.AVX)) {
                return AVXKind.AVXSize.XMM.getBytes();
            }
            return -1;
        }
        return -1;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public int getMaxVectorBytes() {
        return this.maxVectorBytes;
    }

    public int getMaxLaneCount(Class<?> etype) {
        int elementBytes;
        int maxVectorBits = Math.max(this.maxVectorBytes * 8, 64);
        if (etype == Byte.TYPE) {
            elementBytes = 1;
        } else if (etype == Short.TYPE) {
            elementBytes = 2;
        } else if (etype == Integer.TYPE || etype == Float.TYPE) {
            elementBytes = 4;
        } else if (etype == Long.TYPE || etype == Double.TYPE) {
            elementBytes = 8;
        } else {
            throw VMError.shouldNotReachHereUnexpectedInput(etype);
        }
        return maxVectorBits / (elementBytes * 8);
    }
}

