/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr.throttling;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.throttling.JfrEventThrottler;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class JfrEventThrottling {
    private final JfrEventThrottler objectAllocationSampleEventThrottler = new JfrEventThrottler();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrEventThrottling() {
    }

    public boolean setThrottle(long eventTypeId, long eventSampleSize, long periodMs) {
        if (eventTypeId == JfrEvent.ObjectAllocationSample.getId()) {
            this.objectAllocationSampleEventThrottler.configure(eventSampleSize, periodMs);
        }
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean shouldCommit(JfrEvent event) {
        if (event == JfrEvent.ObjectAllocationSample) {
            return this.objectAllocationSampleEventThrottler.isDisabled() || this.objectAllocationSampleEventThrottler.sample(JfrTicks.now());
        }
        assert (!event.supportsThrottling());
        return true;
    }
}

