/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jvmstat;

import jdk.graal.compiler.word.Word;

public final class PerfMemoryPrologue {
    private static final byte MAJOR_VERSION = 2;
    private static final byte MINOR_VERSION = 0;
    static final byte PERFDATA_BIG_ENDIAN = 0;
    static final byte PERFDATA_LITTLE_ENDIAN = 1;
    static final int PERFDATA_MAGIC = -889274176;
    static final int PERFDATA_PROLOGUE_OFFSET = 0;
    static final int PERFDATA_PROLOGUE_MAGIC_OFFSET = 0;
    static final int PERFDATA_PROLOGUE_BYTEORDER_OFFSET = 4;
    static final int PERFDATA_PROLOGUE_BYTEORDER_SIZE = 1;
    static final int PERFDATA_PROLOGUE_MAJOR_OFFSET = 5;
    static final int PERFDATA_PROLOGUE_MAJOR_SIZE = 1;
    static final int PERFDATA_PROLOGUE_MINOR_OFFSET = 6;
    static final int PERFDATA_PROLOGUE_MINOR_SIZE = 1;
    static final int PERFDATA_PROLOGUE_ACCESSIBLE_OFFSET = 7;
    static final int PERFDATA_PROLOGUE_ACCESSIBLE_SIZE = 1;
    static final int PERFDATA_PROLOGUE_USED_OFFSET = 8;
    static final int PERFDATA_PROLOGUE_USED_SIZE = 4;
    static final int PERFDATA_PROLOGUE_OVERFLOW_OFFSET = 12;
    static final int PERFDATA_PROLOGUE_OVERFLOW_SIZE = 4;
    static final int PERFDATA_PROLOGUE_MODTIMESTAMP_OFFSET = 16;
    static final int PERFDATA_PROLOGUE_MODTIMESTAMP_SIZE = 8;
    static final int PERFDATA_PROLOGUE_ENTRYOFFSET_OFFSET = 24;
    static final int PERFDATA_PROLOGUE_ENTRYOFFSET_SIZE = 4;
    static final int PERFDATA_PROLOGUE_NUMENTRIES_OFFSET = 28;
    static final int PERFDATA_PROLOGUE_NUMENTRIES_SIZE = 4;
    static final int PERFDATA_PROLOGUE_SIZE = 32;
    static final String PERFDATA_MAJOR_NAME = "sun.perfdata.majorVersion";
    static final String PERFDATA_MINOR_NAME = "sun.perfdata.minorVersion";
    static final String PERFDATA_BUFFER_SIZE_NAME = "sun.perfdata.size";
    static final String PERFDATA_BUFFER_USED_NAME = "sun.perfdata.used";
    static final String PERFDATA_OVERFLOW_NAME = "sun.perfdata.overflow";
    static final String PERFDATA_MODTIMESTAMP_NAME = "sun.perfdata.timestamp";
    static final String PERFDATA_NUMENTRIES_NAME = "sun.perfdata.entries";

    private PerfMemoryPrologue() {
    }

    public static void initialize(Word perfMemory, boolean platformIsBigEndian) {
        Word pos = perfMemory.add(0);
        pos.writeInt(0, platformIsBigEndian ? -889274176 : Integer.reverseBytes(-889274176));
        pos = pos.add(4);
        pos.writeByte(0, platformIsBigEndian ? (byte)0 : 1);
        pos = pos.add(1);
        pos.writeByte(0, (byte)2);
        pos = pos.add(1);
        pos.writeByte(0, (byte)0);
        pos = pos.add(1);
        pos.writeByte(0, (byte)0);
        pos = pos.add(1);
        pos.writeInt(0, 0);
        pos = pos.add(4);
        pos.writeInt(0, 0);
        pos = pos.add(4);
        pos.writeLong(0, 0L);
        pos = pos.add(8);
        pos.writeInt(0, 32);
        pos = pos.add(4);
        pos.writeInt(0, 0);
        pos = pos.add(4);
    }

    public static int getOverflow(Word perfMemory) {
        return perfMemory.readInt(12);
    }

    public static void setOverflow(Word perfMemory, int overflowSize) {
        perfMemory.writeInt(12, overflowSize);
    }

    public static void addOverflow(Word perfMemory, int size) {
        int oldOverflow = PerfMemoryPrologue.getOverflow(perfMemory);
        PerfMemoryPrologue.setOverflow(perfMemory, oldOverflow + size);
    }

    public static void setAccessible(Word perfMemory, boolean value) {
        perfMemory.writeByte(7, (byte)(value ? 1 : 0));
    }

    public static void markUpdated(Word perfMemory, long initialTime) {
        perfMemory.writeLong(16, System.nanoTime() - initialTime);
    }

    public static int getPrologueSize() {
        return 32;
    }

    public static int getNumEntries(Word perfMemory) {
        return perfMemory.readInt(28);
    }

    public static void incrementNumEntries(Word perfMemory) {
        perfMemory.writeInt(28, PerfMemoryPrologue.getNumEntries(perfMemory) + 1);
    }

    public static int getUsed(Word perfMemory) {
        return perfMemory.readInt(8);
    }

    public static void setUsed(Word perfMemory, int top) {
        perfMemory.writeInt(8, top);
    }
}

