/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.memory;

import com.oracle.svm.core.Uninterruptible;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class UntrackedNullableNativeMemory {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T malloc(UnsignedWord size) {
        return (T)UntrackedNullableNativeMemory.memory().malloc(size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T malloc(int size) {
        assert (size >= 0);
        return UntrackedNullableNativeMemory.malloc(WordFactory.unsigned((int)size));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T calloc(UnsignedWord size) {
        return (T)UntrackedNullableNativeMemory.memory().calloc(size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T calloc(int size) {
        assert (size >= 0);
        return UntrackedNullableNativeMemory.calloc(WordFactory.unsigned((int)size));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T realloc(T ptr, UnsignedWord size) {
        return (T)UntrackedNullableNativeMemory.memory().realloc(ptr, size);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T realloc(T ptr, int size) {
        assert (size >= 0);
        return UntrackedNullableNativeMemory.realloc(ptr, WordFactory.unsigned((int)size));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void free(PointerBase ptr) {
        UntrackedNullableNativeMemory.memory().free(ptr);
    }

    @Fold
    static UnmanagedMemorySupport memory() {
        return (UnmanagedMemorySupport)ImageSingletons.lookup(UnmanagedMemorySupport.class);
    }
}

