/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.meta;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class DirectSubstrateObjectConstant
extends SubstrateObjectConstant {
    private final Object object;
    private int identityHashCode;

    DirectSubstrateObjectConstant(Object object, boolean compressed, int identityHashCode) {
        super(compressed);
        this.object = object;
        this.identityHashCode = identityHashCode;
        assert (object != null);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Object getObject() {
        return this.object;
    }

    @Override
    public ResolvedJavaType getType(MetaAccessProvider provider) {
        return provider.lookupJavaType(this.object.getClass());
    }

    @Override
    public SubstrateObjectConstant compress() {
        assert (!this.compressed);
        return new DirectSubstrateObjectConstant(this.object, true, this.identityHashCode);
    }

    @Override
    public SubstrateObjectConstant uncompress() {
        assert (this.compressed);
        return new DirectSubstrateObjectConstant(this.object, false, this.identityHashCode);
    }

    @Override
    public int getIdentityHashCode() {
        if (this.identityHashCode == 0) {
            VMError.guarantee(!SubstrateUtil.HOSTED);
            this.identityHashCode = DirectSubstrateObjectConstant.computeIdentityHashCode(this.object);
        }
        return this.identityHashCode;
    }

    public String toValueString() {
        Object obj = this.object;
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.getClass().getName();
    }
}

