/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.common.option.LocatableOption;
import com.oracle.svm.common.option.MultiOptionValue;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.core.util.VMError;
import java.util.List;

public abstract class ReplacingLocatableMultiOptionValue<T>
extends LocatableMultiOptionValue<T> {
    protected ReplacingLocatableMultiOptionValue(Class<T> valueType, String delimiter, List<T> defaults) {
        super(valueType, delimiter, defaults);
    }

    protected ReplacingLocatableMultiOptionValue(ReplacingLocatableMultiOptionValue<T> other) {
        super(other);
    }

    public void valueUpdate(Object value) {
        this.values.clear();
        Object rawValue = LocatableOption.rawValue((Object)value);
        if (rawValue instanceof ReplacingLocatableMultiOptionValue) {
            ReplacingLocatableMultiOptionValue newOptionValues = (ReplacingLocatableMultiOptionValue)value;
            if (!this.valueType.isAssignableFrom(newOptionValues.valueType)) {
                VMError.shouldNotReachHere("Cannot update ReplacingLocatableMultiOptionValue of type " + String.valueOf(this.valueType) + " with value of type " + String.valueOf(newOptionValues.valueType));
            }
            for (LocatableMultiOptionValue.ValueWithOrigin p : newOptionValues.values) {
                this.values.add(new LocatableMultiOptionValue.ValueWithOrigin(this.valueType.cast(p.value()), p.origin()));
            }
        } else {
            Class<?> rawValueElementType;
            OptionOrigin origin = OptionOrigin.from(LocatableOption.valueOrigin((Object)value));
            Class<?> rawValueClass = rawValue.getClass();
            boolean multipleElements = rawValueClass.isArray();
            Class<?> clazz = rawValueElementType = multipleElements ? rawValueClass.getComponentType() : rawValueClass;
            if (!this.valueType.isAssignableFrom(rawValueElementType)) {
                VMError.shouldNotReachHere("Cannot update ReplacingLocatableMultiOptionValue of type " + String.valueOf(this.valueType) + " with value of type " + String.valueOf(rawValueElementType));
            }
            if (multipleElements) {
                for (Object singleRawValue : (Object[])rawValue) {
                    this.values.add(new LocatableMultiOptionValue.ValueWithOrigin(this.valueType.cast(singleRawValue), origin));
                }
            } else {
                this.values.add(new LocatableMultiOptionValue.ValueWithOrigin(this.valueType.cast(rawValue), origin));
            }
        }
    }

    public static final class DelimitedString
    extends ReplacingLocatableMultiOptionValue<String> {
        private DelimitedString(DelimitedString other) {
            super(other);
        }

        public MultiOptionValue<String> createCopy() {
            return new DelimitedString(this);
        }

        public boolean contains(String s) {
            return this.values.stream().map(LocatableMultiOptionValue.ValueWithOrigin::value).anyMatch(val -> val.equals(s));
        }

        private DelimitedString(String delimiter, List<String> defaultStrings) {
            super(String.class, delimiter, defaultStrings);
        }

        public static DelimitedString build() {
            return new DelimitedString("", List.of());
        }

        public static DelimitedString buildWithCommaDelimiter() {
            return new DelimitedString(",", List.of());
        }

        public static DelimitedString buildWithCommaDelimiter(String ... defaultStrings) {
            return new DelimitedString(",", List.of(defaultStrings));
        }
    }
}

