/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.IsolateArguments;
import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.os.ChunkBasedCommittedMemoryProvider;
import com.oracle.svm.core.os.ImageHeapProvider;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class OSCommittedMemoryProvider
extends ChunkBasedCommittedMemoryProvider {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public OSCommittedMemoryProvider() {
    }

    @Override
    @Uninterruptible(reason="Still being initialized.")
    public int initialize(WordPointer heapBasePointer, IsolateArguments arguments) {
        if (!SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            int result = OSCommittedMemoryProvider.protectSingleIsolateImageHeap();
            if (result == 0) {
                heapBasePointer.write((WordBase)Isolates.IMAGE_HEAP_BEGIN.get());
            }
            return result;
        }
        return ImageHeapProvider.get().initialize((Pointer)WordFactory.nullPointer(), (UnsignedWord)WordFactory.zero(), heapBasePointer, (WordPointer)WordFactory.nullPointer());
    }

    @Override
    @Uninterruptible(reason="Tear-down in progress.")
    public int tearDown() {
        if (!SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            return 0;
        }
        return ImageHeapProvider.get().freeImageHeap((PointerBase)KnownIntrinsics.heapBase());
    }
}

