/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jdk.RuntimeSupportFeature;
import com.oracle.svm.core.posix.IgnoreSignalsStartupHook;
import com.oracle.svm.core.posix.PosixSignalHandlerSupport;
import com.oracle.svm.core.posix.headers.Signal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class PosixSignalHandlerFeature
implements InternalFeature {
    PosixSignalHandlerFeature() {
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return List.of(RuntimeSupportFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        PosixSignalHandlerFeature.setSignalData();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        RuntimeSupport.getRuntimeSupport().addStartupHook(new IgnoreSignalsStartupHook());
    }

    private static void setSignalData() {
        int sigNum;
        int maxSigNum = 0;
        HashMap<String, Integer> signalNameToSignalNum = new HashMap<String, Integer>();
        for (Signal.SignalEnum signalEnum : Signal.SignalEnum.values()) {
            sigNum = signalEnum.getCValue();
            maxSigNum = Math.max(sigNum, maxSigNum);
            signalNameToSignalNum.put(PosixSignalHandlerFeature.getJavaSignalName(signalEnum.name()), sigNum);
        }
        if (Platform.includedIn(Platform.LINUX.class)) {
            for (Enum enum_ : Signal.LinuxSignalEnum.values()) {
                sigNum = ((Signal.LinuxSignalEnum)enum_).getCValue();
                maxSigNum = Math.max(sigNum, maxSigNum);
                signalNameToSignalNum.put(PosixSignalHandlerFeature.getJavaSignalName(enum_.name()), sigNum);
            }
        } else if (Platform.includedIn(Platform.DARWIN.class)) {
            for (Enum enum_ : Signal.DarwinSignalEnum.values()) {
                sigNum = ((Signal.DarwinSignalEnum)enum_).getCValue();
                maxSigNum = Math.max(sigNum, maxSigNum);
                signalNameToSignalNum.put(PosixSignalHandlerFeature.getJavaSignalName(enum_.name()), sigNum);
            }
        }
        boolean[] supportedSignals = new boolean[maxSigNum + 1];
        for (Map.Entry entry : signalNameToSignalNum.entrySet()) {
            supportedSignals[((Integer)entry.getValue()).intValue()] = true;
        }
        Map<String, Integer> map = Map.copyOf(signalNameToSignalNum);
        PosixSignalHandlerSupport.singleton().setData(map, supportedSignals);
    }

    private static String getJavaSignalName(String name) {
        assert (name.startsWith("SIG"));
        return name.substring(3);
    }
}

