/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.pltgot.GOTHeapSupport;
import com.oracle.svm.core.posix.headers.Mman;
import com.oracle.svm.core.posix.headers.darwin.DarwinVirtualMemory;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class DarwinGOTHeapSupport
extends GOTHeapSupport {
    private static final CGlobalData<WordPointer> DARWIN_GOT_START_ADDRESS = CGlobalDataFactory.createWord();

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected int initialize(WordPointer gotStartAddress) {
        int flags = Mman.MAP_ANON() | Mman.MAP_PRIVATE();
        Pointer gotMemory = Mman.NoTransitions.mmap(WordFactory.nullPointer(), DarwinGOTHeapSupport.getPageAlignedGotSize(), Mman.PROT_READ() | Mman.PROT_WRITE(), flags, -1, 0L);
        if (gotMemory.isNull() || gotMemory.equal((ComparableWord)Mman.MAP_FAILED())) {
            return 25;
        }
        Pointer gotStartInMemory = gotMemory.add(DarwinGOTHeapSupport.getGotOffsetFromStartOfMapping());
        LibC.memcpy(gotStartInMemory, IMAGE_GOT_BEGIN.get(), DarwinGOTHeapSupport.getGotSectionSize());
        gotStartAddress.write((WordBase)gotMemory);
        DARWIN_GOT_START_ADDRESS.get().write((WordBase)gotMemory);
        return 0;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int mapGot(Pointer start) {
        WordPointer taskSelf = DarwinVirtualMemory.mach_task_self();
        int ret = DarwinVirtualMemory.vm_deallocate(DarwinVirtualMemory.mach_task_self(), (WordBase)start, DarwinGOTHeapSupport.getPageAlignedGotSize());
        if (ret != 0) {
            return 28;
        }
        WordPointer gotStart = (WordPointer)StackValue.get(WordPointer.class);
        gotStart.write((WordBase)start);
        CIntPointer currentProt = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer maxProt = (CIntPointer)StackValue.get(CIntPointer.class);
        int intFalse = 0;
        ret = DarwinVirtualMemory.vm_remap(taskSelf, (WordBase)gotStart, DarwinGOTHeapSupport.getPageAlignedGotSize(), (WordBase)WordFactory.nullPointer(), intFalse, taskSelf, DARWIN_GOT_START_ADDRESS.get().read(), intFalse, currentProt, maxProt, DarwinVirtualMemory.VM_INHERIT_SHARE());
        if (ret != 0) {
            return 29;
        }
        if (currentProt.read() != Mman.PROT_READ() && (ret = VirtualMemoryProvider.get().protect((PointerBase)start, DarwinGOTHeapSupport.getPageAlignedGotSize(), 1)) != 0) {
            return ret;
        }
        return 0;
    }
}

