/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.headers.linux.LinuxPthread;
import com.oracle.svm.core.posix.headers.linux.LinuxTime;
import com.oracle.svm.core.posix.linux.LinuxLibCHelper;
import com.oracle.svm.core.thread.ThreadCpuTimeSupport;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.BasedOnJDKFile;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CIntPointer;

@AutomaticallyRegisteredImageSingleton(value={ThreadCpuTimeSupport.class})
public class LinuxThreadCpuTimeSupport
implements ThreadCpuTimeSupport {
    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getCurrentThreadCpuTime(boolean includeSystemTime) {
        if (!includeSystemTime) {
            int tid = (int)VMThreads.getOSThreadId(CurrentIsolate.getCurrentThread()).rawValue();
            return LinuxLibCHelper.getThreadUserTimeSlow(tid);
        }
        return LinuxThreadCpuTimeSupport.fastThreadCpuTime(LinuxTime.CLOCK_THREAD_CPUTIME_ID());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getThreadCpuTime(IsolateThread isolateThread, boolean includeSystemTime) {
        if (!includeSystemTime) {
            int tid = (int)VMThreads.getOSThreadId(isolateThread).rawValue();
            return LinuxLibCHelper.getThreadUserTimeSlow(tid);
        }
        Pthread.pthread_t pthread = (Pthread.pthread_t)VMThreads.getOSThreadHandle(isolateThread);
        return LinuxThreadCpuTimeSupport.fastCpuTime(pthread);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+10/src/hotspot/os/linux/os_linux.cpp#L5113-L5125")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static long fastCpuTime(Pthread.pthread_t pthread) {
        CIntPointer threadsClockId = (CIntPointer)StackValue.get((int)4);
        if (LinuxPthread.pthread_getcpuclockid(pthread, threadsClockId) != 0) {
            return -1L;
        }
        return LinuxThreadCpuTimeSupport.fastThreadCpuTime(threadsClockId.read());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-23+10/src/hotspot/os/linux/os_linux.cpp#L4317-L4322")
    private static long fastThreadCpuTime(int clockId) {
        Time.timespec time = UnsafeStackValue.get(Time.timespec.class);
        if (LinuxTime.NoTransitions.clock_gettime(clockId, time) != 0) {
            return -1L;
        }
        return time.tv_sec() * 1000000000L + time.tv_nsec();
    }
}

