/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.core.memory.NullableNativeMemory;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.headers.FileAPI;
import com.oracle.svm.core.windows.headers.LibLoaderAPI;
import com.oracle.svm.core.windows.headers.Process;
import com.oracle.svm.core.windows.headers.SysinfoAPI;
import com.oracle.svm.core.windows.headers.VerRsrc;
import com.oracle.svm.core.windows.headers.WinBase;
import com.oracle.svm.core.windows.headers.WinVer;
import com.oracle.svm.core.windows.headers.WindowsLibC;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.VoidPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.WINDOWS.class})
public class WindowsSystemPropertiesSupport
extends SystemPropertiesSupport {
    private static final byte[] USERNAME = "USERNAME\u0000".getBytes(StandardCharsets.UTF_16LE);
    private static final byte[] KERNEL32_DLL = "\\kernel32.dll\u0000".getBytes(StandardCharsets.UTF_16LE);
    private static final byte[] ROOT_PATH = "\\\u0000".getBytes(StandardCharsets.UTF_16LE);
    private static final int VER_NT_WORKSTATION = 1;
    private static final int VER_PLATFORM_WIN32_WINDOWS = 1;
    private static final int VER_PLATFORM_WIN32_NT = 2;
    private static final byte[] PATH = "PATH\u0000".getBytes(StandardCharsets.UTF_16LE);
    private String cachedOsName;
    private String cachedOsVersion;

    @Override
    protected String userNameValue() {
        UnsignedWord length;
        WindowsLibC.WCharPointer userName = WindowsLibC._wgetenv((WindowsLibC.WCharPointer)NonmovableArrays.addressOf(NonmovableArrays.fromImageHeap((Object)USERNAME), 0));
        if (userName.isNonNull() && (length = WindowsLibC.wcslen(userName)).aboveThan(0)) {
            return WindowsSystemPropertiesSupport.toJavaString(userName, Math.toIntExact(length.rawValue()));
        }
        int maxLength = 257;
        userName = UnsafeStackValue.get(maxLength, WindowsLibC.WCharPointer.class);
        CIntPointer lengthPointer = UnsafeStackValue.get(CIntPointer.class);
        lengthPointer.write(maxLength);
        if (WinBase.GetUserNameW(userName, lengthPointer) != 0) {
            return WindowsSystemPropertiesSupport.toJavaString(userName, lengthPointer.read() - 1);
        }
        return "unknown";
    }

    @Override
    protected String userHomeValue() {
        WinBase.LPHANDLE tokenHandle = UnsafeStackValue.get(WinBase.LPHANDLE.class);
        if (Process.NoTransitions.OpenProcessToken(Process.NoTransitions.GetCurrentProcess(), Process.TOKEN_QUERY(), tokenHandle) == 0) {
            return "C:\\";
        }
        int initialLen = 261;
        CIntPointer buffLenPointer = UnsafeStackValue.get(CIntPointer.class);
        buffLenPointer.write(initialLen);
        WindowsLibC.WCharPointer userHome = UnsafeStackValue.get(initialLen, WindowsLibC.WCharPointer.class);
        int result = WinBase.GetUserProfileDirectoryW(tokenHandle.read(), userHome, buffLenPointer);
        WinBase.CloseHandle(tokenHandle.read());
        if (result == 0) {
            return "C:\\";
        }
        return WindowsSystemPropertiesSupport.toJavaString(userHome, buffLenPointer.read() - 1);
    }

    @Override
    protected String userDirValue() {
        int maxLength = 260;
        WindowsLibC.WCharPointer userDir = UnsafeStackValue.get(maxLength, WindowsLibC.WCharPointer.class);
        int length = WinBase.GetCurrentDirectoryW(maxLength, userDir);
        VMError.guarantee(length > 0 && length < maxLength, "Could not determine value of user.dir");
        return WindowsSystemPropertiesSupport.toJavaString(userDir, length);
    }

    @Override
    protected String javaIoTmpdirValue() {
        int maxLength = 261;
        WindowsLibC.WCharPointer tmpdir = UnsafeStackValue.get(maxLength, WindowsLibC.WCharPointer.class);
        int length = FileAPI.GetTempPathW(maxLength, tmpdir);
        VMError.guarantee(length > 0, "Could not determine value of java.io.tmpdir");
        return WindowsSystemPropertiesSupport.toJavaString(tmpdir, length);
    }

    @Override
    protected String javaLibraryPathValue() {
        WindowsLibC.WCharPointer tmp = UnsafeStackValue.get(260, WindowsLibC.WCharPointer.class);
        WindowsLibC.WCharPointer path = WindowsLibC._wgetenv((WindowsLibC.WCharPointer)NonmovableArrays.addressOf(NonmovableArrays.fromImageHeap((Object)PATH), 0));
        int pathLength = path.isNonNull() ? Math.toIntExact(WindowsLibC.wcslen(path).rawValue()) : 0;
        StringBuilder libraryPath = new StringBuilder(780 + pathLength + 5);
        int tmpLength = LibLoaderAPI.GetModuleFileNameW((WinBase.HMODULE)WordFactory.nullPointer(), tmp, 260);
        VMError.guarantee(tmpLength > 0 && tmpLength < 260);
        libraryPath.append(WindowsSystemPropertiesSupport.asCharBuffer(tmp, tmpLength));
        libraryPath.setLength(libraryPath.lastIndexOf("\\"));
        tmpLength = SysinfoAPI.GetSystemDirectoryW(tmp, 260);
        VMError.guarantee(tmpLength > 0 && tmpLength < 260);
        libraryPath.append(';');
        libraryPath.append(WindowsSystemPropertiesSupport.asCharBuffer(tmp, tmpLength));
        tmpLength = SysinfoAPI.GetWindowsDirectoryW(tmp, 260);
        VMError.guarantee(tmpLength > 0 && tmpLength < 260);
        libraryPath.append(';');
        libraryPath.append(WindowsSystemPropertiesSupport.asCharBuffer(tmp, tmpLength));
        if (path.isNonNull()) {
            libraryPath.append(';');
            libraryPath.append(WindowsSystemPropertiesSupport.asCharBuffer(path, pathLength));
        }
        libraryPath.append(";.");
        return libraryPath.toString();
    }

    static String toJavaString(WindowsLibC.WCharPointer wcString, int length) {
        return WindowsSystemPropertiesSupport.asCharBuffer(wcString, length).toString();
    }

    private static CharBuffer asCharBuffer(WindowsLibC.WCharPointer wcString, int length) {
        return CTypeConversion.asByteBuffer((PointerBase)wcString, (int)(length * SizeOf.get(WindowsLibC.WCharPointer.class))).order(ByteOrder.LITTLE_ENDIAN).asCharBuffer();
    }

    @Override
    protected String osNameValue() {
        if (this.cachedOsName == null) {
            this.computeOsNameAndVersion();
        }
        return this.cachedOsName;
    }

    @Override
    protected String osVersionValue() {
        if (this.cachedOsVersion == null) {
            this.computeOsNameAndVersion();
        }
        return this.cachedOsVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeOsNameAndVersion() {
        SysinfoAPI.OSVERSIONINFOEXA ver = UnsafeStackValue.get(SysinfoAPI.OSVERSIONINFOEXA.class);
        ver.dwOSVersionInfoSize(SizeOf.get(SysinfoAPI.OSVERSIONINFOEXA.class));
        SysinfoAPI.GetVersionExA(ver);
        boolean is64bit = ((Platform)ImageSingletons.lookup(Platform.class)).getArchitecture().endsWith("64");
        boolean isWorkstation = ver.wProductType() == 1;
        int platformId = ver.dwPlatformId();
        int majorVersion = ver.dwMajorVersion();
        int minorVersion = ver.dwMinorVersion();
        int buildNumber = ver.dwBuildNumber();
        WindowsLibC.WCharPointer kernel32Path = UnsafeStackValue.get(260, WindowsLibC.WCharPointer.class);
        WindowsLibC.WCharPointer kernel32Dll = (WindowsLibC.WCharPointer)NonmovableArrays.addressOf(NonmovableArrays.fromImageHeap((Object)KERNEL32_DLL), 0);
        int len = 260 - (int)WindowsLibC.wcslen(kernel32Dll).rawValue() - 1;
        int ret = SysinfoAPI.GetSystemDirectoryW(kernel32Path, len);
        if (ret != 0 && ret <= len) {
            VoidPointer versionInfo;
            WindowsLibC.wcsncat(kernel32Path, kernel32Dll, WordFactory.unsigned((int)(260 - ret)));
            int versionSize = WinVer.GetFileVersionInfoSizeW(kernel32Path, (CIntPointer)WordFactory.nullPointer());
            if (versionSize != 0 && !(versionInfo = (VoidPointer)NullableNativeMemory.malloc(WordFactory.unsigned((int)versionSize), NmtCategory.Internal)).isNull()) {
                try {
                    CIntPointer lengthPointer;
                    WordPointer fileInfoPointer;
                    WindowsLibC.WCharPointer rootPath;
                    if (WinVer.GetFileVersionInfoW(kernel32Path, 0, versionSize, versionInfo) != 0 && WinVer.VerQueryValueW(versionInfo, rootPath = (WindowsLibC.WCharPointer)NonmovableArrays.addressOf(NonmovableArrays.fromImageHeap((Object)ROOT_PATH), 0), fileInfoPointer = UnsafeStackValue.get(WordPointer.class), lengthPointer = UnsafeStackValue.get(CIntPointer.class)) != 0) {
                        VerRsrc.VS_FIXEDFILEINFO fileInfo = (VerRsrc.VS_FIXEDFILEINFO)fileInfoPointer.read();
                        majorVersion = (short)(fileInfo.dwProductVersionMS() >> 16);
                        minorVersion = (short)fileInfo.dwProductVersionMS();
                        buildNumber = (short)(fileInfo.dwProductVersionLS() >> 16);
                    }
                }
                finally {
                    NullableNativeMemory.free((PointerBase)versionInfo);
                }
            }
        }
        this.cachedOsVersion = majorVersion + "." + minorVersion;
        this.cachedOsName = switch (platformId) {
            case 1 -> {
                if (majorVersion == 4) {
                    switch (minorVersion) {
                        case 0: {
                            yield "Windows 95";
                        }
                        case 10: {
                            yield "Windows 98";
                        }
                        case 90: {
                            yield "Windows Me";
                        }
                    }
                    yield "Windows 9X (unknown)";
                }
                yield "Windows 9X (unknown)";
            }
            case 2 -> {
                if (majorVersion <= 4) {
                    yield "Windows NT";
                }
                if (majorVersion == 5) {
                    switch (minorVersion) {
                        case 0: {
                            yield "Windows 2000";
                        }
                        case 1: {
                            yield "Windows XP";
                        }
                        case 2: {
                            if (isWorkstation && is64bit) {
                                yield "Windows XP";
                            }
                            yield "Windows 2003";
                        }
                    }
                    yield "Windows NT (unknown)";
                }
                if (majorVersion == 6) {
                    if (isWorkstation) {
                        switch (minorVersion) {
                            case 0: {
                                yield "Windows Vista";
                            }
                            case 1: {
                                yield "Windows 7";
                            }
                            case 2: {
                                yield "Windows 8";
                            }
                            case 3: {
                                yield "Windows 8.1";
                            }
                        }
                        yield "Windows NT (unknown)";
                    }
                    switch (minorVersion) {
                        case 0: {
                            yield "Windows Server 2008";
                        }
                        case 1: {
                            yield "Windows Server 2008 R2";
                        }
                        case 2: {
                            yield "Windows Server 2012";
                        }
                        case 3: {
                            yield "Windows Server 2012 R2";
                        }
                    }
                    yield "Windows NT (unknown)";
                }
                if (majorVersion == 10) {
                    if (isWorkstation) {
                        switch (minorVersion) {
                            case 0: {
                                if (buildNumber >= 22000) {
                                    yield "Windows 11";
                                }
                                yield "Windows 10";
                            }
                        }
                        yield "Windows NT (unknown)";
                    }
                    switch (minorVersion) {
                        case 0: {
                            if (buildNumber > 20347) {
                                yield "Windows Server 2022";
                            }
                            if (buildNumber > 17762) {
                                yield "Windows Server 2019";
                            }
                            yield "Windows Server 2016";
                        }
                    }
                    yield "Windows NT (unknown)";
                }
                yield "Windows NT (unknown)";
            }
            default -> "Windows (unknown)";
        };
    }
}

