/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Proxy;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticallyRegisteredFeature
public class AnnotationFeature
implements InternalFeature {
    private final Set<Class<? extends Annotation>> processedTypes = ConcurrentHashMap.newKeySet();

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        access.registerObjectReachableCallback(Annotation.class, this::registerDeclaredMethods);
    }

    private void registerDeclaredMethods(Feature.DuringAnalysisAccess access, Annotation annotation, ObjectScanner.ScanReason reason) {
        Class<? extends Annotation> annotationType;
        if (Proxy.isProxyClass(annotation.getClass()) && this.processedTypes.add(annotationType = annotation.annotationType())) {
            RuntimeReflection.registerAllDeclaredMethods(annotationType);
            RuntimeReflection.register((Executable[])annotationType.getDeclaredMethods());
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        access.registerSubtypeReachabilityHandler(this::registerArrayClass, Annotation.class);
    }

    private void registerArrayClass(Feature.DuringAnalysisAccess access, Class<?> subclass) {
        if (subclass.isAnnotation()) {
            Class<?> arrayClass = Array.newInstance(subclass, 0).getClass();
            access.registerAsInHeap(arrayClass);
        }
    }
}

